/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.ConstantNullBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class AggregateMetricDoubleArrayBlock
extends AbstractNonThreadSafeRefCounted
implements AggregateMetricDoubleBlock {
    public static final TransportVersion WRITE_TYPED_BLOCK = TransportVersion.fromName((String)"aggregate_metric_double_typed_block");
    private final DoubleBlock minBlock;
    private final DoubleBlock maxBlock;
    private final DoubleBlock sumBlock;
    private final IntBlock countBlock;
    private final int positionCount;

    public AggregateMetricDoubleArrayBlock(DoubleBlock minBlock, DoubleBlock maxBlock, DoubleBlock sumBlock, IntBlock countBlock) {
        this.minBlock = minBlock;
        this.maxBlock = maxBlock;
        this.sumBlock = sumBlock;
        this.countBlock = countBlock;
        this.positionCount = minBlock.getPositionCount();
        for (Block block : List.of(minBlock, maxBlock, sumBlock, countBlock)) {
            if (block.getPositionCount() != this.positionCount) {
                assert (false) : "expected positionCount=" + this.positionCount + " but was " + String.valueOf(block);
                throw new IllegalArgumentException("expected positionCount=" + this.positionCount + " but was " + String.valueOf(block));
            }
            if (!block.isReleased()) continue;
            assert (false) : "can't build aggregate_metric_double block out of released blocks but [" + String.valueOf(block) + "] was released";
            throw new IllegalArgumentException("can't build aggregate_metric_double block out of released blocks but [" + String.valueOf(block) + "] was released");
        }
    }

    public static AggregateMetricDoubleArrayBlock fromCompositeBlock(CompositeBlock block) {
        assert (block.getBlockCount() == 4) : "Can't make AggregateMetricDoubleBlock out of CompositeBlock with " + block.getBlockCount() + " blocks";
        DoubleBlock min = (DoubleBlock)block.getBlock(AggregateMetricDoubleBlockBuilder.Metric.MIN.getIndex());
        DoubleBlock max = (DoubleBlock)block.getBlock(AggregateMetricDoubleBlockBuilder.Metric.MAX.getIndex());
        DoubleBlock sum = (DoubleBlock)block.getBlock(AggregateMetricDoubleBlockBuilder.Metric.SUM.getIndex());
        IntBlock count = (IntBlock)block.getBlock(AggregateMetricDoubleBlockBuilder.Metric.COUNT.getIndex());
        return new AggregateMetricDoubleArrayBlock(min, max, sum, count);
    }

    public CompositeBlock asCompositeBlock() {
        Block[] blocks = new Block[4];
        blocks[AggregateMetricDoubleBlockBuilder.Metric.MIN.getIndex()] = this.minBlock;
        blocks[AggregateMetricDoubleBlockBuilder.Metric.MAX.getIndex()] = this.maxBlock;
        blocks[AggregateMetricDoubleBlockBuilder.Metric.SUM.getIndex()] = this.sumBlock;
        blocks[AggregateMetricDoubleBlockBuilder.Metric.COUNT.getIndex()] = this.countBlock;
        return new CompositeBlock(blocks);
    }

    @Override
    protected void closeInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.minBlock, this.maxBlock, this.sumBlock, this.countBlock});
    }

    @Override
    public Vector asVector() {
        return null;
    }

    @Override
    public int getTotalValueCount() {
        int totalValueCount = 0;
        for (Block block : List.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock)) {
            totalValueCount += block.getTotalValueCount();
        }
        return totalValueCount;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getFirstValueIndex(int position) {
        return this.minBlock.getFirstValueIndex(position);
    }

    @Override
    public int getValueCount(int position) {
        int max = 0;
        for (Block block : List.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock)) {
            max = Math.max(max, block.getValueCount(position));
        }
        return max;
    }

    @Override
    public ElementType elementType() {
        return ElementType.AGGREGATE_METRIC_DOUBLE;
    }

    @Override
    public BlockFactory blockFactory() {
        return this.minBlock.blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        for (Block block : List.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock)) {
            block.allowPassingToDifferentDriver();
        }
    }

    @Override
    public boolean isNull(int position) {
        for (Block block : List.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock)) {
            if (block.isNull(position)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean mayHaveNulls() {
        return Stream.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock).anyMatch(Block::mayHaveNulls);
    }

    @Override
    public boolean areAllValuesNull() {
        return Stream.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock).allMatch(Block::areAllValuesNull);
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return Stream.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock).anyMatch(Block::mayHaveMultivaluedFields);
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        if (Stream.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock).noneMatch(Block::mayHaveMultivaluedFields)) {
            return false;
        }
        return Stream.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock).anyMatch(Block::doesHaveMultivaluedFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateMetricDoubleBlock filter(int ... positions) {
        AggregateMetricDoubleArrayBlock aggregateMetricDoubleArrayBlock;
        block3: {
            AggregateMetricDoubleArrayBlock result = null;
            DoubleBlock newMinBlock = null;
            DoubleBlock newMaxBlock = null;
            DoubleBlock newSumBlock = null;
            IntBlock newCountBlock = null;
            try {
                newMinBlock = this.minBlock.filter(positions);
                newMaxBlock = this.maxBlock.filter(positions);
                newSumBlock = this.sumBlock.filter(positions);
                newCountBlock = this.countBlock.filter(positions);
                aggregateMetricDoubleArrayBlock = result = new AggregateMetricDoubleArrayBlock(newMinBlock, newMaxBlock, newSumBlock, newCountBlock);
                if (result != null) break block3;
            }
            catch (Throwable throwable) {
                if (result == null) {
                    Releasables.close((Releasable[])new Releasable[]{newMinBlock, newMaxBlock, newSumBlock, newCountBlock});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{newMinBlock, newMaxBlock, newSumBlock, newCountBlock});
        }
        return aggregateMetricDoubleArrayBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateMetricDoubleBlock keepMask(BooleanVector mask) {
        AggregateMetricDoubleArrayBlock aggregateMetricDoubleArrayBlock;
        block3: {
            AggregateMetricDoubleArrayBlock result = null;
            DoubleBlock newMinBlock = null;
            DoubleBlock newMaxBlock = null;
            DoubleBlock newSumBlock = null;
            IntBlock newCountBlock = null;
            try {
                newMinBlock = this.minBlock.keepMask(mask);
                newMaxBlock = this.maxBlock.keepMask(mask);
                newSumBlock = this.sumBlock.keepMask(mask);
                newCountBlock = this.countBlock.keepMask(mask);
                aggregateMetricDoubleArrayBlock = result = new AggregateMetricDoubleArrayBlock(newMinBlock, newMaxBlock, newSumBlock, newCountBlock);
                if (result != null) break block3;
            }
            catch (Throwable throwable) {
                if (result == null) {
                    Releasables.close((Releasable[])new Releasable[]{newMinBlock, newMaxBlock, newSumBlock, newCountBlock});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{newMinBlock, newMaxBlock, newSumBlock, newCountBlock});
        }
        return aggregateMetricDoubleArrayBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block deepCopy(BlockFactory blockFactory) {
        AggregateMetricDoubleArrayBlock aggregateMetricDoubleArrayBlock;
        block3: {
            AggregateMetricDoubleArrayBlock result = null;
            DoubleBlock newMinBlock = null;
            DoubleBlock newMaxBlock = null;
            DoubleBlock newSumBlock = null;
            IntBlock newCountBlock = null;
            try {
                newMinBlock = this.minBlock.deepCopy(blockFactory);
                newMaxBlock = this.maxBlock.deepCopy(blockFactory);
                newSumBlock = this.sumBlock.deepCopy(blockFactory);
                newCountBlock = this.countBlock.deepCopy(blockFactory);
                aggregateMetricDoubleArrayBlock = result = new AggregateMetricDoubleArrayBlock(newMinBlock, newMaxBlock, newSumBlock, newCountBlock);
                if (result != null) break block3;
            }
            catch (Throwable throwable) {
                if (result == null) {
                    Releasables.close((Releasable[])new Releasable[]{newMinBlock, newMaxBlock, newSumBlock, newCountBlock});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{newMinBlock, newMaxBlock, newSumBlock, newCountBlock});
        }
        return aggregateMetricDoubleArrayBlock;
    }

    @Override
    public ReleasableIterator<? extends AggregateMetricDoubleBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("can't lookup values from AggregateMetricDoubleBlock");
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public AggregateMetricDoubleBlock expand() {
        this.incRef();
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(WRITE_TYPED_BLOCK)) {
            for (Block block : List.of(this.minBlock, this.maxBlock, this.sumBlock, this.countBlock)) {
                Block.writeTypedBlock(block, out);
            }
        } else {
            for (DoubleBlock doubleBlock : List.of(this.minBlock, this.maxBlock, this.sumBlock)) {
                Block notConstantNull = this.replaceConstantNullBlock(doubleBlock, this.blockFactory()::newDoubleBlockBuilder);
                try {
                    notConstantNull.writeTo(out);
                }
                finally {
                    if (notConstantNull == null) continue;
                    notConstantNull.close();
                }
            }
            try (Block notConstantNull = this.replaceConstantNullBlock(this.countBlock, this.blockFactory()::newIntBlockBuilder);){
                notConstantNull.writeTo(out);
            }
        }
    }

    private Block replaceConstantNullBlock(Block block, IntFunction<Block.Builder> builderProducer) {
        if (block instanceof ConstantNullBlock) {
            try (Block.Builder builder = builderProducer.apply(block.getPositionCount());){
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    builder.appendNull();
                }
                Block block2 = builder.build();
                return block2;
            }
        }
        block.incRef();
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Block readFrom(StreamInput in) throws IOException {
        AggregateMetricDoubleArrayBlock aggregateMetricDoubleArrayBlock;
        block5: {
            boolean success = false;
            DoubleBlock minBlock = null;
            DoubleBlock maxBlock = null;
            DoubleBlock sumBlock = null;
            IntBlock countBlock = null;
            BlockStreamInput blockStreamInput = (BlockStreamInput)in;
            try {
                if (in.getTransportVersion().supports(WRITE_TYPED_BLOCK)) {
                    minBlock = (DoubleBlock)Block.readTypedBlock(blockStreamInput);
                    maxBlock = (DoubleBlock)Block.readTypedBlock(blockStreamInput);
                    sumBlock = (DoubleBlock)Block.readTypedBlock(blockStreamInput);
                    countBlock = (IntBlock)Block.readTypedBlock(blockStreamInput);
                } else {
                    minBlock = DoubleBlock.readFrom(blockStreamInput);
                    maxBlock = DoubleBlock.readFrom(blockStreamInput);
                    sumBlock = DoubleBlock.readFrom(blockStreamInput);
                    countBlock = IntBlock.readFrom(blockStreamInput);
                }
                AggregateMetricDoubleArrayBlock result = new AggregateMetricDoubleArrayBlock(minBlock, maxBlock, sumBlock, countBlock);
                success = true;
                aggregateMetricDoubleArrayBlock = result;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock});
        }
        return aggregateMetricDoubleArrayBlock;
    }

    public long ramBytesUsed() {
        return this.minBlock.ramBytesUsed() + this.maxBlock.ramBytesUsed() + this.sumBlock.ramBytesUsed() + this.countBlock.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AggregateMetricDoubleBlock) {
            AggregateMetricDoubleBlock that = (AggregateMetricDoubleBlock)obj;
            return AggregateMetricDoubleBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return AggregateMetricDoubleBlock.hash(this);
    }

    @Override
    public DoubleBlock minBlock() {
        return this.minBlock;
    }

    @Override
    public DoubleBlock maxBlock() {
        return this.maxBlock;
    }

    @Override
    public DoubleBlock sumBlock() {
        return this.sumBlock;
    }

    @Override
    public IntBlock countBlock() {
        return this.countBlock;
    }

    @Override
    public Block getMetricBlock(int index) {
        if (index == AggregateMetricDoubleBlockBuilder.Metric.MIN.getIndex()) {
            return this.minBlock;
        }
        if (index == AggregateMetricDoubleBlockBuilder.Metric.MAX.getIndex()) {
            return this.maxBlock;
        }
        if (index == AggregateMetricDoubleBlockBuilder.Metric.SUM.getIndex()) {
            return this.sumBlock;
        }
        if (index == AggregateMetricDoubleBlockBuilder.Metric.COUNT.getIndex()) {
            return this.countBlock;
        }
        throw new UnsupportedOperationException("Received an index (" + index + ") outside of range for AggregateMetricDoubleBlock.");
    }

    public String toString() {
        String valuesString = Stream.of(AggregateMetricDoubleBlockBuilder.Metric.values()).map(metric -> metric.getLabel() + "=" + String.valueOf(this.getMetricBlock(metric.getIndex()))).collect(Collectors.joining(", ", "[", "]"));
        return this.getClass().getSimpleName() + valuesString;
    }
}

