/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.operator.DriverContext;

public class SimpleLinearRegressionWithTimeseries
implements AggregatorState {
    long count = 0L;
    double sumVal = 0.0;
    double sumTs = 0.0;
    double sumTsVal = 0.0;
    double sumTsSq = 0.0;
    double dateFactor;

    @Override
    public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset + 0] = driverContext.blockFactory().newConstantLongBlockWith(this.count, 1);
        blocks[offset + 1] = driverContext.blockFactory().newConstantDoubleBlockWith(this.sumVal, 1);
        blocks[offset + 2] = driverContext.blockFactory().newConstantDoubleBlockWith(this.sumTs, 1);
        blocks[offset + 3] = driverContext.blockFactory().newConstantDoubleBlockWith(this.sumTsVal, 1);
        blocks[offset + 4] = driverContext.blockFactory().newConstantDoubleBlockWith(this.sumTsSq, 1);
    }

    public void close() {
    }

    SimpleLinearRegressionWithTimeseries(boolean dateNanos) {
        this.dateFactor = dateNanos ? 1000000.0 : 1.0;
    }

    void add(long ts, double val) {
        double dts = (double)ts / this.dateFactor;
        ++this.count;
        this.sumVal += val;
        this.sumTs += dts;
        this.sumTsVal += dts * val;
        this.sumTsSq += dts * dts;
    }

    public double slope() {
        if (this.count <= 1L) {
            return Double.NaN;
        }
        double numerator = (double)this.count * this.sumTsVal - this.sumTs * this.sumVal;
        double denominator = (double)this.count * this.sumTsSq - this.sumTs * this.sumTs;
        if (denominator == 0.0) {
            return Double.NaN;
        }
        return numerator / denominator * 1000.0;
    }

    public double intercept() {
        if (this.count == 0L) {
            return 0.0;
        }
        double slp = this.slope();
        if (Double.isNaN(slp)) {
            return Double.NaN;
        }
        return (this.sumVal - slp * this.sumTs) / (double)this.count;
    }
}

