/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class IrateFloatAggregator {
    public static FloatIrateGroupingState initGrouping(DriverContext driverContext, boolean isDelta, boolean isDateNanos) {
        int dateFactor = isDateNanos ? 1000000000 : 1000;
        return new FloatIrateGroupingState(driverContext.bigArrays(), driverContext.breaker(), isDelta, dateFactor);
    }

    public static void combine(FloatIrateGroupingState current, int groupId, float value, long timestamp) {
        current.ensureCapacity(groupId);
        current.append(groupId, timestamp, value);
    }

    public static String describe() {
        return "instant change of floats";
    }

    public static void combineIntermediate(FloatIrateGroupingState current, int groupId, LongBlock timestamps, FloatBlock values, int otherPosition) {
        current.combine(groupId, timestamps, values, otherPosition);
    }

    public static Block evaluateFinal(FloatIrateGroupingState state, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        return state.evaluateFinal(selected, evalContext);
    }

    public static final class FloatIrateGroupingState
    implements Releasable,
    Accountable,
    GroupingAggregatorState {
        private ObjectArray<FloatIrateState> states;
        private final BigArrays bigArrays;
        private final CircuitBreaker breaker;
        private long stateBytes;
        private final boolean isDelta;
        private final int dateFactor;

        FloatIrateGroupingState(BigArrays bigArrays, CircuitBreaker breaker, boolean isDelta, int dateFactor) {
            this.bigArrays = bigArrays;
            this.breaker = breaker;
            this.states = bigArrays.newObjectArray(1L);
            this.isDelta = isDelta;
            this.dateFactor = dateFactor;
        }

        void ensureCapacity(int groupId) {
            this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
        }

        void adjustBreaker(long bytes) {
            this.breaker.addEstimateBytesAndMaybeBreak(bytes, "<<rate aggregation>>");
            this.stateBytes += bytes;
            assert (this.stateBytes >= 0L) : this.stateBytes;
        }

        void append(int groupId, long timestamp, float value) {
            FloatIrateState state = (FloatIrateState)this.states.get((long)groupId);
            if (state == null) {
                state = new FloatIrateState(timestamp, value);
                this.states.set((long)groupId, (Object)state);
                this.adjustBreaker(state.bytesUsed());
            } else if (timestamp > state.lastTimestamp) {
                state.secondLastTimestamp = state.lastTimestamp;
                state.secondLastValue = state.lastValue;
                state.lastTimestamp = timestamp;
                state.lastValue = value;
                state.hasSecond = true;
            } else if (timestamp > state.secondLastTimestamp) {
                state.secondLastTimestamp = timestamp;
                state.secondLastValue = value;
                state.hasSecond = true;
            }
        }

        void combine(int groupId, LongBlock timestamps, FloatBlock values, int otherPosition) {
            int valueCount = timestamps.getValueCount(otherPosition);
            if (valueCount == 0) {
                return;
            }
            int firstTs = timestamps.getFirstValueIndex(otherPosition);
            int firstIndex = values.getFirstValueIndex(otherPosition);
            this.ensureCapacity(groupId);
            this.append(groupId, timestamps.getLong(firstTs), values.getFloat(firstIndex));
            if (valueCount > 1) {
                this.ensureCapacity(groupId);
                this.append(groupId, timestamps.getLong(firstTs + 1), values.getFloat(firstIndex + 1));
            }
        }

        public long ramBytesUsed() {
            return this.states.ramBytesUsed() + this.stateBytes;
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.states, () -> this.adjustBreaker(-this.stateBytes)});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 2) : "blocks=" + blocks.length + ",offset=" + offset;
            BlockFactory blockFactory = driverContext.blockFactory();
            int positionCount = selected.getPositionCount();
            try (LongBlock.Builder timestamps = blockFactory.newLongBlockBuilder(positionCount * 2);
                 FloatBlock.Builder values = blockFactory.newFloatBlockBuilder(positionCount * 2);){
                for (int i = 0; i < positionCount; ++i) {
                    FloatIrateState state;
                    int groupId = selected.getInt(i);
                    FloatIrateState floatIrateState = state = (long)groupId < this.states.size() ? (FloatIrateState)this.states.get((long)groupId) : null;
                    if (state != null) {
                        timestamps.beginPositionEntry();
                        timestamps.appendLong(state.lastTimestamp);
                        if (state.hasSecond) {
                            timestamps.appendLong(state.secondLastTimestamp);
                        }
                        timestamps.endPositionEntry();
                        values.beginPositionEntry();
                        values.appendFloat(state.lastValue);
                        if (state.hasSecond) {
                            values.appendFloat(state.secondLastValue);
                        }
                        values.endPositionEntry();
                        continue;
                    }
                    timestamps.appendNull();
                    values.appendNull();
                }
                blocks[offset] = timestamps.build();
                blocks[offset + 1] = values.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            int positionCount = selected.getPositionCount();
            try (DoubleBlock.Builder rates = evalContext.blockFactory().newDoubleBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    FloatIrateState state;
                    int groupId = selected.getInt(p);
                    FloatIrateState floatIrateState = state = (long)groupId < this.states.size() ? (FloatIrateState)this.states.get((long)groupId) : null;
                    if (state == null || !state.hasSecond) {
                        rates.appendNull();
                        continue;
                    }
                    if (this.isDelta) {
                        rates.appendDouble(state.lastValue - state.secondLastValue);
                        continue;
                    }
                    double ydiff = state.lastValue >= state.secondLastValue ? (double)(state.lastValue - state.secondLastValue) : (double)state.lastValue;
                    long xdiff = state.lastTimestamp - state.secondLastTimestamp;
                    rates.appendDouble(ydiff / (double)xdiff * (double)this.dateFactor);
                }
                DoubleBlock doubleBlock = rates.build();
                return doubleBlock;
            }
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    private static class FloatIrateState {
        static final long BASE_RAM_USAGE = RamUsageEstimator.sizeOfObject(FloatIrateState.class);
        long lastTimestamp;
        long secondLastTimestamp = -1L;
        float lastValue;
        float secondLastValue;
        boolean hasSecond;

        FloatIrateState(long lastTimestamp, float lastValue) {
            this.lastTimestamp = lastTimestamp;
            this.lastValue = lastValue;
            this.hasSecond = false;
        }

        long bytesUsed() {
            return BASE_RAM_USAGE;
        }
    }
}

