/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.elasticsearch.index.codec.vectors.ES814ScalarQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.VectorScoringUtils;

public class ES813Int8FlatVectorFormat
extends KnnVectorsFormat {
    static final String NAME = "ES813Int8FlatVectorFormat";
    private final FlatVectorsFormat format;

    public ES813Int8FlatVectorFormat() {
        this(null, 7, false);
    }

    public ES813Int8FlatVectorFormat(Float confidenceInterval, int bits, boolean compress) {
        super(NAME);
        this.format = new ES814ScalarQuantizedVectorsFormat(confidenceInterval, bits, compress);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES813FlatVectorWriter(this.format.fieldsWriter(state));
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES813FlatVectorReader(this.format.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "ES813Int8FlatVectorFormat(name=ES813Int8FlatVectorFormat, innerFormat=" + String.valueOf(this.format) + ")";
    }

    public static class ES813FlatVectorWriter
    extends KnnVectorsWriter {
        private final FlatVectorsWriter writer;

        public ES813FlatVectorWriter(FlatVectorsWriter writer) {
            this.writer = writer;
        }

        public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
            return this.writer.addField(fieldInfo);
        }

        public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
            this.writer.flush(maxDoc, sortMap);
        }

        public void finish() throws IOException {
            this.writer.finish();
        }

        public void close() throws IOException {
            this.writer.close();
        }

        public long ramBytesUsed() {
            return this.writer.ramBytesUsed();
        }

        public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            this.writer.mergeOneField(fieldInfo, mergeState);
        }
    }

    public static class ES813FlatVectorReader
    extends KnnVectorsReader {
        private final FlatVectorsReader reader;

        public ES813FlatVectorReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
            VectorScoringUtils.scoreAndCollectAll(knnCollector, acceptDocs, this.reader.getRandomVectorScorer(field, target));
        }

        public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
            return this.reader.getOffHeapByteSize(fieldInfo);
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

