/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.bloomfilter;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.codec.bloomfilter.BloomFilterHashFunctions;

public class ES87BloomFilterPostingsFormat
extends PostingsFormat {
    static final String BLOOM_CODEC_NAME = "ES87BloomFilter";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final String BLOOM_FILTER_META_FILE = "bfm";
    static final String BLOOM_FILTER_INDEX_FILE = "bfi";
    private static final int BITS_PER_ENTRY = 10;
    private static final int NUM_HASH_FUNCTIONS = 7;
    private Function<String, PostingsFormat> postingsFormats;
    private BigArrays bigArrays;

    public ES87BloomFilterPostingsFormat(BigArrays bigArrays, Function<String, PostingsFormat> postingsFormats) {
        this();
        this.bigArrays = Objects.requireNonNull(bigArrays);
        this.postingsFormats = Objects.requireNonNull(postingsFormats);
    }

    public ES87BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.postingsFormats == null || this.bigArrays == null) {
            assert (false) : "ES87BloomFilter was initialized with a wrong constructor";
            throw new UnsupportedOperationException("ES87BloomFilter was initialized with a wrong constructor");
        }
        return new FieldsWriter(state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new FieldsReader(state);
    }

    public String toString() {
        return BLOOM_CODEC_NAME;
    }

    private static String metaFile(SegmentInfo si, String segmentSuffix) {
        return IndexFileNames.segmentFileName((String)si.name, (String)segmentSuffix, (String)BLOOM_FILTER_META_FILE);
    }

    private static String indexFile(SegmentInfo si, String segmentSuffix) {
        return IndexFileNames.segmentFileName((String)si.name, (String)segmentSuffix, (String)BLOOM_FILTER_INDEX_FILE);
    }

    static int bloomFilterSize(int maxDocs) {
        if (maxDocs < 1) {
            throw new IllegalStateException("maxDocs must be greater than or equal to 1, got " + maxDocs);
        }
        long numBits = (long)maxDocs * 10L;
        if ((numBits = (numBits - 1L | 7L) + 1L) > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)numBits;
    }

    static int numBytesForBloomFilter(int bloomFilterSize) {
        return Math.toIntExact(((long)bloomFilterSize + 7L) / 8L);
    }

    static int[] hashTerm(BytesRef br, int[] outputs) {
        long hash64 = BloomFilterHashFunctions.MurmurHash3.hash64(br.bytes, br.offset, br.length);
        int upperHalf = (int)(hash64 >> 32);
        int lowerHalf = (int)hash64;
        outputs[0] = lowerHalf + 2 * upperHalf & Integer.MAX_VALUE;
        outputs[1] = lowerHalf + 3 * upperHalf & Integer.MAX_VALUE;
        outputs[2] = lowerHalf + 5 * upperHalf & Integer.MAX_VALUE;
        outputs[3] = lowerHalf + 7 * upperHalf & Integer.MAX_VALUE;
        outputs[4] = lowerHalf + 11 * upperHalf & Integer.MAX_VALUE;
        outputs[5] = lowerHalf + 13 * upperHalf & Integer.MAX_VALUE;
        outputs[6] = lowerHalf + 17 * upperHalf & Integer.MAX_VALUE;
        return outputs;
    }

    final class FieldsWriter
    extends FieldsConsumer {
        private final SegmentWriteState state;
        private final IndexOutput indexOut;
        private final List<BloomFilter> bloomFilters = new ArrayList<BloomFilter>();
        private final List<FieldsGroup> fieldsGroups = new ArrayList<FieldsGroup>();
        private final List<Closeable> toCloses = new ArrayList<Closeable>();
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsWriter(SegmentWriteState state) throws IOException {
            this.state = state;
            boolean success = false;
            try {
                this.indexOut = state.directory.createOutput(ES87BloomFilterPostingsFormat.indexFile(state.segmentInfo, state.segmentSuffix), state.context);
                this.toCloses.add((Closeable)this.indexOut);
                CodecUtil.writeIndexHeader((DataOutput)this.indexOut, (String)ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toCloses);
                }
            }
        }

        public void write(Fields fields, NormsProducer norms) throws IOException {
            this.writePostings(fields, norms);
            this.writeBloomFilters(fields);
        }

        private void writePostings(Fields fields, NormsProducer norms) throws IOException {
            HashMap<PostingsFormat, FieldsGroup> currentGroups = new HashMap<PostingsFormat, FieldsGroup>();
            for (String field : fields) {
                PostingsFormat postingsFormat = ES87BloomFilterPostingsFormat.this.postingsFormats.apply(field);
                if (postingsFormat == null) {
                    throw new IllegalStateException("PostingsFormat for field [" + field + "] wasn't specified");
                }
                FieldsGroup group = (FieldsGroup)currentGroups.get(postingsFormat);
                if (group == null) {
                    group = new FieldsGroup(postingsFormat, Integer.toString(this.fieldsGroups.size()), new ArrayList<String>());
                    currentGroups.put(postingsFormat, group);
                    this.fieldsGroups.add(group);
                }
                group.fields.add(field);
            }
            for (final FieldsGroup group : currentGroups.values()) {
                FieldsConsumer writer = group.postingsFormat.fieldsConsumer(new SegmentWriteState(this.state, group.suffix));
                this.toCloses.add((Closeable)writer);
                FilterLeafReader.FilterFields maskedFields = new FilterLeafReader.FilterFields(this, fields){

                    public Iterator<String> iterator() {
                        return group.fields.iterator();
                    }
                };
                writer.write((Fields)maskedFields, norms);
            }
        }

        private void writeBloomFilters(Fields fields) throws IOException {
            int bloomFilterSize = ES87BloomFilterPostingsFormat.bloomFilterSize(this.state.segmentInfo.maxDoc());
            int numBytes = ES87BloomFilterPostingsFormat.numBytesForBloomFilter(bloomFilterSize);
            int[] hashes = new int[7];
            try (ByteArray buffer = ES87BloomFilterPostingsFormat.this.bigArrays.newByteArray(numBytes, false);){
                long written = this.indexOut.getFilePointer();
                for (String field : fields) {
                    BytesRef term;
                    Terms terms = fields.terms(field);
                    if (terms == null) continue;
                    buffer.fill(0L, numBytes, (byte)0);
                    TermsEnum termsEnum = terms.iterator();
                    while ((term = termsEnum.next()) != null) {
                        for (int hash : ES87BloomFilterPostingsFormat.hashTerm(term, hashes)) {
                            int pos = (hash %= bloomFilterSize) >> 3;
                            int mask = 1 << (hash & 7);
                            byte val = (byte)(buffer.get(pos) | mask);
                            buffer.set(pos, val);
                        }
                    }
                    this.bloomFilters.add(new BloomFilter(field, written, bloomFilterSize));
                    if (buffer.hasArray()) {
                        this.indexOut.writeBytes(buffer.array(), 0, numBytes);
                    } else {
                        BytesReference.fromByteArray(buffer, numBytes).writeTo(new IndexOutputOutputStream(this.indexOut));
                    }
                    written += (long)numBytes;
                }
            }
        }

        public void close() throws IOException {
            long indexFileLength;
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                CodecUtil.writeFooter((IndexOutput)this.indexOut);
                indexFileLength = this.indexOut.getFilePointer();
            }
            finally {
                IOUtils.close(this.toCloses);
            }
            try (IndexOutput metaOut = this.state.directory.createOutput(ES87BloomFilterPostingsFormat.metaFile(this.state.segmentInfo, this.state.segmentSuffix), this.state.context);){
                CodecUtil.writeIndexHeader((DataOutput)metaOut, (String)ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)0, (byte[])this.state.segmentInfo.getId(), (String)this.state.segmentSuffix);
                metaOut.writeVInt(this.fieldsGroups.size());
                for (FieldsGroup group : this.fieldsGroups) {
                    group.writeTo(metaOut, this.state.fieldInfos);
                }
                metaOut.writeVInt(this.bloomFilters.size());
                for (BloomFilter bloomFilter : this.bloomFilters) {
                    bloomFilter.writeTo(metaOut, this.state.fieldInfos);
                }
                metaOut.writeVLong(indexFileLength);
                CodecUtil.writeFooter((IndexOutput)metaOut);
            }
        }
    }

    static final class FieldsReader
    extends FieldsProducer {
        private final Map<String, BloomFilter> bloomFilters;
        private final List<Closeable> toCloses = new ArrayList<Closeable>();
        private final Map<String, FieldsProducer> readerMap = new HashMap<String, FieldsProducer>();
        private final IndexInput indexIn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FieldsReader(SegmentReadState state) throws IOException {
            boolean success = false;
            try (ChecksumIndexInput metaIn = state.directory.openChecksumInput(ES87BloomFilterPostingsFormat.metaFile(state.segmentInfo, state.segmentSuffix));){
                HashMap<String, BloomFilter> bloomFilters = null;
                Throwable priorE = null;
                long indexFileLength = 0L;
                try {
                    CodecUtil.checkIndexHeader((DataInput)metaIn, (String)ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    int numFieldsGroups = metaIn.readVInt();
                    for (int i = 0; i < numFieldsGroups; ++i) {
                        FieldsGroup group = FieldsGroup.readFrom((IndexInput)metaIn, state.fieldInfos);
                        FieldsProducer reader = group.postingsFormat.fieldsProducer(new SegmentReadState(state, group.suffix));
                        this.toCloses.add((Closeable)reader);
                        for (String field : group.fields) {
                            this.readerMap.put(field, reader);
                        }
                    }
                    int numBloomFilters = metaIn.readVInt();
                    bloomFilters = new HashMap<String, BloomFilter>(numBloomFilters);
                    for (int i = 0; i < numBloomFilters; ++i) {
                        BloomFilter bloomFilter = BloomFilter.readFrom((IndexInput)metaIn, state.fieldInfos);
                        bloomFilters.put(bloomFilter.field, bloomFilter);
                    }
                    indexFileLength = metaIn.readVLong();
                }
                catch (Throwable t) {
                    priorE = t;
                }
                finally {
                    CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                }
                this.bloomFilters = bloomFilters;
                this.indexIn = state.directory.openInput(ES87BloomFilterPostingsFormat.indexFile(state.segmentInfo, state.segmentSuffix), state.context);
                this.toCloses.add((Closeable)this.indexIn);
                CodecUtil.checkIndexHeader((DataInput)this.indexIn, (String)ES87BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                CodecUtil.retrieveChecksum((IndexInput)this.indexIn, (long)indexFileLength);
                assert (this.assertBloomFilterSizes(state.segmentInfo));
                success = true;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.toCloses);
                }
            }
        }

        private boolean assertBloomFilterSizes(SegmentInfo segmentInfo) {
            for (BloomFilter bloomFilter : this.bloomFilters.values()) {
                assert (bloomFilter.bloomFilterSize == ES87BloomFilterPostingsFormat.bloomFilterSize(segmentInfo.maxDoc())) : "bloom_filter=" + String.valueOf(bloomFilter) + ", max_docs=" + segmentInfo.maxDoc();
            }
            return true;
        }

        public Iterator<String> iterator() {
            return this.readerMap.keySet().iterator();
        }

        public void close() throws IOException {
            IOUtils.close(this.toCloses);
        }

        public Terms terms(String field) throws IOException {
            FieldsProducer reader = this.readerMap.get(field);
            if (reader == null) {
                return null;
            }
            Terms terms = reader.terms(field);
            if (terms == null) {
                return null;
            }
            BloomFilter bloomFilter = this.bloomFilters.get(field);
            if (bloomFilter != null) {
                RandomAccessInput data = this.indexIn.randomAccessSlice(bloomFilter.startFilePointer(), (long)ES87BloomFilterPostingsFormat.numBytesForBloomFilter(bloomFilter.bloomFilterSize));
                return new BloomFilterTerms(terms, data, bloomFilter.bloomFilterSize);
            }
            return terms;
        }

        public int size() {
            return this.readerMap.size();
        }

        public void checkIntegrity() throws IOException {
            CodecUtil.checksumEntireFile((IndexInput)this.indexIn);
            HashSet<FieldsProducer> seenReaders = new HashSet<FieldsProducer>();
            for (FieldsProducer reader : this.readerMap.values()) {
                if (!seenReaders.add(reader)) continue;
                reader.checkIntegrity();
            }
        }
    }

    private static abstract class LazyFilterTermsEnum
    extends BaseTermsEnum {
        private LazyFilterTermsEnum() {
        }

        abstract TermsEnum getDelegate() throws IOException;

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        public void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        public BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        public long ord() throws IOException {
            return this.getDelegate().ord();
        }

        public int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        public long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.getDelegate().postings(reuse, flags);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            return this.getDelegate().impacts(flags);
        }

        public BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        public AttributeSource attributes() {
            try {
                return this.getDelegate().attributes();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class BloomFilterTerms
    extends FilterLeafReader.FilterTerms {
        private final RandomAccessInput data;
        private final int bloomFilterSize;
        private final int[] hashes = new int[7];

        BloomFilterTerms(Terms in, RandomAccessInput data, int bloomFilterSize) {
            super(in);
            this.data = data;
            this.bloomFilterSize = bloomFilterSize;
        }

        private boolean mayContainTerm(BytesRef term) throws IOException {
            ES87BloomFilterPostingsFormat.hashTerm(term, this.hashes);
            for (int hash : this.hashes) {
                int pos = (hash %= this.bloomFilterSize) >> 3;
                int mask = 1 << (hash & 7);
                byte bits = this.data.readByte((long)pos);
                if ((bits & mask) != 0) continue;
                return false;
            }
            return true;
        }

        public TermsEnum iterator() throws IOException {
            return new LazyFilterTermsEnum(){
                private TermsEnum delegate;

                @Override
                TermsEnum getDelegate() throws IOException {
                    if (this.delegate == null) {
                        this.delegate = in.iterator();
                    }
                    return this.delegate;
                }

                public boolean seekExact(BytesRef term) throws IOException {
                    if (this.mayContainTerm(term)) {
                        return this.getDelegate().seekExact(term);
                    }
                    return false;
                }

                public void seekExact(BytesRef term, TermState state) throws IOException {
                    this.getDelegate().seekExact(term, state);
                }

                public TermState termState() throws IOException {
                    return this.getDelegate().termState();
                }
            };
        }
    }

    private record FieldsGroup(PostingsFormat postingsFormat, String suffix, List<String> fields) {
        void writeTo(IndexOutput out, FieldInfos fieldInfos) throws IOException {
            out.writeString(this.postingsFormat.getName());
            out.writeString(this.suffix);
            out.writeVInt(this.fields.size());
            for (String field : this.fields) {
                out.writeVInt(fieldInfos.fieldInfo((String)field).number);
            }
        }

        static FieldsGroup readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            PostingsFormat postingsFormat = PostingsFormat.forName((String)in.readString());
            String suffix = in.readString();
            int numFields = in.readVInt();
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < numFields; ++i) {
                fields.add(fieldInfos.fieldInfo((int)in.readVInt()).name);
            }
            return new FieldsGroup(postingsFormat, suffix, fields);
        }
    }

    private record BloomFilter(String field, long startFilePointer, int bloomFilterSize) {
        void writeTo(IndexOutput out, FieldInfos fieldInfos) throws IOException {
            out.writeVInt(fieldInfos.fieldInfo((String)this.field).number);
            out.writeVLong(this.startFilePointer);
            out.writeVInt(this.bloomFilterSize);
        }

        static BloomFilter readFrom(IndexInput in, FieldInfos fieldInfos) throws IOException {
            String fieldName = fieldInfos.fieldInfo((int)in.readVInt()).name;
            long startFilePointer = in.readVLong();
            int bloomFilterSize = in.readVInt();
            return new BloomFilter(fieldName, startFilePointer, bloomFilterSize);
        }
    }
}

