/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class GetDataStreamMappingsAction
extends ActionType<Response> {
    public static final String NAME = "indices:monitor/data_stream/mappings/get";
    public static final GetDataStreamMappingsAction INSTANCE = new GetDataStreamMappingsAction();

    public GetDataStreamMappingsAction() {
        super(NAME);
    }

    public record DataStreamMappingsResponse(String dataStreamName, CompressedXContent mappings, CompressedXContent effectiveMappings) implements ToXContent
    {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.dataStreamName);
            Map uncompressedMappings = (Map)XContentHelper.convertToMap(this.mappings.uncompressed(), true, XContentType.JSON).v2();
            builder.field("mappings");
            builder.map(uncompressedMappings);
            Map uncompressedEffectiveMappings = (Map)XContentHelper.convertToMap(this.effectiveMappings.uncompressed(), true, XContentType.JSON).v2();
            builder.field("effective_mappings");
            builder.map(uncompressedEffectiveMappings);
            builder.endObject();
            return builder;
        }
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final List<DataStreamMappingsResponse> dataStreamMappingsResponses;

        public Response(List<DataStreamMappingsResponse> DataStreamMappingsResponses) {
            this.dataStreamMappingsResponses = DataStreamMappingsResponses;
        }

        public List<DataStreamMappingsResponse> getDataStreamMappingsResponses() {
            return this.dataStreamMappingsResponses;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(Iterators.single((builder, params1) -> builder.startObject().startArray("data_streams")), this.dataStreamMappingsResponses.stream().map(dataStreamMappingsResponse -> dataStreamMappingsResponse).iterator(), Iterators.single((builder, params1) -> builder.endArray().endObject()));
        }
    }

    public static class Request
    extends LocalClusterStateRequest
    implements IndicesRequest.Replaceable {
        private String[] dataStreamNames;

        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        @Override
        public Request indices(String ... dataStreamNames) {
            this.dataStreamNames = dataStreamNames;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public String[] indices() {
            return this.dataStreamNames;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.dataStreamNames, request.dataStreamNames);
        }

        public int hashCode() {
            return Arrays.hashCode(this.dataStreamNames);
        }
    }
}

