/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteIndexTemplateRequest
extends MasterNodeRequest<DeleteIndexTemplateRequest> {
    private String name;

    public DeleteIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
    }

    public DeleteIndexTemplateRequest() {
        super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
    }

    public DeleteIndexTemplateRequest(String name) {
        super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
        this.name = name;
    }

    public DeleteIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        return validationException;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
    }
}

