/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.resolve;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndexComponentSelector;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.crossproject.CrossProjectIndexResolutionValidator;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ResolveIndexAction
extends ActionType<Response> {
    public static final ResolveIndexAction INSTANCE = new ResolveIndexAction();
    public static final String NAME = "indices:admin/resolve/index";
    public static final RemoteClusterActionType<Response> REMOTE_TYPE = new RemoteClusterActionType<Response>("indices:admin/resolve/index", Response::new);
    private static final TransportVersion RESOLVE_INDEX_MODE_ADDED = TransportVersion.fromName("resolve_index_mode_added");
    private static final TransportVersion RESOLVE_INDEX_MODE_FILTER = TransportVersion.fromName("resolve_index_mode_filter");

    private ResolveIndexAction() {
        super(NAME);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private static final Logger logger = LogManager.getLogger(TransportAction.class);
        private final ClusterService clusterService;
        private final RemoteClusterService remoteClusterService;
        private final ProjectResolver projectResolver;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final boolean ccsCheckCompatibility;
        private final CrossProjectModeDecider crossProjectModeDecider;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, ProjectResolver projectResolver, Settings settings, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(ResolveIndexAction.NAME, transportService, actionFilters, Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.clusterService = clusterService;
            this.remoteClusterService = transportService.getRemoteClusterService();
            this.projectResolver = projectResolver;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
            this.crossProjectModeDecider = new CrossProjectModeDecider(settings);
            this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            if (this.ccsCheckCompatibility) {
                TransportSearchHelper.checkCCSVersionCompatibility(request);
            }
            ProjectState projectState = this.projectResolver.getProjectState(this.clusterService.state());
            IndicesOptions originalIndicesOptions = request.indicesOptions();
            boolean resolveCrossProject = this.crossProjectModeDecider.resolvesCrossProject(request);
            Map<String, OriginalIndices> remoteClusterIndices = this.remoteClusterService.groupIndices(resolveCrossProject ? CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout(originalIndicesOptions) : originalIndicesOptions, request.indices());
            OriginalIndices localIndices = remoteClusterIndices.remove("");
            ArrayList<ResolvedIndex> indices = new ArrayList<ResolvedIndex>();
            ArrayList<ResolvedAlias> aliases = new ArrayList<ResolvedAlias>();
            ArrayList<ResolvedDataStream> dataStreams = new ArrayList<ResolvedDataStream>();
            TransportAction.resolveIndices(localIndices, projectState, this.indexNameExpressionResolver, indices, aliases, dataStreams, request.indexModes);
            ResolvedIndexExpressions localResolvedIndexExpressions = request.getResolvedIndexExpressions();
            if (remoteClusterIndices.size() > 0) {
                int remoteRequests = remoteClusterIndices.size();
                CountDown completionCounter = new CountDown(remoteRequests);
                SortedMap remoteResponses = Collections.synchronizedSortedMap(new TreeMap());
                Runnable terminalHandler = () -> {
                    if (completionCounter.countDown()) {
                        ElasticsearchException ex;
                        if (resolveCrossProject && (ex = CrossProjectIndexResolutionValidator.validate(originalIndicesOptions, request.getProjectRouting(), localResolvedIndexExpressions, this.getResolvedExpressionsByRemote(remoteResponses))) != null) {
                            listener.onFailure(ex);
                            return;
                        }
                        TransportAction.mergeResults(remoteResponses, indices, aliases, dataStreams, request.indexModes);
                        listener.onResponse(new Response(indices, aliases, dataStreams));
                    }
                };
                for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
                    String clusterAlias = remoteIndices.getKey();
                    OriginalIndices originalIndices = remoteIndices.getValue();
                    RemoteClusterClient remoteClusterClient = this.remoteClusterService.getRemoteClusterClient(clusterAlias, EsExecutors.DIRECT_EXECUTOR_SERVICE, RemoteClusterService.DisconnectedStrategy.RECONNECT_UNLESS_SKIP_UNAVAILABLE);
                    Request remoteRequest = new Request(originalIndices.indices(), originalIndices.indicesOptions());
                    remoteClusterClient.execute(REMOTE_TYPE, remoteRequest, ActionListener.wrap(response -> {
                        remoteResponses.put(clusterAlias, response);
                        terminalHandler.run();
                    }, failure -> {
                        logger.info("failed to resolve indices on remote cluster [" + clusterAlias + "]", (Throwable)failure);
                        terminalHandler.run();
                    }));
                }
            } else {
                ElasticsearchException ex;
                if (resolveCrossProject && (ex = CrossProjectIndexResolutionValidator.validate(originalIndicesOptions, request.getProjectRouting(), localResolvedIndexExpressions, Map.of())) != null) {
                    listener.onFailure(ex);
                    return;
                }
                listener.onResponse(new Response(indices, aliases, dataStreams, localResolvedIndexExpressions));
            }
        }

        private Map<String, ResolvedIndexExpressions> getResolvedExpressionsByRemote(Map<String, Response> remoteResponses) {
            return remoteResponses.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                ResolvedIndexExpressions resolvedIndexExpressions = ((Response)e.getValue()).getResolvedIndexExpressions();
                assert (resolvedIndexExpressions != null) : "remote response from cluster [" + (String)e.getKey() + "] is missing resolved index expressions";
                return resolvedIndexExpressions;
            }));
        }

        static void resolveIndices(@Nullable OriginalIndices localIndices, ProjectState projectState, IndexNameExpressionResolver resolver, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams, Set<IndexMode> indexModes) {
            if (localIndices == null) {
                return;
            }
            TransportAction.resolveIndices(localIndices.indices(), localIndices.indicesOptions(), projectState, resolver, indices, aliases, dataStreams, indexModes);
        }

        static void resolveIndices(String[] names, IndicesOptions indicesOptions, ProjectState projectState, IndexNameExpressionResolver resolver, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            TransportAction.resolveIndices(names, indicesOptions, projectState, resolver, indices, aliases, dataStreams, Collections.emptySet());
        }

        static void resolveIndices(String[] names, IndicesOptions indicesOptions, ProjectState projectState, IndexNameExpressionResolver resolver, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams, Set<IndexMode> indexModes) {
            if (names.length == 0) {
                return;
            }
            if (names.length == 1 && ("_all".equals(names[0]) || Regex.isMatchAllPattern(names[0]))) {
                names = new String[]{"**"};
            }
            Set<IndexNameExpressionResolver.ResolvedExpression> resolvedIndexAbstractions = resolver.resolveExpressions(projectState.metadata(), indicesOptions, true, names);
            for (IndexNameExpressionResolver.ResolvedExpression s : resolvedIndexAbstractions) {
                TransportAction.enrichIndexAbstraction(projectState, s, indices, aliases, dataStreams, indexModes);
            }
            indices.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
            aliases.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
            dataStreams.sort(Comparator.comparing(ResolvedIndexAbstraction::getName));
        }

        private static void mergeResults(Map<String, Response> remoteResponses, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams, Set<IndexMode> indexModes) {
            for (Map.Entry<String, Response> responseEntry : remoteResponses.entrySet()) {
                String clusterAlias = responseEntry.getKey();
                Response response = responseEntry.getValue();
                for (ResolvedIndex index : response.indices) {
                    if (!indexModes.isEmpty() && !indexModes.contains((Object)index.getMode())) continue;
                    indices.add(index.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index.getName())));
                }
                Set indexNames = indices.stream().map(ResolvedIndexAbstraction::getName).collect(Collectors.toSet());
                for (ResolvedAlias alias : response.aliases) {
                    if (!indexModes.isEmpty()) {
                        String[] filteredIndices = (String[])Arrays.stream(alias.getIndices()).filter(idxName -> indexNames.contains(RemoteClusterAware.buildRemoteIndexName(clusterAlias, idxName))).toArray(String[]::new);
                        if (filteredIndices.length == 0) continue;
                        alias = new ResolvedAlias(RemoteClusterAware.buildRemoteIndexName(clusterAlias, alias.getName()), filteredIndices);
                    } else {
                        alias = alias.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, alias.getName()));
                    }
                    aliases.add(alias);
                }
                for (ResolvedDataStream dataStream : response.dataStreams) {
                    if (!indexModes.isEmpty()) {
                        String[] filteredBackingIndices = (String[])Arrays.stream(dataStream.getBackingIndices()).filter(idxName -> indexNames.contains(RemoteClusterAware.buildRemoteIndexName(clusterAlias, idxName))).toArray(String[]::new);
                        if (filteredBackingIndices.length == 0) continue;
                        dataStream = new ResolvedDataStream(RemoteClusterAware.buildRemoteIndexName(clusterAlias, dataStream.getName()), filteredBackingIndices, dataStream.getTimestampField());
                    } else {
                        dataStream = dataStream.copy(RemoteClusterAware.buildRemoteIndexName(clusterAlias, dataStream.getName()));
                    }
                    dataStreams.add(dataStream);
                }
            }
        }

        private static Predicate<Index> indexModeFilter(ProjectState projectState, Set<IndexMode> indexModes) {
            if (indexModes.isEmpty()) {
                return index -> true;
            }
            return index -> {
                IndexMetadata indexMetadata = projectState.metadata().index((Index)index);
                IndexMode mode = indexMetadata.getIndexMode() == null ? IndexMode.STANDARD : indexMetadata.getIndexMode();
                return indexModes.contains((Object)mode);
            };
        }

        private static void enrichIndexAbstraction(ProjectState projectState, IndexNameExpressionResolver.ResolvedExpression resolvedExpression, List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams, Set<IndexMode> indexModes) {
            SortedMap<String, IndexAbstraction> indicesLookup = projectState.metadata().getIndicesLookup();
            IndexAbstraction ia = (IndexAbstraction)indicesLookup.get(resolvedExpression.resource());
            Predicate<Index> filterPredicate = TransportAction.indexModeFilter(projectState, indexModes);
            if (ia != null) {
                switch (ia.getType()) {
                    case CONCRETE_INDEX: {
                        boolean isFrozen;
                        if (!filterPredicate.test(ia.getWriteIndex())) {
                            return;
                        }
                        IndexMetadata writeIndex = projectState.metadata().index(ia.getWriteIndex());
                        IndexMode mode = writeIndex.getIndexMode() == null ? IndexMode.STANDARD : writeIndex.getIndexMode();
                        String[] aliasNames = (String[])writeIndex.getAliases().keySet().stream().sorted().toArray(String[]::new);
                        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                        attributes.add(writeIndex.getState() == IndexMetadata.State.OPEN ? Attribute.OPEN : Attribute.CLOSED);
                        if (ia.isHidden()) {
                            attributes.add(Attribute.HIDDEN);
                        }
                        if (ia.isSystem()) {
                            attributes.add(Attribute.SYSTEM);
                        }
                        if (isFrozen = writeIndex.getSettings().getAsBoolean("index.frozen", false).booleanValue()) {
                            attributes.add(Attribute.FROZEN);
                        }
                        attributes.sort(Comparator.comparing(e -> e.name().toLowerCase(Locale.ROOT)));
                        indices.add(new ResolvedIndex(ia.getName(), aliasNames, (String[])attributes.stream().map(Enum::name).map(e -> e.toLowerCase(Locale.ROOT)).toArray(String[]::new), ia.getParentDataStream() == null ? null : ia.getParentDataStream().getName(), mode));
                        break;
                    }
                    case ALIAS: {
                        Object[] indexNames = (String[])TransportAction.getAliasIndexStream(resolvedExpression, ia, projectState.metadata()).filter(filterPredicate).map(Index::getName).toArray(String[]::new);
                        if (!indexModes.isEmpty() && indexNames.length == 0) {
                            return;
                        }
                        Arrays.sort(indexNames);
                        aliases.add(new ResolvedAlias(ia.getName(), (String[])indexNames));
                        break;
                    }
                    case DATA_STREAM: {
                        Stream stream;
                        DataStream dataStream = (DataStream)ia;
                        if (resolvedExpression.selector() == null) {
                            stream = dataStream.getIndices().stream();
                        } else {
                            switch (resolvedExpression.selector()) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case DATA: {
                                    stream = dataStream.getDataComponent().getIndices().stream();
                                    break;
                                }
                                case FAILURES: {
                                    stream = dataStream.getFailureIndices().stream();
                                }
                            }
                        }
                        Stream dataStreamIndices = stream;
                        String[] backingIndices = (String[])dataStreamIndices.filter(filterPredicate).map(Index::getName).toArray(String[]::new);
                        if (!indexModes.isEmpty() && backingIndices.length == 0) {
                            return;
                        }
                        dataStreams.add(new ResolvedDataStream(dataStream.getName(), backingIndices, "@timestamp"));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown index abstraction type: " + String.valueOf((Object)ia.getType()));
                    }
                }
            }
        }

        private static Stream<Index> getAliasIndexStream(IndexNameExpressionResolver.ResolvedExpression resolvedExpression, IndexAbstraction ia, ProjectMetadata metadata) {
            Stream<Index> aliasIndices;
            if (resolvedExpression.selector() == null) {
                aliasIndices = ia.getIndices().stream();
            } else {
                aliasIndices = switch (resolvedExpression.selector()) {
                    default -> throw new MatchException(null, null);
                    case IndexComponentSelector.DATA -> ia.getIndices().stream();
                    case IndexComponentSelector.FAILURES -> {
                        if (!$assertionsDisabled && !ia.isDataStreamRelated()) {
                            throw new AssertionError((Object)"Illegal selector [failures] used on non data stream alias");
                        }
                        yield ia.getFailureIndices(metadata).stream();
                    }
                };
            }
            return aliasIndices;
        }

        static enum Attribute {
            OPEN,
            CLOSED,
            HIDDEN,
            SYSTEM,
            FROZEN;

        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<ResolvedIndex> indices;
        private final List<ResolvedAlias> aliases;
        private final List<ResolvedDataStream> dataStreams;
        @Nullable
        private final ResolvedIndexExpressions resolvedIndexExpressions;

        public Response(List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams) {
            this(indices, aliases, dataStreams, null);
        }

        public Response(List<ResolvedIndex> indices, List<ResolvedAlias> aliases, List<ResolvedDataStream> dataStreams, ResolvedIndexExpressions resolvedIndexExpressions) {
            this.indices = indices;
            this.aliases = aliases;
            this.dataStreams = dataStreams;
            this.resolvedIndexExpressions = resolvedIndexExpressions;
        }

        public Response(StreamInput in) throws IOException {
            this.indices = in.readCollectionAsList(ResolvedIndex::new);
            this.aliases = in.readCollectionAsList(ResolvedAlias::new);
            this.dataStreams = in.readCollectionAsList(ResolvedDataStream::new);
            this.resolvedIndexExpressions = in.getTransportVersion().supports(ResolvedIndexExpressions.RESOLVED_INDEX_EXPRESSIONS) ? in.readOptionalWriteable(ResolvedIndexExpressions::new) : null;
        }

        public List<ResolvedIndex> getIndices() {
            return this.indices;
        }

        public List<ResolvedAlias> getAliases() {
            return this.aliases;
        }

        public List<ResolvedDataStream> getDataStreams() {
            return this.dataStreams;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.indices);
            out.writeCollection(this.aliases);
            out.writeCollection(this.dataStreams);
            if (out.getTransportVersion().supports(ResolvedIndexExpressions.RESOLVED_INDEX_EXPRESSIONS)) {
                out.writeOptionalWriteable(this.resolvedIndexExpressions);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.xContentList(INDICES_FIELD.getPreferredName(), this.indices);
            builder.xContentList(ALIASES_FIELD.getPreferredName(), this.aliases);
            builder.xContentList(DATA_STREAMS_FIELD.getPreferredName(), this.dataStreams);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.indices.equals(response.indices) && this.aliases.equals(response.aliases) && this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.aliases, this.dataStreams);
        }

        @Nullable
        public ResolvedIndexExpressions getResolvedIndexExpressions() {
            return this.resolvedIndexExpressions;
        }
    }

    public static class ResolvedDataStream
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField BACKING_INDICES_FIELD = new ParseField("backing_indices", new String[0]);
        static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
        private final String[] backingIndices;
        private final String timestampField;

        ResolvedDataStream(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.backingIndices = in.readStringArray();
            this.timestampField = in.readString();
        }

        ResolvedDataStream(String name, String[] backingIndices, String timestampField) {
            super(name);
            this.backingIndices = backingIndices;
            this.timestampField = timestampField;
        }

        public ResolvedDataStream copy(String newName) {
            return new ResolvedDataStream(newName, this.backingIndices, this.timestampField);
        }

        public String[] getBackingIndices() {
            return this.backingIndices;
        }

        public String getTimestampField() {
            return this.timestampField;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.backingIndices);
            out.writeString(this.timestampField);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            builder.array(BACKING_INDICES_FIELD.getPreferredName(), this.backingIndices);
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedDataStream dataStream = (ResolvedDataStream)o;
            return this.getName().equals(dataStream.getName()) && this.timestampField.equals(dataStream.timestampField) && Arrays.equals(this.backingIndices, dataStream.backingIndices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.timestampField);
            result = 31 * result + Arrays.hashCode(this.backingIndices);
            return result;
        }

        public String toString() {
            return String.format(Locale.ROOT, "ResolvedDataStream{name=%s, backingIndices=%s, timestampField=%s}", this.getName(), Arrays.toString(this.backingIndices), this.timestampField);
        }
    }

    public static class ResolvedAlias
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        private final String[] indices;

        ResolvedAlias(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.indices = in.readStringArray();
        }

        ResolvedAlias(String name, String[] indices) {
            super(name);
            this.indices = indices;
        }

        public ResolvedAlias copy(String newName) {
            return new ResolvedAlias(newName, this.indices);
        }

        public String[] getIndices() {
            return this.indices;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.indices);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.indices.length > 0) {
                builder.array(INDICES_FIELD.getPreferredName(), this.indices);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedAlias alias = (ResolvedAlias)o;
            return this.getName().equals(alias.getName()) && Arrays.equals(this.indices, alias.indices);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName());
            result = 31 * result + Arrays.hashCode(this.indices);
            return result;
        }

        public String toString() {
            return String.format(Locale.ROOT, "ResolvedAlias{name=%s, indices=%s}", this.getName(), Arrays.toString(this.indices));
        }
    }

    public static class ResolvedIndex
    extends ResolvedIndexAbstraction
    implements Writeable,
    ToXContentObject {
        static final ParseField ALIASES_FIELD = new ParseField("aliases", new String[0]);
        static final ParseField ATTRIBUTES_FIELD = new ParseField("attributes", new String[0]);
        static final ParseField DATA_STREAM_FIELD = new ParseField("data_stream", new String[0]);
        static final ParseField MODE_FIELD = new ParseField("mode", new String[0]);
        private final String[] aliases;
        private final String[] attributes;
        private final String dataStream;
        private final IndexMode mode;

        ResolvedIndex(StreamInput in) throws IOException {
            this.setName(in.readString());
            this.aliases = in.readStringArray();
            this.attributes = in.readStringArray();
            this.dataStream = in.readOptionalString();
            this.mode = in.getTransportVersion().supports(RESOLVE_INDEX_MODE_ADDED) ? IndexMode.readFrom(in) : null;
        }

        ResolvedIndex(String name, String[] aliases, String[] attributes, @Nullable String dataStream, IndexMode mode) {
            super(name);
            this.aliases = aliases;
            this.attributes = attributes;
            this.dataStream = dataStream;
            this.mode = mode;
        }

        public ResolvedIndex copy(String newName) {
            return new ResolvedIndex(newName, this.aliases, this.attributes, this.dataStream, this.mode);
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public String[] getAttributes() {
            return this.attributes;
        }

        public String getDataStream() {
            return this.dataStream;
        }

        public IndexMode getMode() {
            return this.mode;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getName());
            out.writeStringArray(this.aliases);
            out.writeStringArray(this.attributes);
            out.writeOptionalString(this.dataStream);
            if (out.getTransportVersion().supports(RESOLVE_INDEX_MODE_ADDED)) {
                IndexMode.writeTo(this.mode, out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.getName());
            if (this.aliases.length > 0) {
                builder.array(ALIASES_FIELD.getPreferredName(), this.aliases);
            }
            builder.array(ATTRIBUTES_FIELD.getPreferredName(), this.attributes);
            if (!Strings.isNullOrEmpty(this.dataStream)) {
                builder.field(DATA_STREAM_FIELD.getPreferredName(), this.dataStream);
            }
            if (this.mode != null) {
                builder.field(MODE_FIELD.getPreferredName(), this.mode.toString());
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedIndex index = (ResolvedIndex)o;
            return this.getName().equals(index.getName()) && Objects.equals(this.dataStream, index.dataStream) && Arrays.equals(this.aliases, index.aliases) && Arrays.equals(this.attributes, index.attributes) && Objects.equals((Object)this.mode, (Object)index.mode);
        }

        public int hashCode() {
            int result = Objects.hash(this.getName(), this.dataStream);
            result = 31 * result + Objects.hashCode((Object)this.mode);
            result = 31 * result + Arrays.hashCode(this.aliases);
            result = 31 * result + Arrays.hashCode(this.attributes);
            return result;
        }

        public String toString() {
            return String.format(Locale.ROOT, "ResolvedIndex{name=%s, aliases=%s, attributes=%s, dataStream=%s, mode=%s}", new Object[]{this.getName(), Arrays.toString(this.aliases), Arrays.toString(this.attributes), this.dataStream, this.mode});
        }
    }

    public static class ResolvedIndexAbstraction {
        static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private String name;

        ResolvedIndexAbstraction() {
        }

        ResolvedIndexAbstraction(String name) {
            this.name = name;
        }

        protected void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest.Replaceable {
        public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpen();
        private String[] names;
        private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
        private EnumSet<IndexMode> indexModes = EnumSet.noneOf(IndexMode.class);
        private ResolvedIndexExpressions resolvedIndexExpressions = null;
        private String projectRouting;

        public Request(String[] names) {
            this.names = names;
        }

        public Request(String[] names, IndicesOptions indicesOptions) {
            this.names = names;
            this.indicesOptions = indicesOptions;
        }

        public Request(String[] names, IndicesOptions indicesOptions, @Nullable EnumSet<IndexMode> indexModes) {
            this(names, indicesOptions, indexModes, null);
        }

        public Request(String[] names, IndicesOptions indicesOptions, @Nullable EnumSet<IndexMode> indexModes, @Nullable String projectRouting) {
            this.names = names;
            this.indicesOptions = indicesOptions;
            if (indexModes != null) {
                this.indexModes = indexModes;
            }
            this.projectRouting = projectRouting;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.indexModes = in.getTransportVersion().supports(RESOLVE_INDEX_MODE_FILTER) ? in.readEnumSet(IndexMode.class) : EnumSet.noneOf(IndexMode.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            if (out.getTransportVersion().supports(RESOLVE_INDEX_MODE_FILTER)) {
                out.writeEnumSet(this.indexModes);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && this.indexModes.equals(request.indexModes);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.names), this.indexModes);
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        @Override
        public boolean allowsRemoteIndices() {
            return true;
        }

        @Override
        public boolean allowsCrossProject() {
            return true;
        }

        @Override
        public void setResolvedIndexExpressions(ResolvedIndexExpressions expressions) {
            this.resolvedIndexExpressions = expressions;
        }

        @Override
        public ResolvedIndexExpressions getResolvedIndexExpressions() {
            return this.resolvedIndexExpressions;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public String getProjectRouting() {
            return this.projectRouting;
        }
    }
}

