/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class GetFieldMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final Map<String, Map<String, FieldMappingMetadata>> mappings;

    GetFieldMappingsResponse(Map<String, Map<String, FieldMappingMetadata>> mappings) {
        this.mappings = mappings;
    }

    GetFieldMappingsResponse(StreamInput in) throws IOException {
        this.mappings = in.readImmutableMap(mapIn -> mapIn.readImmutableMap(inpt -> new FieldMappingMetadata(inpt.readString(), inpt.readBytesReference())));
    }

    public Map<String, Map<String, FieldMappingMetadata>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetadata fieldMappings(String index, String field) {
        Map<String, FieldMappingMetadata> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        return indexMapping.get(field);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, Map<String, FieldMappingMetadata>> indexEntry : this.mappings.entrySet()) {
            builder.startObject(indexEntry.getKey());
            builder.startObject(MAPPINGS.getPreferredName());
            if (indexEntry.getValue() != null) {
                GetFieldMappingsResponse.addFieldMappingsToBuilder(builder, params, indexEntry.getValue());
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static void addFieldMappingsToBuilder(XContentBuilder builder, ToXContent.Params params, Map<String, FieldMappingMetadata> mappings) throws IOException {
        for (Map.Entry<String, FieldMappingMetadata> fieldEntry : mappings.entrySet()) {
            builder.startObject(fieldEntry.getKey());
            fieldEntry.getValue().toXContent(builder, params);
            builder.endObject();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.mappings, (outpt, map) -> outpt.writeMap(map, (o, v) -> {
            o.writeString(v.fullName());
            o.writeBytesReference(v.source);
        }));
    }

    public String toString() {
        return "GetFieldMappingsResponse{mappings=" + String.valueOf(this.mappings) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFieldMappingsResponse)) {
            return false;
        }
        GetFieldMappingsResponse that = (GetFieldMappingsResponse)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    public record FieldMappingMetadata(String fullName, BytesReference source) implements ToXContentFragment
    {
        private static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        private static final ParseField MAPPING = new ParseField("mapping", new String[0]);

        public Map<String, Object> sourceAsMap() {
            return (Map)XContentHelper.convertToMap(this.source, true, XContentType.JSON).v2();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FULL_NAME.getPreferredName(), this.fullName);
            if (params.paramAsBoolean("pretty", false)) {
                builder.field("mapping", this.sourceAsMap());
            } else {
                try (StreamInput stream = this.source.streamInput();){
                    builder.rawField(MAPPING.getPreferredName(), (InputStream)stream, XContentType.JSON);
                }
            }
            return builder;
        }
    }
}

