/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipUnavailableRule
implements TestRule {
    private final Map<String, Boolean> skipMap;

    public SkipUnavailableRule(String ... clusterAliases) {
        this.skipMap = Arrays.stream(clusterAliases).collect(Collectors.toMap(Function.identity(), alias -> true));
    }

    public Map<String, Boolean> getMap() {
        return this.skipMap;
    }

    public Statement apply(Statement base, Description description) {
        NotSkipped aliases = (NotSkipped)description.getAnnotation(NotSkipped.class);
        if (aliases != null) {
            for (String alias : aliases.aliases()) {
                this.skipMap.put(alias, false);
            }
        }
        return base;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NotSkipped {
        public String[] aliases();
    }
}

