/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.KeywordFieldSyntheticSourceSupport;
import org.elasticsearch.index.mapper.MapperTestCase;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.xcontent.XContentBuilder;

public final class TextFieldFamilySyntheticSourceTestSetup {
    public static MapperTestCase.SyntheticSourceSupport syntheticSourceSupport(String fieldType, boolean supportsCustomIndexConfiguration) {
        return new TextFieldFamilySyntheticSourceSupport(fieldType, supportsCustomIndexConfiguration);
    }

    public static void validateRoundTripReader(String syntheticSource, DirectoryReader reader, DirectoryReader roundTripReader) {
    }

    private static class TextFieldFamilySyntheticSourceSupport
    implements MapperTestCase.SyntheticSourceSupport {
        private final String fieldType;
        private final boolean store;
        private final boolean index;
        private final Integer ignoreAbove;
        private final KeywordFieldSyntheticSourceSupport keywordMultiFieldSyntheticSourceSupport;

        TextFieldFamilySyntheticSourceSupport(String fieldType, boolean supportsCustomIndexConfiguration) {
            this.fieldType = fieldType;
            this.store = ESTestCase.randomBoolean();
            this.index = !supportsCustomIndexConfiguration || ESTestCase.randomBoolean();
            this.ignoreAbove = ESTestCase.randomBoolean() ? null : Integer.valueOf(ESTestCase.between(10, 100));
            this.keywordMultiFieldSyntheticSourceSupport = new KeywordFieldSyntheticSourceSupport(this.ignoreAbove, ESTestCase.randomBoolean(), null, false);
        }

        @Override
        public boolean ignoreAbove() {
            return this.keywordMultiFieldSyntheticSourceSupport.ignoreAbove();
        }

        @Override
        public MapperTestCase.SyntheticSourceExample example(int maxValues) {
            if (this.store) {
                CheckedConsumer mapping = b -> {
                    b.field("type", this.fieldType);
                    b.field("store", true);
                    if (!this.index) {
                        b.field("index", false);
                    }
                };
                return this.storedFieldExample(maxValues, (CheckedConsumer<XContentBuilder, IOException>)mapping);
            }
            boolean loadingFromSource = this.ignoreAbove != null;
            MapperTestCase.SyntheticSourceExample delegate = this.keywordMultiFieldSyntheticSourceSupport.example(maxValues, loadingFromSource, true);
            return new MapperTestCase.SyntheticSourceExample(delegate.inputValue(), delegate.expectedForSyntheticSource(), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.field("type", this.fieldType);
                if (!this.index) {
                    b.field("index", false);
                }
                b.startObject("fields");
                b.startObject(ESTestCase.randomAlphaOfLength(4));
                delegate.mapping().accept(b);
                b.endObject();
                b.endObject();
            }));
        }

        private MapperTestCase.SyntheticSourceExample storedFieldExample(int maxValues, CheckedConsumer<XContentBuilder, IOException> mapping) {
            if (ESTestCase.randomBoolean()) {
                String randomString = this.randomString();
                return new MapperTestCase.SyntheticSourceExample(randomString, randomString, mapping);
            }
            List<String> list = ESTestCase.randomList(1, maxValues, this::randomString);
            List<String> output = list.size() == 1 ? list.get(0) : list;
            return new MapperTestCase.SyntheticSourceExample(list, output, mapping);
        }

        private String randomString() {
            return ESTestCase.randomAlphaOfLengthBetween(0, 10);
        }

        @Override
        public List<MapperTestCase.SyntheticSourceInvalidExample> invalidExample() throws IOException {
            return List.of();
        }
    }
}

