/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodeUtils;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.health.node.selection.HealthNodeTaskParams;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.test.ESTestCase;

public class ClusterStateCreationUtils {
    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRoutingState ... replicaStates) {
        return ClusterStateCreationUtils.state(Metadata.DEFAULT_PROJECT_ID, index, activePrimaryLocal, primaryState, replicaStates);
    }

    public static ClusterState state(ProjectId projectId, String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRoutingState ... replicaStates) {
        return ClusterStateCreationUtils.state(projectId, index, activePrimaryLocal, primaryState, Arrays.stream(replicaStates).map(shardRoutingState -> new Tuple(shardRoutingState, (Object)ShardRouting.Role.DEFAULT)).toList());
    }

    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaStates) {
        return ClusterStateCreationUtils.state(index, activePrimaryLocal, primaryState, ShardRouting.Role.DEFAULT, replicaStates);
    }

    public static ClusterState state(ProjectId projectId, String index, boolean activePrimaryLocal, ShardRoutingState primaryState, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaStates) {
        return ClusterStateCreationUtils.state(projectId, index, activePrimaryLocal, primaryState, ShardRouting.Role.DEFAULT, replicaStates);
    }

    public static ClusterState state(String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRouting.Role primaryRole, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaStates) {
        return ClusterStateCreationUtils.state(Metadata.DEFAULT_PROJECT_ID, index, activePrimaryLocal, primaryState, primaryRole, replicaStates);
    }

    public static ClusterState state(ProjectId projectId, String index, boolean activePrimaryLocal, ShardRoutingState primaryState, ShardRouting.Role primaryRole, List<Tuple<ShardRoutingState, ShardRouting.Role>> replicaStates) {
        assert (primaryState == ShardRoutingState.STARTED || primaryState == ShardRoutingState.RELOCATING || replicaStates.stream().allMatch(s -> s.v1() == ShardRoutingState.UNASSIGNED)) : "invalid shard states [" + String.valueOf(primaryState) + "] vs [" + Arrays.toString(replicaStates.stream().map(Tuple::v1).toArray(String[]::new)) + "]";
        int numberOfReplicas = replicaStates.size();
        int numberOfNodes = numberOfReplicas + 1;
        if (primaryState == ShardRoutingState.RELOCATING) {
            ++numberOfNodes;
        }
        for (Tuple<ShardRoutingState, ShardRouting.Role> state : replicaStates) {
            if (state.v1() != ShardRoutingState.RELOCATING) continue;
            ++numberOfNodes;
        }
        numberOfNodes = Math.max(2, numberOfNodes);
        ShardId shardId = new ShardId(index, "_na_", 0);
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> unassignedNodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            unassignedNodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        int primaryTerm = 1 + ESTestCase.randomInt(200);
        IndexLongFieldRange timeFieldRange = primaryState == ShardRoutingState.STARTED || primaryState == ShardRoutingState.RELOCATING ? IndexLongFieldRange.UNKNOWN : IndexLongFieldRange.NO_SHARDS;
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), 1, numberOfReplicas).put("index.creation_date", System.currentTimeMillis())).primaryTerm(0, (long)primaryTerm).timestampRange(timeFieldRange).eventIngestedRange(timeFieldRange).build();
        IndexShardRoutingTable.Builder indexShardRoutingBuilder = new IndexShardRoutingTable.Builder(shardId);
        String primaryNode = null;
        String relocatingNode = null;
        UnassignedInfo unassignedInfo = null;
        if (primaryState != ShardRoutingState.UNASSIGNED) {
            if (activePrimaryLocal) {
                primaryNode = ClusterStateCreationUtils.newNode(0).getId();
                unassignedNodes.remove(primaryNode);
            } else {
                HashSet<String> unassignedNodesExecludingPrimary = new HashSet<String>(unassignedNodes);
                unassignedNodesExecludingPrimary.remove(ClusterStateCreationUtils.newNode(0).getId());
                primaryNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodesExecludingPrimary);
                unassignedNodes.remove(primaryNode);
            }
            if (primaryState == ShardRoutingState.RELOCATING) {
                relocatingNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
            } else if (primaryState == ShardRoutingState.INITIALIZING) {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
            }
        } else {
            unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
        }
        indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, 0, primaryNode, true, primaryState).withRelocatingNodeId(relocatingNode).withUnassignedInfo(unassignedInfo).withRole(primaryRole).build());
        for (Tuple tuple : replicaStates) {
            String replicaNode = null;
            relocatingNode = null;
            unassignedInfo = null;
            if (tuple.v1() != ShardRoutingState.UNASSIGNED) {
                assert (primaryNode != null) : "a replica is assigned but the primary isn't";
                replicaNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
                if (tuple.v1() == ShardRoutingState.RELOCATING) {
                    relocatingNode = ClusterStateCreationUtils.selectAndRemove(unassignedNodes);
                }
            } else {
                unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
            }
            indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, shardId.id(), replicaNode, false, (ShardRoutingState)tuple.v1()).withRelocatingNodeId(relocatingNode).withUnassignedInfo(unassignedInfo).withRole((ShardRouting.Role)tuple.v2()).build());
        }
        IndexShardRoutingTable indexShardRoutingTable = indexShardRoutingBuilder.build();
        IndexMetadata.Builder builder = new IndexMetadata.Builder(indexMetadata);
        builder.putInSyncAllocationIds(0, indexShardRoutingTable.activeShards().stream().map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet()));
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(ProjectMetadata.builder((ProjectId)projectId).put(builder.build(), false)).generateClusterUuidIfNeeded());
        state.routingTable(GlobalRoutingTable.builder().put(projectId, RoutingTable.builder().add(IndexRoutingTable.builder((Index)indexMetadata.getIndex()).addIndexShard(indexShardRoutingBuilder))).build());
        return state.build();
    }

    public static ClusterState state(String index, int numberOfNodes, int numberOfPrimaries) {
        return ClusterStateCreationUtils.state(Metadata.DEFAULT_PROJECT_ID, index, numberOfNodes, numberOfPrimaries);
    }

    public static ClusterState state(ProjectId projectId, String indexName, int numberOfNodes, int numberOfPrimaries) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            nodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId((String)ESTestCase.randomFrom(nodes));
        IndexState index = ClusterStateCreationUtils.buildIndex(indexName, numberOfPrimaries, nodes);
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(ProjectMetadata.builder((ProjectId)projectId).put(index.indexMetadata, false)).generateClusterUuidIfNeeded());
        state.routingTable(GlobalRoutingTable.builder().put(projectId, RoutingTable.builder().add(index.indexRoutingTableBuilder)).build());
        return state.build();
    }

    public static ClusterState buildServerlessRoleNodes(String indexName, int numberOfPrimaries, int numberOfIndexNodes, int numberOfSearchNodes, int numberOfMLNodes) {
        DiscoveryNode node;
        int i;
        ProjectId projectId = Metadata.DEFAULT_PROJECT_ID;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> indexNodeIds = new HashSet<String>();
        for (i = 0; i < numberOfIndexNodes; ++i) {
            node = DiscoveryNodeUtils.builder("index_" + i).roles(Set.of(DiscoveryNodeRole.INDEX_ROLE)).build();
            discoBuilder = discoBuilder.add(node);
            indexNodeIds.add(node.getId());
        }
        for (i = 0; i < numberOfSearchNodes; ++i) {
            node = DiscoveryNodeUtils.builder("search_" + i).roles(Set.of(DiscoveryNodeRole.SEARCH_ROLE)).build();
            discoBuilder = discoBuilder.add(node);
        }
        for (i = 0; i < numberOfMLNodes; ++i) {
            node = DiscoveryNodeUtils.builder("ml_" + i).roles(Set.of(DiscoveryNodeRole.ML_ROLE)).build();
            discoBuilder = discoBuilder.add(node);
        }
        String localNodeId = (String)ESTestCase.randomFrom(indexNodeIds);
        discoBuilder.localNodeId(localNodeId);
        discoBuilder.masterNodeId(localNodeId);
        IndexState index = ClusterStateCreationUtils.buildIndex(indexName, numberOfPrimaries, indexNodeIds);
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(ProjectMetadata.builder((ProjectId)projectId).put(index.indexMetadata, false)).generateClusterUuidIfNeeded());
        state.routingTable(GlobalRoutingTable.builder().put(projectId, RoutingTable.builder().add(index.indexRoutingTableBuilder)).build());
        return state.build();
    }

    private static IndexState buildIndex(String indexName, int numberOfPrimaries, Set<String> nodeIds) {
        IndexMetadata indexMetadata = IndexMetadata.builder((String)indexName).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfPrimaries, 0).put("index.creation_date", System.currentTimeMillis())).build();
        IndexRoutingTable.Builder indexRoutingTable = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
        for (int i = 0; i < numberOfPrimaries; ++i) {
            ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
            IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, ESTestCase.randomFrom(nodeIds), true, ShardRoutingState.STARTED));
            indexRoutingTable.addIndexShard(indexShardRoutingBuilder);
        }
        return new IndexState(indexMetadata, indexRoutingTable);
    }

    public static ClusterState state(int numberOfNodes, String[] indices, int numberOfPrimaries) {
        return ClusterStateCreationUtils.state(Metadata.DEFAULT_PROJECT_ID, numberOfNodes, indices, numberOfPrimaries);
    }

    public static ClusterState state(ProjectId projectId, int numberOfNodes, String[] indices, int numberOfPrimaries) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        HashSet<String> nodes = new HashSet<String>();
        for (int i = 0; i < numberOfNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            nodes.add(node.getId());
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(0).getId());
        ProjectMetadata.Builder projectMetadata = ProjectMetadata.builder((ProjectId)projectId);
        RoutingTable.Builder routingTable = RoutingTable.builder();
        ArrayList nodesList = new ArrayList(nodes);
        int currentNodeToAssign = 0;
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfPrimaries, 0).put("index.creation_date", System.currentTimeMillis())).eventIngestedRange(IndexLongFieldRange.UNKNOWN).build();
            IndexRoutingTable.Builder indexRoutingTable = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfPrimaries; ++i) {
                ShardId shardId = new ShardId(indexMetadata.getIndex(), i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, (String)nodesList.get(currentNodeToAssign++), true, ShardRoutingState.STARTED));
                if (currentNodeToAssign == nodesList.size()) {
                    currentNodeToAssign = 0;
                }
                indexRoutingTable.addIndexShard(indexShardRoutingBuilder);
            }
            projectMetadata.put(indexMetadata, false);
            routingTable.add(indexRoutingTable);
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(projectMetadata).generateClusterUuidIfNeeded().build());
        state.routingTable(GlobalRoutingTable.builder().put(projectId, routingTable).build());
        return state.build();
    }

    public static ClusterState stateWithAssignedPrimariesAndOneReplica(String index, int numberOfShards) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndOneReplica(Metadata.DEFAULT_PROJECT_ID, index, numberOfShards);
    }

    public static ClusterState stateWithAssignedPrimariesAndOneReplica(ProjectId projectId, String index, int numberOfShards) {
        int numberOfNodes = 2;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
        }
        discoBuilder.localNodeId(ClusterStateCreationUtils.newNode(0).getId());
        discoBuilder.masterNodeId(ClusterStateCreationUtils.newNode(1).getId());
        IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfShards, 1).put("index.creation_date", System.currentTimeMillis())).build();
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().put(ProjectMetadata.builder((ProjectId)projectId).put(indexMetadata, false)).generateClusterUuidIfNeeded());
        IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
        for (int i = 0; i < numberOfShards; ++i) {
            ShardId shardId = new ShardId(index, "_na_", i);
            IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(0).getId(), null, true, ShardRoutingState.STARTED));
            indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(1).getId(), null, false, ShardRoutingState.STARTED));
            indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder);
        }
        state.routingTable(GlobalRoutingTable.builder().put(projectId, RoutingTable.builder().add(indexRoutingTableBuilder.build())).build());
        return state.build();
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(String[] indices, int numberOfShards, int numberOfReplicas) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndReplicas(Metadata.DEFAULT_PROJECT_ID, indices, numberOfShards, numberOfReplicas);
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(ProjectId projectId, String[] indices, int numberOfShards, int numberOfReplicas) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndReplicas(projectId, indices, numberOfShards, Collections.nCopies(numberOfReplicas, ShardRouting.Role.DEFAULT));
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(String[] indices, int numberOfShards, List<ShardRouting.Role> replicaRoles) {
        return ClusterStateCreationUtils.stateWithAssignedPrimariesAndReplicas(Metadata.DEFAULT_PROJECT_ID, indices, numberOfShards, replicaRoles);
    }

    public static ClusterState stateWithAssignedPrimariesAndReplicas(ProjectId projectId, String[] indices, int numberOfShards, List<ShardRouting.Role> replicaRoles) {
        int numberOfDataNodes = replicaRoles.size() + 1;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfDataNodes + 1; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            if (i == 0) {
                discoBuilder.localNodeId(node.getId());
                continue;
            }
            if (i != numberOfDataNodes) continue;
            discoBuilder.masterNodeId(node.getId());
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        Metadata.Builder metadataBuilder = Metadata.builder();
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder((ProjectId)projectId);
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfShards, replicaRoles.size()).put("index.creation_date", System.currentTimeMillis())).timestampRange(IndexLongFieldRange.UNKNOWN).eventIngestedRange(IndexLongFieldRange.UNKNOWN).build();
            projectBuilder.put(indexMetadata, false);
            IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(index, "_na_", i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(index, i, ClusterStateCreationUtils.newNode(0).getId(), null, true, ShardRoutingState.STARTED));
                for (int replica = 0; replica < replicaRoles.size(); ++replica) {
                    indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, i, ClusterStateCreationUtils.newNode(replica + 1).getId(), false, ShardRoutingState.STARTED).withRole(replicaRoles.get(replica)).build());
                }
                indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder);
            }
            routingTableBuilder.add(indexRoutingTableBuilder.build());
        }
        metadataBuilder.put(projectBuilder).generateClusterUuidIfNeeded();
        state.metadata(metadataBuilder);
        state.routingTable(GlobalRoutingTable.builder().put(projectId, routingTableBuilder).build());
        return state.build();
    }

    public static ClusterState stateWithUnassignedPrimariesAndReplicas(String[] indices, int numberOfShards, int numberOfReplicas) {
        return ClusterStateCreationUtils.stateWithUnassignedPrimariesAndReplicas(Metadata.DEFAULT_PROJECT_ID, indices, numberOfShards, Collections.nCopies(numberOfReplicas, ShardRouting.Role.DEFAULT));
    }

    public static ClusterState stateWithUnassignedPrimariesAndReplicas(ProjectId projectId, String[] indices, int numberOfShards, List<ShardRouting.Role> replicaRoles) {
        int numberOfDataNodes = replicaRoles.size() + 1;
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (int i = 0; i < numberOfDataNodes; ++i) {
            DiscoveryNode node = ClusterStateCreationUtils.newNode(i);
            discoBuilder = discoBuilder.add(node);
            if (i != 0) continue;
            discoBuilder.localNodeId(node.getId());
            discoBuilder.masterNodeId(node.getId());
        }
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        Metadata.Builder metadataBuilder = Metadata.builder();
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder((ProjectId)projectId);
        for (String index : indices) {
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfShards, replicaRoles.size()).put("index.creation_date", System.currentTimeMillis())).timestampRange(IndexLongFieldRange.UNKNOWN).eventIngestedRange(IndexLongFieldRange.UNKNOWN).build();
            projectBuilder.put(indexMetadata, false);
            IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(index, "_na_", i);
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.INDEX_CREATED, null);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, i, null, true, ShardRoutingState.UNASSIGNED).withUnassignedInfo(unassignedInfo).build());
                for (int replica = 0; replica < replicaRoles.size(); ++replica) {
                    indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(index, i, null, false, ShardRoutingState.UNASSIGNED).withRole(replicaRoles.get(replica)).withUnassignedInfo(unassignedInfo).build());
                }
                indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder);
            }
            routingTableBuilder.add(indexRoutingTableBuilder.build());
        }
        metadataBuilder.put(projectBuilder).generateClusterUuidIfNeeded();
        state.metadata(metadataBuilder);
        state.routingTable(GlobalRoutingTable.builder().put(projectId, routingTableBuilder).build());
        return state.build();
    }

    public static Tuple<ProjectMetadata.Builder, RoutingTable.Builder> projectWithAssignedPrimariesAndReplicas(ProjectId projectId, String[] indices, int numberOfShards, int numberOfReplicas, DiscoveryNodes nodes) {
        return ClusterStateCreationUtils.projectWithAssignedPrimariesAndReplicas(projectId, indices, numberOfShards, Collections.nCopies(numberOfReplicas, ShardRouting.Role.DEFAULT), nodes);
    }

    private static Tuple<ProjectMetadata.Builder, RoutingTable.Builder> projectWithAssignedPrimariesAndReplicas(ProjectId projectId, String[] indices, int numberOfShards, List<ShardRouting.Role> replicaRoles, DiscoveryNodes nodes) {
        ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder((ProjectId)projectId);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        Iterator nodeIterator = Iterators.cycling((Iterable)nodes);
        for (String index : indices) {
            String uuid = UUIDs.base64UUID();
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(ESTestCase.indexSettings(IndexVersion.current(), numberOfShards, replicaRoles.size()).put("index.creation_date", System.currentTimeMillis()).put("index.uuid", uuid)).timestampRange(IndexLongFieldRange.UNKNOWN).eventIngestedRange(IndexLongFieldRange.UNKNOWN).build();
            projectBuilder.put(indexMetadata, false);
            IndexRoutingTable.Builder indexRoutingTableBuilder = IndexRoutingTable.builder((Index)indexMetadata.getIndex());
            for (int i = 0; i < numberOfShards; ++i) {
                ShardId shardId = new ShardId(index, uuid, i);
                IndexShardRoutingTable.Builder indexShardRoutingBuilder = IndexShardRoutingTable.builder((ShardId)shardId);
                indexShardRoutingBuilder.addShard(TestShardRouting.newShardRouting(shardId, ((DiscoveryNode)nodeIterator.next()).getId(), null, true, ShardRoutingState.STARTED));
                for (int replica = 0; replica < replicaRoles.size(); ++replica) {
                    indexShardRoutingBuilder.addShard(TestShardRouting.shardRoutingBuilder(shardId, ((DiscoveryNode)nodeIterator.next()).getId(), false, ShardRoutingState.STARTED).withRole(replicaRoles.get(replica)).build());
                }
                indexRoutingTableBuilder.addIndexShard(indexShardRoutingBuilder);
            }
            routingTableBuilder.add(indexRoutingTableBuilder.build());
        }
        return new Tuple((Object)projectBuilder, (Object)routingTableBuilder);
    }

    public static ClusterState stateWithActivePrimary(String index, boolean activePrimaryLocal, int numberOfReplicas) {
        return ClusterStateCreationUtils.stateWithActivePrimary(Metadata.DEFAULT_PROJECT_ID, index, activePrimaryLocal, numberOfReplicas);
    }

    public static ClusterState stateWithActivePrimary(ProjectId projectId, String index, boolean activePrimaryLocal, int numberOfReplicas) {
        int assignedReplicas = ESTestCase.randomIntBetween(0, numberOfReplicas);
        return ClusterStateCreationUtils.stateWithActivePrimary(projectId, index, activePrimaryLocal, assignedReplicas, numberOfReplicas - assignedReplicas);
    }

    public static ClusterState stateWithActivePrimary(String index, boolean activePrimaryLocal, int assignedReplicas, int unassignedReplicas) {
        return ClusterStateCreationUtils.stateWithActivePrimary(Metadata.DEFAULT_PROJECT_ID, index, activePrimaryLocal, assignedReplicas, unassignedReplicas);
    }

    public static ClusterState stateWithActivePrimary(ProjectId projectId, String index, boolean activePrimaryLocal, int assignedReplicas, int unassignedReplicas) {
        int i;
        ShardRoutingState[] replicaStates = new ShardRoutingState[assignedReplicas + unassignedReplicas];
        for (i = 0; i < assignedReplicas; ++i) {
            replicaStates[i] = ESTestCase.randomFrom(ShardRoutingState.INITIALIZING, ShardRoutingState.STARTED, ShardRoutingState.RELOCATING);
        }
        for (i = assignedReplicas; i < replicaStates.length; ++i) {
            replicaStates[i] = ShardRoutingState.UNASSIGNED;
        }
        return ClusterStateCreationUtils.state(projectId, index, activePrimaryLocal, ESTestCase.randomFrom(ShardRoutingState.STARTED, ShardRoutingState.RELOCATING), replicaStates);
    }

    public static ClusterState stateWithNoShard() {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        DiscoveryNode localNode = ClusterStateCreationUtils.newNode(0);
        discoBuilder.add(localNode);
        discoBuilder.localNodeId(localNode.getId());
        DiscoveryNode masterNode = ClusterStateCreationUtils.newNode(1);
        discoBuilder.add(masterNode);
        discoBuilder.masterNodeId(masterNode.getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        state.metadata(Metadata.builder().generateClusterUuidIfNeeded());
        state.routingTable(GlobalRoutingTable.builder().build());
        return state.build();
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode ... allNodes) {
        return ClusterStateCreationUtils.state(localNode, masterNode, null, allNodes);
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode[] allNodes, TransportVersion transportVersion) {
        return ClusterStateCreationUtils.state(localNode, masterNode, null, allNodes, transportVersion);
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode healthNode, DiscoveryNode ... allNodes) {
        return ClusterStateCreationUtils.state(localNode, masterNode, healthNode, allNodes, TransportVersion.current());
    }

    public static ClusterState state(DiscoveryNode localNode, DiscoveryNode masterNode, DiscoveryNode healthNode, DiscoveryNode[] allNodes, TransportVersion transportVersion) {
        DiscoveryNodes.Builder discoBuilder = DiscoveryNodes.builder();
        for (DiscoveryNode node : allNodes) {
            discoBuilder.add(node);
        }
        if (masterNode != null) {
            discoBuilder.masterNodeId(masterNode.getId());
            discoBuilder.add(masterNode);
        }
        discoBuilder.localNodeId(localNode.getId());
        ClusterState.Builder state = ClusterState.builder((ClusterName)new ClusterName("test"));
        state.nodes(discoBuilder);
        for (DiscoveryNode node : allNodes) {
            state.putCompatibilityVersions(node.getId(), transportVersion, SystemIndices.SERVER_SYSTEM_MAPPINGS_VERSIONS);
        }
        Metadata.Builder metadataBuilder = Metadata.builder().generateClusterUuidIfNeeded();
        if (healthNode != null) {
            ClusterStateCreationUtils.addHealthNode(metadataBuilder, healthNode);
        }
        state.metadata(metadataBuilder);
        return state.build();
    }

    private static DiscoveryNode newNode(int nodeId) {
        return DiscoveryNodeUtils.create("node_" + nodeId);
    }

    private static String selectAndRemove(Set<String> strings) {
        String selection = ESTestCase.randomFrom(strings.toArray(new String[strings.size()]));
        strings.remove(selection);
        return selection;
    }

    private static Metadata.Builder addHealthNode(Metadata.Builder metadataBuilder, DiscoveryNode healthNode) {
        ClusterPersistentTasksCustomMetadata.Builder tasks = ClusterPersistentTasksCustomMetadata.builder();
        PersistentTasksCustomMetadata.Assignment assignment = new PersistentTasksCustomMetadata.Assignment(healthNode.getId(), ESTestCase.randomAlphaOfLength(10));
        tasks.addTask("health-node", "health-node", (PersistentTaskParams)HealthNodeTaskParams.INSTANCE, assignment);
        return metadataBuilder.putCustom("cluster_persistent_tasks", (Metadata.ClusterCustom)tasks.build());
    }

    private record IndexState(IndexMetadata indexMetadata, IndexRoutingTable.Builder indexRoutingTableBuilder) {
    }
}

