/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.internal.ReaderContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.AuthorizationServiceField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;

public final class SecuritySearchOperationListener
implements SearchOperationListener {
    private final SecurityContext securityContext;
    private final AuditTrailService auditTrailService;

    public SecuritySearchOperationListener(SecurityContext securityContext, AuditTrailService auditTrail) {
        this.securityContext = securityContext;
        this.auditTrailService = auditTrail;
    }

    public void onNewScrollContext(ReaderContext readerContext) {
        readerContext.putInContext("_xpack_security_authentication", (Object)this.securityContext.getAuthentication());
        this.securityContext.copyIndicesAccessControlToReaderContext(readerContext);
    }

    public void validateReaderContext(ReaderContext readerContext, TransportRequest request) {
        if (readerContext.scrollContext() != null) {
            Authentication originalAuth = (Authentication)readerContext.getFromContext("_xpack_security_authentication");
            if (!this.securityContext.canIAccessResourcesCreatedBy(originalAuth)) {
                this.auditAccessDenied(request);
                throw new SearchContextMissingException(readerContext.id());
            }
            if (null == AuthorizationServiceField.INDICES_PERMISSIONS_VALUE.get(this.securityContext.getThreadContext())) {
                this.securityContext.copyIndicesAccessControlFromReaderContext(readerContext);
            }
        }
    }

    public void onPreFetchPhase(SearchContext searchContext) {
        this.ensureIndicesAccessControlForScrollThreadContext(searchContext);
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        this.ensureIndicesAccessControlForScrollThreadContext(searchContext);
    }

    void ensureIndicesAccessControlForScrollThreadContext(SearchContext searchContext) {
        IndicesAccessControl threadIndicesAccessControl;
        if (searchContext.readerContext().scrollContext() != null && null == (threadIndicesAccessControl = (IndicesAccessControl)AuthorizationServiceField.INDICES_PERMISSIONS_VALUE.get(this.securityContext.getThreadContext()))) {
            throw new ElasticsearchSecurityException("Unexpected null indices access control for search context [" + String.valueOf(searchContext.id()) + "] for request [" + searchContext.request().getDescription() + "] with source [" + searchContext.source() + "]", new Object[0]);
        }
    }

    private void auditAccessDenied(TransportRequest request) {
        this.auditTrailService.get().accessDenied(AuditUtil.extractRequestId(this.securityContext.getThreadContext()), this.securityContext.getAuthentication(), (String)AuthorizationServiceField.ORIGINATING_ACTION_VALUE.get(this.securityContext.getThreadContext()), request, (AuthorizationEngine.AuthorizationInfo)AuthorizationServiceField.AUTHORIZATION_INFO_VALUE.get(this.securityContext.getThreadContext()));
    }
}

