/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.stats;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocCountFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.BlockLoaderFunctionConfig;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public class SearchContextStats
implements SearchStats {
    private final List<SearchExecutionContext> contexts;
    private static final int CACHE_SIZE = 32;
    private final Map<String, FieldStats> cache = new LinkedHashMap<String, FieldStats>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FieldStats> eldest) {
            return this.size() > 32;
        }
    };

    public static SearchStats from(List<SearchExecutionContext> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            return SearchStats.EMPTY;
        }
        return new SearchContextStats(contexts);
    }

    private SearchContextStats(List<SearchExecutionContext> contexts) {
        this.contexts = contexts;
        assert (contexts != null && !contexts.isEmpty());
    }

    private FieldStats makeFieldStats(String field) {
        FieldStats stat = new FieldStats();
        stat.config = this.makeFieldConfig(field);
        return stat;
    }

    private FieldConfig makeFieldConfig(String field) {
        boolean exists = false;
        boolean hasExactSubfield = true;
        boolean indexed = true;
        boolean hasDocValues = true;
        boolean mixedFieldType = false;
        MappedFieldType fieldType = null;
        for (SearchExecutionContext context : this.contexts) {
            if (context.isFieldMapped(field)) {
                TextFieldMapper.TextFieldType t;
                MappedFieldType type = context.getFieldType(field);
                if (fieldType == null) {
                    fieldType = type;
                } else if (!mixedFieldType && !fieldType.typeName().equals(type.typeName())) {
                    mixedFieldType = true;
                }
                exists |= true;
                indexed &= type.indexType().hasDenseIndex();
                hasDocValues &= type.hasDocValues();
                hasExactSubfield &= type instanceof TextFieldMapper.TextFieldType && (t = (TextFieldMapper.TextFieldType)type).canUseSyntheticSourceDelegateForQuerying();
            } else {
                indexed = false;
                hasDocValues = false;
                hasExactSubfield = false;
            }
            if (!exists || indexed || hasDocValues || hasExactSubfield) continue;
            break;
        }
        if (!exists) {
            return new FieldConfig(false, false, false, false);
        }
        return new FieldConfig(exists, hasExactSubfield, indexed, hasDocValues, mixedFieldType ? null : fieldType);
    }

    private boolean fastNoCacheFieldExists(String field) {
        for (SearchExecutionContext context : this.contexts) {
            if (!context.isFieldMapped(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(FieldAttribute.FieldName field) {
        FieldStats stat = this.cache.get(field.string());
        return stat != null ? stat.config.exists : this.fastNoCacheFieldExists(field.string());
    }

    @Override
    public boolean isIndexed(FieldAttribute.FieldName field) {
        return this.cache.computeIfAbsent((String)field.string(), (Function<String, FieldStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, makeFieldStats(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/esql/stats/SearchContextStats$FieldStats;)((SearchContextStats)this)).config.indexed;
    }

    @Override
    public boolean hasDocValues(FieldAttribute.FieldName field) {
        return this.cache.computeIfAbsent((String)field.string(), (Function<String, FieldStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, makeFieldStats(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/esql/stats/SearchContextStats$FieldStats;)((SearchContextStats)this)).config.hasDocValues;
    }

    @Override
    public boolean supportsLoaderConfig(FieldAttribute.FieldName name, BlockLoaderFunctionConfig config, MappedFieldType.FieldExtractPreference preference) {
        if (config == null) {
            throw new UnsupportedOperationException("config must be provided");
        }
        for (SearchExecutionContext context : this.contexts) {
            MappedFieldType ft = context.getFieldType(name.string());
            if (ft == null) {
                return false;
            }
            if (ft.supportsBlockLoaderConfig(config, preference)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasExactSubfield(FieldAttribute.FieldName field) {
        return this.cache.computeIfAbsent((String)field.string(), (Function<String, FieldStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, makeFieldStats(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/esql/stats/SearchContextStats$FieldStats;)((SearchContextStats)this)).config.hasExactSubfield;
    }

    @Override
    public long count() {
        long[] count = new long[]{0L};
        boolean completed = this.doWithContexts(r -> {
            count[0] = count[0] + (long)r.numDocs();
            return true;
        }, false);
        return completed ? count[0] : -1L;
    }

    @Override
    public long count(FieldAttribute.FieldName field) {
        FieldStats stat = this.cache.computeIfAbsent(field.string(), this::makeFieldStats);
        if (stat.count == null) {
            long[] count = new long[]{0L};
            boolean completed = this.doWithContexts(r -> {
                count[0] = count[0] + SearchContextStats.countEntries(r, field.string());
                return true;
            }, false);
            stat.count = completed ? count[0] : -1L;
        }
        return stat.count;
    }

    @Override
    public long count(FieldAttribute.FieldName field, BytesRef value) {
        long[] count = new long[]{0L};
        Term term = new Term(field.string(), value);
        boolean completed = this.doWithContexts(r -> {
            count[0] = count[0] + (long)r.docFreq(term);
            return true;
        }, false);
        return completed ? count[0] : -1L;
    }

    @Override
    public Object min(FieldAttribute.FieldName field) {
        DateFieldMapper.DateFieldType dft;
        boolean hasDocValueSkipper;
        FieldStats stat = this.cache.computeIfAbsent(field.string(), this::makeFieldStats);
        MappedFieldType fieldType = stat.config.fieldType;
        boolean bl = hasDocValueSkipper = fieldType instanceof DateFieldMapper.DateFieldType && (dft = (DateFieldMapper.DateFieldType)fieldType).hasDocValuesSkipper();
        if (fieldType == null || !hasDocValueSkipper && !stat.config.indexed || !(fieldType instanceof DateFieldMapper.DateFieldType)) {
            return null;
        }
        if (stat.min == null) {
            long[] min = new long[]{Long.MAX_VALUE};
            Holder foundMinValue = new Holder((Object)false);
            this.doWithContexts(r -> {
                long minValue = Long.MAX_VALUE;
                if (hasDocValueSkipper) {
                    minValue = DocValuesSkipper.globalMinValue((IndexSearcher)new IndexSearcher(r), (String)field.string());
                } else {
                    byte[] minPackedValue = PointValues.getMinPackedValue((IndexReader)r, (String)field.string());
                    if (minPackedValue != null && minPackedValue.length == 8) {
                        minValue = NumericUtils.sortableBytesToLong((byte[])minPackedValue, (int)0);
                    }
                }
                if (minValue <= min[0]) {
                    min[0] = minValue;
                    foundMinValue.set((Object)true);
                }
                return true;
            }, true);
            stat.min = (Boolean)foundMinValue.get() != false ? Long.valueOf(min[0]) : null;
        }
        return stat.min;
    }

    @Override
    public Object max(FieldAttribute.FieldName field) {
        DateFieldMapper.DateFieldType dft;
        boolean hasDocValueSkipper;
        FieldStats stat = this.cache.computeIfAbsent(field.string(), this::makeFieldStats);
        MappedFieldType fieldType = stat.config.fieldType;
        boolean bl = hasDocValueSkipper = fieldType instanceof DateFieldMapper.DateFieldType && (dft = (DateFieldMapper.DateFieldType)fieldType).hasDocValuesSkipper();
        if (fieldType == null || !hasDocValueSkipper && !stat.config.indexed || !(fieldType instanceof DateFieldMapper.DateFieldType)) {
            return null;
        }
        if (stat.max == null) {
            long[] max = new long[]{Long.MIN_VALUE};
            Holder foundMaxValue = new Holder((Object)false);
            this.doWithContexts(r -> {
                long maxValue = Long.MIN_VALUE;
                if (hasDocValueSkipper) {
                    maxValue = DocValuesSkipper.globalMaxValue((IndexSearcher)new IndexSearcher(r), (String)field.string());
                } else {
                    byte[] maxPackedValue = PointValues.getMaxPackedValue((IndexReader)r, (String)field.string());
                    if (maxPackedValue != null && maxPackedValue.length == 8) {
                        maxValue = NumericUtils.sortableBytesToLong((byte[])maxPackedValue, (int)0);
                    }
                }
                if (maxValue >= max[0]) {
                    max[0] = maxValue;
                    foundMaxValue.set((Object)true);
                }
                return true;
            }, true);
            stat.max = (Boolean)foundMaxValue.get() != false ? Long.valueOf(max[0]) : null;
        }
        return stat.max;
    }

    @Override
    public boolean isSingleValue(FieldAttribute.FieldName field) {
        String fieldName = field.string();
        FieldStats stat = this.cache.computeIfAbsent(fieldName, this::makeFieldStats);
        if (stat.singleValue == null) {
            if (!stat.config.exists) {
                stat.singleValue = true;
            } else {
                boolean[] sv = new boolean[]{false};
                for (SearchExecutionContext context : this.contexts) {
                    MappedFieldType mappedType = context.isFieldMapped(fieldName) ? context.getFieldType(fieldName) : null;
                    if (mappedType == null) continue;
                    sv[0] = true;
                    this.doWithContexts(r -> {
                        sv[0] = sv[0] & this.detectSingleValue(r, mappedType, fieldName);
                        return sv[0];
                    }, true);
                    break;
                }
                stat.singleValue = sv[0];
            }
        }
        return stat.singleValue;
    }

    private boolean detectSingleValue(IndexReader r, MappedFieldType fieldType, String name) throws IOException {
        boolean found;
        String typeName;
        if (fieldType instanceof ConstantFieldType || fieldType instanceof DocCountFieldMapper.DocCountFieldType || fieldType instanceof DataStreamTimestampFieldMapper.TimestampFieldType) {
            return true;
        }
        switch (typeName = fieldType.typeName()) {
            case "_id": 
            case "_seq_no": {
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = found = false;
            }
        }
        if (found) {
            return true;
        }
        DocCountTester tester = null;
        if (fieldType instanceof DateFieldMapper.DateFieldType || fieldType instanceof NumberFieldMapper.NumberFieldType) {
            tester = lr -> {
                PointValues values = lr.getPointValues(name);
                return values == null || values.size() == (long)values.getDocCount();
            };
        } else if (fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            tester = lr -> {
                Terms terms = lr.terms(name);
                return terms == null || terms.size() == (long)terms.getDocCount();
            };
        }
        if (tester != null) {
            for (LeafReaderContext context : r.leaves()) {
                if (tester.test(context.reader()).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canUseEqualityOnSyntheticSourceDelegate(FieldAttribute.FieldName name, String value) {
        for (SearchExecutionContext ctx : this.contexts) {
            MappedFieldType type = ctx.getFieldType(name.string());
            if (type == null) {
                return false;
            }
            if (type instanceof TextFieldMapper.TextFieldType) {
                TextFieldMapper.TextFieldType t = (TextFieldMapper.TextFieldType)type;
                if (t.canUseSyntheticSourceDelegateForQueryingEquality(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String constantValue(FieldAttribute.FieldName name) {
        String val = null;
        for (SearchExecutionContext ctx : this.contexts) {
            MappedFieldType f = ctx.getFieldType(name.string());
            if (f == null) {
                return null;
            }
            if (f instanceof ConstantFieldType) {
                ConstantFieldType cf = (ConstantFieldType)f;
                ValueFetcher fetcher = cf.valueFetcher(ctx, null);
                String thisVal = null;
                try {
                    List vals = fetcher.fetchValues(null, -1, null);
                    Object objVal = vals.size() == 1 ? vals.get(0) : null;
                    thisVal = objVal instanceof String ? (String)objVal : null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (thisVal == null) {
                    return null;
                }
                if (val == null) {
                    val = thisVal;
                    continue;
                }
                if (thisVal.equals(val)) continue;
                return null;
            }
            return null;
        }
        return val;
    }

    @Override
    public MappedFieldType fieldType(FieldAttribute.FieldName field) {
        return this.cache.computeIfAbsent((String)field.string(), (Function<String, FieldStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, makeFieldStats(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/esql/stats/SearchContextStats$FieldStats;)((SearchContextStats)this)).config.fieldType;
    }

    private static long countEntries(IndexReader indexReader, String field) {
        long count = 0L;
        try {
            for (LeafReaderContext context : indexReader.leaves()) {
                LeafReader reader = context.reader();
                FieldInfos fieldInfos = reader.getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                if (fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                    return -1L;
                }
                if (fieldInfo.getPointIndexDimensionCount() > 0) {
                    PointValues points = reader.getPointValues(field);
                    if (points == null) continue;
                    count += points.size();
                    continue;
                }
                if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                    Terms terms = reader.terms(field);
                    if (terms == null) continue;
                    count += terms.getSumTotalTermFreq();
                    continue;
                }
                return -1L;
            }
        }
        catch (IOException ex) {
            throw new EsqlIllegalArgumentException("Cannot access data storage", ex);
        }
        return count;
    }

    private boolean doWithContexts(IndexReaderConsumer consumer, boolean acceptsDeletions) {
        try {
            for (SearchExecutionContext context : this.contexts) {
                for (LeafReaderContext leafContext : context.searcher().getLeafContexts()) {
                    LeafReader reader = leafContext.reader();
                    if (!acceptsDeletions && reader.hasDeletions()) {
                        return false;
                    }
                    if (consumer.consume((IndexReader)reader)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (IOException ex) {
            throw new EsqlIllegalArgumentException("Cannot access data storage", ex);
        }
    }

    @Override
    public Map<ShardId, IndexMetadata> targetShards() {
        Map shards = Maps.newHashMapWithExpectedSize((int)this.contexts.size());
        for (SearchExecutionContext context : this.contexts) {
            IndexMetadata indexMetadata = context.getIndexSettings().getIndexMetadata();
            ShardId shardId = new ShardId(context.index(), context.getShardId());
            shards.putIfAbsent(shardId, indexMetadata);
        }
        return shards;
    }

    private static class FieldStats {
        private Long count;
        private Object min;
        private Object max;
        private Boolean singleValue;
        private FieldConfig config;

        private FieldStats() {
        }
    }

    private record FieldConfig(boolean exists, boolean hasExactSubfield, boolean indexed, boolean hasDocValues, MappedFieldType fieldType) {
        FieldConfig(boolean exists, boolean hasExactSubfield, boolean indexed, boolean hasDocValues) {
            this(exists, hasExactSubfield, indexed, hasDocValues, null);
        }
    }

    private static interface IndexReaderConsumer {
        public boolean consume(IndexReader var1) throws IOException;
    }

    private static interface DocCountTester {
        public Boolean test(LeafReader var1) throws IOException;
    }
}

