/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.selector;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.LabelMatcher;

public class LabelMatchers {
    public static final LabelMatchers EMPTY = new LabelMatchers(Collections.emptyList());
    private final List<LabelMatcher> labelMatchers;
    private final Map<String, LabelMatcher> nameToMatcher;

    public LabelMatchers(List<LabelMatcher> labelMatchers) {
        Objects.requireNonNull(labelMatchers, "label matchers cannot be null");
        this.labelMatchers = labelMatchers;
        int size = labelMatchers.size();
        if (size == 0) {
            this.nameToMatcher = Collections.emptyMap();
        } else {
            this.nameToMatcher = Maps.newLinkedHashMapWithExpectedSize((int)size);
            for (LabelMatcher lm : labelMatchers) {
                this.nameToMatcher.put(lm.name(), lm);
            }
        }
    }

    public List<LabelMatcher> matchers() {
        return this.labelMatchers;
    }

    public LabelMatcher nameLabel() {
        return this.nameToMatcher.get("__name__");
    }

    public boolean isEmpty() {
        return this.labelMatchers.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.labelMatchers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LabelMatchers other = (LabelMatchers)obj;
        return Objects.equals(this.labelMatchers, other.labelMatchers);
    }

    public String toString() {
        return this.labelMatchers.toString();
    }
}

