/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Dissect
extends RegexExtract
implements TelemetryAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Dissect", Dissect::new);
    private final Parser parser;

    public Dissect(Source source, LogicalPlan child, Expression input, Parser parser, List<Attribute> extracted) {
        super(source, child, input, extracted);
        this.parser = parser;
    }

    private Dissect(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), Parser.readFrom(in), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.input());
        this.parser.writeTo(out);
        out.writeNamedWriteableCollection(this.extractedFields());
    }

    public String getWriteableName() {
        return Dissect.ENTRY.name;
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Dissect(this.source(), newChild, this.input, this.parser, this.extractedFields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Dissect::new, (Object)((Object)this.child()), (Object)this.input, (Object)this.parser, (Object)this.extractedFields);
    }

    @Override
    public Dissect withGeneratedNames(List<String> newNames) {
        return new Dissect(this.source(), this.child(), this.input, this.parser, this.renameExtractedFields(newNames));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Dissect dissect = (Dissect)o;
        return Objects.equals(this.parser, dissect.parser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parser);
    }

    public Parser parser() {
        return this.parser;
    }

    public record Parser(String pattern, String appendSeparator, DissectParser parser) implements Writeable
    {
        public static Parser readFrom(StreamInput in) throws IOException {
            String pattern = in.readString();
            String appendSeparator = in.readString();
            return new Parser(pattern, appendSeparator, new DissectParser(pattern, appendSeparator));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern());
            out.writeString(this.appendSeparator());
        }

        public List<Attribute> keyAttributes(Source src) {
            ArrayList<Attribute> keys = new ArrayList<Attribute>();
            for (String x : this.parser.outputKeys()) {
                if (x.isEmpty()) continue;
                keys.add((Attribute)new ReferenceAttribute(src, null, x, DataType.KEYWORD));
            }
            return keys;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Parser that = (Parser)other;
            return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.appendSeparator, that.appendSeparator);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern, this.appendSeparator);
        }
    }
}

