/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.score;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.score.Decay;

public final class DecayDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DecayDoubleEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator value;
    private final double origin;
    private final double scale;
    private final double offset;
    private final double decay;
    private final Decay.DecayFunction decayFunction;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DecayDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator value, double origin, double scale, double offset, double decay, Decay.DecayFunction decayFunction, DriverContext driverContext) {
        this.source = source;
        this.value = value;
        this.origin = origin;
        this.scale = scale;
        this.offset = offset;
        this.decay = decay;
        this.decayFunction = decayFunction;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock valueBlock = (DoubleBlock)this.value.eval(page);){
            DoubleVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valueVector).asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.value.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock valueBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (valueBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                double value = valueBlock.getDouble(valueBlock.getFirstValueIndex(p));
                result.appendDouble(Decay.process(value, this.origin, this.scale, this.offset, this.decay, this.decayFunction));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector valueVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double value = valueVector.getDouble(p);
                result.appendDouble(p, Decay.process(value, this.origin, this.scale, this.offset, this.decay, this.decayFunction));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "DecayDoubleEvaluator[value=" + String.valueOf(this.value) + ", origin=" + this.origin + ", scale=" + this.scale + ", offset=" + this.offset + ", decay=" + this.decay + ", decayFunction=" + String.valueOf((Object)this.decayFunction) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final double origin;
        private final double scale;
        private final double offset;
        private final double decay;
        private final Decay.DecayFunction decayFunction;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, double origin, double scale, double offset, double decay, Decay.DecayFunction decayFunction) {
            this.source = source;
            this.value = value;
            this.origin = origin;
            this.scale = scale;
            this.offset = offset;
            this.decay = decay;
            this.decayFunction = decayFunction;
        }

        public DecayDoubleEvaluator get(DriverContext context) {
            return new DecayDoubleEvaluator(this.source, this.value.get(context), this.origin, this.scale, this.offset, this.decay, this.decayFunction, context);
        }

        public String toString() {
            return "DecayDoubleEvaluator[value=" + String.valueOf(this.value) + ", origin=" + this.origin + ", scale=" + this.scale + ", offset=" + this.offset + ", decay=" + this.decay + ", decayFunction=" + String.valueOf((Object)this.decayFunction) + "]";
        }
    }
}

