/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvContainsBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvContainsBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvContainsDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvContainsIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvContainsLongEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvContains
extends BinaryScalarFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvContains", MvContains::new);

    @FunctionInfo(returnType={"boolean"}, description="Checks if all values yielded by the second multivalue expression are present in the values yielded by the first multivalue expression. Returns a boolean. Null values are treated as an empty set.", examples={@Example(file="string", tag="mv_contains"), @Example(file="string", tag="mv_contains_bothsides"), @Example(file="string", tag="mv_contains_where")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")})
    public MvContains(Source source, @Param(name="superset", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression superset, @Param(name="subset", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression subset) {
        super(source, superset, subset);
    }

    private MvContains(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvContains.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.left(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.left().dataType() == DataType.NULL) {
            return TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        }
        return TypeResolutions.isType((Expression)this.right(), t -> t.noText() == this.left().dataType().noText(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{this.left().dataType().noText().typeName()});
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    protected MvContains replaceChildren(Expression newLeft, Expression newRight) {
        return new MvContains(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvContains::new, (Object)this.left(), (Object)this.right());
    }

    public Object fold(FoldContext ctx) {
        return EvaluatorMapper.super.fold(this.source(), ctx);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        ElementType supersetType = PlannerUtils.toElementType(this.left().dataType());
        ElementType subsetType = PlannerUtils.toElementType(this.right().dataType());
        if (subsetType == ElementType.NULL) {
            return EvalOperator.CONSTANT_TRUE_FACTORY;
        }
        if (supersetType != ElementType.NULL && supersetType != subsetType) {
            throw new EsqlIllegalArgumentException("Incompatible data types for MvContains, superset type({}) value({}) and subset type({}) value({}) don't match.", supersetType, this.left(), subsetType, this.right());
        }
        return switch (supersetType) {
            case ElementType.BOOLEAN -> new MvContainsBooleanEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.BYTES_REF -> new MvContainsBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.DOUBLE -> new MvContainsDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.INT -> new MvContainsIntEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.LONG -> new MvContainsLongEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.NULL -> new IsNull.IsNullEvaluatorFactory(toEvaluator.apply(this.right()));
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
        };
    }

    static boolean process(int position, IntBlock superset, IntBlock subset) {
        int startIndex;
        if (superset == subset || subset.areAllValuesNull()) {
            return true;
        }
        int valueCount = subset.getValueCount(position);
        for (int valueIndex = startIndex = subset.getFirstValueIndex(position); valueIndex < startIndex + valueCount; ++valueIndex) {
            int value = subset.getInt(valueIndex);
            if (superset.hasValue(position, value)) continue;
            return false;
        }
        return true;
    }

    static boolean process(int position, BooleanBlock superset, BooleanBlock subset) {
        int startIndex;
        if (superset == subset || subset.areAllValuesNull()) {
            return true;
        }
        int valueCount = subset.getValueCount(position);
        for (int valueIndex = startIndex = subset.getFirstValueIndex(position); valueIndex < startIndex + valueCount; ++valueIndex) {
            boolean value = subset.getBoolean(valueIndex);
            if (superset.hasValue(position, value)) continue;
            return false;
        }
        return true;
    }

    static boolean process(int position, LongBlock superset, LongBlock subset) {
        int startIndex;
        if (superset == subset || subset.areAllValuesNull()) {
            return true;
        }
        int valueCount = subset.getValueCount(position);
        for (int valueIndex = startIndex = subset.getFirstValueIndex(position); valueIndex < startIndex + valueCount; ++valueIndex) {
            long value = subset.getLong(valueIndex);
            if (superset.hasValue(position, value)) continue;
            return false;
        }
        return true;
    }

    static boolean process(int position, DoubleBlock superset, DoubleBlock subset) {
        int startIndex;
        if (superset == subset || subset.areAllValuesNull()) {
            return true;
        }
        int valueCount = subset.getValueCount(position);
        for (int valueIndex = startIndex = subset.getFirstValueIndex(position); valueIndex < startIndex + valueCount; ++valueIndex) {
            double value = subset.getDouble(valueIndex);
            if (superset.hasValue(position, value)) continue;
            return false;
        }
        return true;
    }

    static boolean process(int position, BytesRefBlock superset, BytesRefBlock subset) {
        if (superset == subset || subset.areAllValuesNull()) {
            return true;
        }
        int valueCount = subset.getValueCount(position);
        int startIndex = subset.getFirstValueIndex(position);
        BytesRef value = new BytesRef();
        BytesRef scratch = new BytesRef();
        for (int valueIndex = startIndex; valueIndex < startIndex + valueCount; ++valueIndex) {
            if (superset.hasValue(position, value = subset.getBytesRef(valueIndex, value), scratch)) continue;
            return false;
        }
        return true;
    }
}

