/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppendBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppendBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppendDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppendIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAppendLongEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvAppend
extends EsqlScalarFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvAppend", MvAppend::new);
    private final Expression field1;
    private final Expression field2;
    private DataType dataType;

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "unsigned_long", "version"}, description="Concatenates values of two multi-value fields.", examples={@Example(file="date", tag="mv_append_date")})
    public MvAppend(Source source, @Param(name="field1", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}) Expression field1, @Param(name="field2", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}) Expression field2) {
        super(source, Arrays.asList(field1, field2));
        this.field1 = field1;
        this.field2 = field2;
    }

    private MvAppend(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field1);
        out.writeNamedWriteable((NamedWriteable)this.field2);
    }

    public String getWriteableName() {
        return MvAppend.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.field1, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        this.dataType = this.field1.dataType().noText();
        if (this.dataType == DataType.NULL) {
            this.dataType = this.field2.dataType().noText();
            return TypeResolutions.isRepresentableExceptCountersDenseVectorAggregateMetricDoubleAndExponentialHistogram((Expression)this.field2, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        }
        return TypeResolutions.isType((Expression)this.field2, t -> t.noText() == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{this.dataType.typeName()});
    }

    public boolean foldable() {
        return this.field1.foldable() && this.field2.foldable();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return switch (PlannerUtils.toElementType(this.dataType())) {
            case ElementType.BOOLEAN -> new MvAppendBooleanEvaluator.Factory(this.source(), toEvaluator.apply(this.field1), toEvaluator.apply(this.field2));
            case ElementType.BYTES_REF -> new MvAppendBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.field1), toEvaluator.apply(this.field2));
            case ElementType.DOUBLE -> new MvAppendDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.field1), toEvaluator.apply(this.field2));
            case ElementType.INT -> new MvAppendIntEvaluator.Factory(this.source(), toEvaluator.apply(this.field1), toEvaluator.apply(this.field2));
            case ElementType.LONG -> new MvAppendLongEvaluator.Factory(this.source(), toEvaluator.apply(this.field1), toEvaluator.apply(this.field2));
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.dataType);
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvAppend(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvAppend::new, (Object)this.field1, (Object)this.field2);
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    public int hashCode() {
        return Objects.hash(this.field1, this.field2);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MvAppend other = (MvAppend)obj;
        return Objects.equals(other.field1, this.field1) && Objects.equals(other.field2, this.field2);
    }

    static void process(IntBlock.Builder builder, int position, IntBlock field1, IntBlock field2) {
        int count1 = field1.getValueCount(position);
        int count2 = field2.getValueCount(position);
        if (count1 == 0 || count2 == 0) {
            builder.appendNull();
        } else {
            int i;
            builder.beginPositionEntry();
            int first1 = field1.getFirstValueIndex(position);
            int first2 = field2.getFirstValueIndex(position);
            for (i = 0; i < count1; ++i) {
                builder.appendInt(field1.getInt(first1 + i));
            }
            for (i = 0; i < count2; ++i) {
                builder.appendInt(field2.getInt(first2 + i));
            }
            builder.endPositionEntry();
        }
    }

    static void process(BooleanBlock.Builder builder, int position, BooleanBlock field1, BooleanBlock field2) {
        int count1 = field1.getValueCount(position);
        int count2 = field2.getValueCount(position);
        if (count1 == 0 || count2 == 0) {
            builder.appendNull();
        } else {
            int i;
            int first1 = field1.getFirstValueIndex(position);
            int first2 = field2.getFirstValueIndex(position);
            builder.beginPositionEntry();
            for (i = 0; i < count1; ++i) {
                builder.appendBoolean(field1.getBoolean(first1 + i));
            }
            for (i = 0; i < count2; ++i) {
                builder.appendBoolean(field2.getBoolean(first2 + i));
            }
            builder.endPositionEntry();
        }
    }

    static void process(LongBlock.Builder builder, int position, LongBlock field1, LongBlock field2) {
        int count1 = field1.getValueCount(position);
        int count2 = field2.getValueCount(position);
        if (count1 == 0 || count2 == 0) {
            builder.appendNull();
        } else {
            int i;
            int first1 = field1.getFirstValueIndex(position);
            int first2 = field2.getFirstValueIndex(position);
            builder.beginPositionEntry();
            for (i = 0; i < count1; ++i) {
                builder.appendLong(field1.getLong(first1 + i));
            }
            for (i = 0; i < count2; ++i) {
                builder.appendLong(field2.getLong(first2 + i));
            }
            builder.endPositionEntry();
        }
    }

    static void process(DoubleBlock.Builder builder, int position, DoubleBlock field1, DoubleBlock field2) {
        int count1 = field1.getValueCount(position);
        int count2 = field2.getValueCount(position);
        if (count1 == 0 || count2 == 0) {
            builder.appendNull();
        } else {
            int i;
            int first1 = field1.getFirstValueIndex(position);
            int first2 = field2.getFirstValueIndex(position);
            builder.beginPositionEntry();
            for (i = 0; i < count1; ++i) {
                builder.appendDouble(field1.getDouble(first1 + i));
            }
            for (i = 0; i < count2; ++i) {
                builder.appendDouble(field2.getDouble(first2 + i));
            }
            builder.endPositionEntry();
        }
    }

    static void process(BytesRefBlock.Builder builder, int position, BytesRefBlock field1, BytesRefBlock field2) {
        int count1 = field1.getValueCount(position);
        int count2 = field2.getValueCount(position);
        if (count1 == 0 || count2 == 0) {
            builder.appendNull();
        } else {
            int i;
            int first1 = field1.getFirstValueIndex(position);
            int first2 = field2.getFirstValueIndex(position);
            builder.beginPositionEntry();
            BytesRef spare = new BytesRef();
            for (i = 0; i < count1; ++i) {
                builder.appendBytesRef(field1.getBytesRef(first1 + i, spare));
            }
            for (i = 0; i < count2; ++i) {
                builder.appendBytesRef(field2.getBytesRef(first2 + i, spare));
            }
            builder.endPositionEntry();
        }
    }

    public Nullability nullable() {
        return Nullability.TRUE;
    }
}

