/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.querydsl.query.TermQuery;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class Term
extends FullTextFunction
implements PostAnalysisPlanVerificationAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Term", Term::readFrom);
    private final Expression field;

    @FunctionInfo(returnType={"boolean"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Performs a Term query on the specified field. Returns true if the provided term matches the row.", examples={@Example(file="term-function", tag="term-with-field")})
    public Term(Source source, @Param(name="field", type={"keyword", "text"}, description="Field that the query will target.") Expression field, @Param(name="query", type={"keyword", "text"}, description="Term you wish to find in the provided field.") Expression termQuery) {
        this(source, field, termQuery, null);
    }

    public Term(Source source, Expression field, Expression termQuery, QueryBuilder queryBuilder) {
        super(source, termQuery, List.of(field, termQuery), queryBuilder);
        this.field = field;
    }

    private static Term readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        Expression field = (Expression)in.readNamedWriteable(Expression.class);
        Expression query = (Expression)in.readNamedWriteable(Expression.class);
        QueryBuilder queryBuilder = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        return new Term(source, field, query, queryBuilder);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field());
        out.writeNamedWriteable((NamedWriteable)this.query());
        out.writeOptionalNamedWriteable((NamedWriteable)this.queryBuilder());
    }

    public String getWriteableName() {
        return Term.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveField().and(this.resolveQuery(TypeResolutions.ParamOrdinal.SECOND));
    }

    private Expression.TypeResolution resolveField() {
        return TypeResolutions.isNotNull((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST));
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (plan, failures) -> {
            super.postAnalysisPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            this.fieldVerifier((LogicalPlan)((Object)plan), this, this.field, (Failures)failures);
        };
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postOptimizationPlanVerification() {
        return (plan, failures) -> {
            super.postOptimizationPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            this.fieldVerifier((LogicalPlan)((Object)plan), this, this.field, (Failures)failures);
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Term(this.source(), newChildren.get(0), newChildren.get(1), this.queryBuilder());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Term::new, (Object)this.field, (Object)this.query(), (Object)this.queryBuilder());
    }

    protected TypeResolutions.ParamOrdinal queryParamOrdinal() {
        return TypeResolutions.ParamOrdinal.SECOND;
    }

    @Override
    protected Query translate(LucenePushdownPredicates pushdownPredicates, TranslatorHandler handler) {
        return new TermQuery(this.source(), ((FieldAttribute)this.field()).name(), Foldables.queryAsObject(this.query(), this.sourceText()), false, true);
    }

    @Override
    public Expression replaceQueryBuilder(QueryBuilder queryBuilder) {
        return new Term(this.source(), this.field, this.query(), queryBuilder);
    }

    public Expression field() {
        return this.field;
    }

    public String functionName() {
        return Term.ENTRY.name;
    }
}

