/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class CountOverTime
extends TimeSeriesAggregateFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "CountOverTime", CountOverTime::new);

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"long"}, description="Calculates the count over time value of a field.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="count_over_time")})
    public CountOverTime(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}) Expression field, @Param(name="window", type={"time_duration"}, description="the time window over which to compute the count over time", optional=true) Expression window) {
        this(source, field, (Expression)Literal.TRUE, (Expression)Objects.requireNonNullElse(window, NO_WINDOW));
    }

    public CountOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private CountOverTime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return CountOverTime.ENTRY.name;
    }

    @Override
    public CountOverTime withFilter(Expression filter) {
        return new CountOverTime(this.source(), this.field(), filter, this.window());
    }

    protected NodeInfo<CountOverTime> info() {
        return NodeInfo.create((Node)this, CountOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public CountOverTime replaceChildren(List<Expression> newChildren) {
        return new CountOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public Count perTimeSeriesAggregation() {
        return new Count(this.source(), this.field(), this.filter(), this.window());
    }
}

