/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Present;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Not;

public class Absent
extends AggregateFunction
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Absent", Absent::new);

    @FunctionInfo(returnType={"boolean"}, description="Returns true if the input expression yields no non-null values within the current aggregation context. Otherwise it returns false.", type=FunctionType.AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.2.0")}, examples={@Example(file="absent", tag="absent"), @Example(description="To check for the absence inside a group use `ABSENT()` and `BY` clauses", file="absent", tag="absent-by"), @Example(description="To check for the absence and return 1 when it's true and 0 when it's false you can use to_integer()", file="absent", tag="absent-as-integer")})
    public Absent(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version", "exponential_histogram"}, description="Expression that outputs values to be checked for absence.") Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW);
    }

    public Absent(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private Absent(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Absent.ENTRY.name;
    }

    protected NodeInfo<Absent> info() {
        return NodeInfo.create((Node)this, Absent::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    @Override
    public AggregateFunction withFilter(Expression filter) {
        return new Absent(this.source(), this.field(), filter, this.window());
    }

    public Absent replaceChildren(List<Expression> newChildren) {
        return new Absent(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> !dt.isCounter() && dt != DataType.DENSE_VECTOR, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"any type except counter types or dense_vector"});
    }

    @Override
    public Expression surrogate() {
        return new Not(this.source(), (Expression)new Present(this.source(), this.field(), this.filter(), this.window()));
    }
}

