/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;

public class CancellableRunnable<T>
extends AbstractRunnable {
    private final Runnable in;
    private final ActionListener<T> listener;
    private final Function<Exception, T> defaultValue;
    private final Logger logger;
    private final AtomicReference<RunnableState> state = new AtomicReference<RunnableState>(RunnableState.AWAITING_EXECUTION);

    public CancellableRunnable(ActionListener<T> listener, Function<Exception, T> defaultValue, Runnable in, Logger logger) {
        this.listener = listener;
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.in = in;
        this.logger = logger;
    }

    public void onFailure(Exception e) {
        this.logger.error("execution of cancellable runnable failed", (Throwable)e);
        T result = this.defaultValue.apply(e);
        this.listener.onResponse(result);
    }

    protected void doRun() throws Exception {
        if (this.state.compareAndSet(RunnableState.AWAITING_EXECUTION, RunnableState.EXECUTING)) {
            this.in.run();
        } else {
            this.logger.trace("skipping execution of cancellable runnable as the current state is [{}]", (Object)this.state.get());
        }
    }

    public void onRejection(Exception e) {
        this.listener.onFailure(e);
    }

    public void maybeTimeout() {
        if (this.state.compareAndSet(RunnableState.AWAITING_EXECUTION, RunnableState.TIMED_OUT)) {
            this.logger.warn("skipping execution of cancellable runnable as it has been waiting for execution too long");
            this.listener.onFailure((Exception)new ElasticsearchTimeoutException("timed out waiting for execution of cancellable runnable", new Object[0]));
        }
    }

    private static enum RunnableState {
        AWAITING_EXECUTION,
        EXECUTING,
        TIMED_OUT;

    }
}

