/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextSimilarityConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class TextSimilarityConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "text_similarity";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = new ObjectParser("text_similarity", Builder::new);
    private final String text;
    private final String resultsField;
    private final TextSimilarityConfig.SpanScoreFunction spanScoreFunction;

    public static TextSimilarityConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static TextSimilarityConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        String text = (String)options.remove(TextSimilarityConfig.TEXT.getPreferredName());
        String spanScoreFunction = (String)options.remove(TextSimilarityConfig.SPAN_SCORE_COMBINATION_FUNCTION.getPreferredName());
        TokenizationUpdate tokenizationUpdate = NlpConfigUpdate.tokenizationFromMap(options);
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", map.keySet());
        }
        return new TextSimilarityConfigUpdate(text, resultsField, tokenizationUpdate, spanScoreFunction);
    }

    public TextSimilarityConfigUpdate(String text) {
        super((TokenizationUpdate)null);
        this.text = ExceptionsHelper.requireNonNull(text, TextSimilarityConfig.TEXT);
        this.resultsField = null;
        this.spanScoreFunction = null;
    }

    public TextSimilarityConfigUpdate(String text, @Nullable String resultsField, @Nullable TokenizationUpdate tokenizationUpdate, @Nullable String spanScoreFunction) {
        super(tokenizationUpdate);
        this.text = ExceptionsHelper.requireNonNull(text, TextSimilarityConfig.TEXT);
        this.resultsField = resultsField;
        this.spanScoreFunction = Optional.ofNullable(spanScoreFunction).map(TextSimilarityConfig.SpanScoreFunction::fromString).orElse(null);
    }

    public TextSimilarityConfigUpdate(StreamInput in) throws IOException {
        super(in);
        this.text = in.readString();
        this.resultsField = in.readOptionalString();
        this.spanScoreFunction = (TextSimilarityConfig.SpanScoreFunction)in.readOptionalEnum(TextSimilarityConfig.SpanScoreFunction.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.text);
        out.writeOptionalString(this.resultsField);
        out.writeOptionalEnum((Enum)this.spanScoreFunction);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.spanScoreFunction != null) {
            builder.field(TextSimilarityConfig.SPAN_SCORE_COMBINATION_FUNCTION.getPreferredName(), (Enum)this.spanScoreFunction);
        }
        builder.field(TextSimilarityConfig.TEXT.getPreferredName(), this.text);
        return builder;
    }

    public TextSimilarityConfig.SpanScoreFunction getSpanScoreFunction() {
        return this.spanScoreFunction;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof TextSimilarityConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setText(this.text).setResultsField(this.resultsField).setTokenizationUpdate(this.tokenizationUpdate);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextSimilarityConfigUpdate that = (TextSimilarityConfigUpdate)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.tokenizationUpdate, that.tokenizationUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField, this.tokenizationUpdate, this.text);
    }

    public String getText() {
        return this.text;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    static {
        STRICT_PARSER.declareString(Builder::setText, TextSimilarityConfig.TEXT);
        STRICT_PARSER.declareString(Builder::setResultsField, NlpConfig.RESULTS_FIELD);
        STRICT_PARSER.declareString(Builder::setSpanScoreFunction, TextSimilarityConfig.SPAN_SCORE_COMBINATION_FUNCTION);
        STRICT_PARSER.declareNamedObject(Builder::setTokenizationUpdate, (p, c, n) -> (TokenizationUpdate)p.namedObject(TokenizationUpdate.class, n, (Object)false), NlpConfig.TOKENIZATION);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, TextSimilarityConfigUpdate> {
        private String resultsField;
        private String spanScoreFunction;
        private TokenizationUpdate tokenizationUpdate;
        private String text;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setTokenizationUpdate(TokenizationUpdate tokenizationUpdate) {
            this.tokenizationUpdate = tokenizationUpdate;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setSpanScoreFunction(String spanScoreFunction) {
            this.spanScoreFunction = spanScoreFunction;
            return this;
        }

        @Override
        public TextSimilarityConfigUpdate build() {
            return new TextSimilarityConfigUpdate(this.text, this.resultsField, this.tokenizationUpdate, this.spanScoreFunction);
        }
    }
}

