/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RankedDocsResults
implements InferenceServiceResults {
    public static final String NAME = "rerank_service_results";
    public static final String RERANK = "rerank";
    List<RankedDoc> rankedDocs;
    public static final ParseField RERANK_FIELD = new ParseField("rerank", new String[0]);

    public RankedDocsResults(List<RankedDoc> rankedDocs) {
        this.rankedDocs = rankedDocs;
    }

    public RankedDocsResults(StreamInput in) throws IOException {
        this.rankedDocs = in.readCollectionAsList(RankedDoc::of);
    }

    public static ConstructingObjectParser<RankedDocsResults, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("ranked_doc_results", ignoreUnknownFields, a -> new RankedDocsResults((List)a[0]));
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> (RankedDoc)RankedDoc.createParser(true).apply(p, c), RERANK_FIELD);
        return parser;
    }

    public RankedDocsResults() {
        this.rankedDocs = new ArrayList<RankedDoc>(0);
    }

    public List<RankedDoc> getRankedDocs() {
        return this.rankedDocs;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array((String)RERANK, this.rankedDocs.iterator());
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.rankedDocs);
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Coordination format not supported by rerank_service_results");
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(RERANK, this.rankedDocs.stream().map(RankedDoc::asMap).collect(Collectors.toList()));
        return map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RankedDocsResults@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("\n");
        for (RankedDoc rankedDoc : this.rankedDocs) {
            sb.append(rankedDoc.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankedDocsResults that = (RankedDocsResults)o;
        return Objects.equals(this.rankedDocs, that.rankedDocs);
    }

    public int hashCode() {
        return Objects.hash(this.rankedDocs);
    }

    public record RankedDoc(int index, float relevanceScore, @Nullable String text) implements Comparable<RankedDoc>,
    Writeable,
    ToXContentObject
    {
        public static final String NAME = "ranked_doc";
        public static final String INDEX = "index";
        public static final String RELEVANCE_SCORE = "relevance_score";
        public static final String TEXT = "text";
        public static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
        public static final ParseField RELEVANCE_SCORE_FIELD = new ParseField("relevance_score", new String[0]);
        public static final ParseField TEXT_FIELD = new ParseField("text", new String[0]);

        public static ConstructingObjectParser<RankedDoc, Void> createParser(boolean ignoreUnknownFields) {
            ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new RankedDoc((Integer)a[0], ((Float)a[1]).floatValue(), (String)a[2]));
            parser.declareInt(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
            parser.declareFloat(ConstructingObjectParser.constructorArg(), RELEVANCE_SCORE_FIELD);
            parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TEXT_FIELD);
            return parser;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX, this.index);
            builder.field(RELEVANCE_SCORE, this.relevanceScore);
            if (this.text != null) {
                builder.field(TEXT, this.text);
            }
            builder.endObject();
            return builder;
        }

        public static RankedDoc of(StreamInput in) throws IOException {
            return new RankedDoc(in.readInt(), in.readFloat(), in.readOptionalString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.index);
            out.writeFloat(this.relevanceScore);
            out.writeOptionalString(this.text);
        }

        public Map<String, Object> asMap() {
            if (this.text != null) {
                return Map.of(NAME, Map.of(INDEX, this.index, RELEVANCE_SCORE, Float.valueOf(this.relevanceScore), TEXT, this.text));
            }
            return Map.of(NAME, Map.of(INDEX, this.index, RELEVANCE_SCORE, Float.valueOf(this.relevanceScore)));
        }

        @Override
        public int compareTo(RankedDoc other) {
            return Float.compare(other.relevanceScore, this.relevanceScore);
        }

        @Override
        public String toString() {
            return "RankedDoc{index='" + this.index + "', relevanceScore='" + this.relevanceScore + "', text='" + this.text + "', hashcode=" + this.hashCode() + "}";
        }
    }
}

