/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.Model;
import org.elasticsearch.xpack.core.inference.results.ModelStoreResponse;

public class StoreInferenceEndpointsAction
extends ActionType<Response> {
    public static final StoreInferenceEndpointsAction INSTANCE = new StoreInferenceEndpointsAction();
    public static final String NAME = "cluster:internal/xpack/inference/create_endpoints";

    public StoreInferenceEndpointsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final List<ModelStoreResponse> results;

        public Response(List<ModelStoreResponse> results) {
            this.results = results;
        }

        public Response(StreamInput in) throws IOException {
            this.results = in.readCollectionAsImmutableList(ModelStoreResponse::new);
        }

        public List<ModelStoreResponse> getResults() {
            return this.results;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.results);
        }

        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.results, response.results);
        }

        public int hashCode() {
            return Objects.hash(this.results);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final List<Model> models;

        public Request(List<Model> models, TimeValue timeout) {
            super(timeout, DEFAULT_ACK_TIMEOUT);
            this.models = Objects.requireNonNull(models);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.models = in.readCollectionAsImmutableList(Model::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.models);
        }

        public List<Model> getModels() {
            return this.models;
        }

        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.models, request.models);
        }

        public int hashCode() {
            return Objects.hashCode(this.models);
        }
    }
}

