/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.EmbeddingRequest;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.InferenceContext;
import org.elasticsearch.xpack.core.inference.action.BaseInferenceActionRequest;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;

public class EmbeddingAction
extends ActionType<InferenceAction.Response> {
    public static final EmbeddingAction INSTANCE = new EmbeddingAction();
    public static final String NAME = "cluster:internal/xpack/inference/embedding";

    public EmbeddingAction() {
        super(NAME);
    }

    public static class Request
    extends BaseInferenceActionRequest {
        private final String inferenceEntityId;
        private final TaskType taskType;
        private final EmbeddingRequest embeddingRequest;
        private final TimeValue timeout;

        public static Request parseRequest(String inferenceEntityId, TaskType taskType, TimeValue timeout, InferenceContext context, XContentParser parser) throws IOException {
            EmbeddingRequest embeddingRequest = (EmbeddingRequest)EmbeddingRequest.PARSER.apply(parser, null);
            return new Request(inferenceEntityId, taskType, embeddingRequest, context, timeout);
        }

        public Request(String inferenceEntityId, TaskType taskType, EmbeddingRequest embeddingRequest, TimeValue timeout) {
            this(inferenceEntityId, taskType, embeddingRequest, InferenceContext.EMPTY_INSTANCE, timeout);
        }

        public Request(String inferenceEntityId, TaskType taskType, EmbeddingRequest embeddingRequest, InferenceContext context, TimeValue timeout) {
            super(context);
            this.inferenceEntityId = Objects.requireNonNull(inferenceEntityId);
            this.taskType = Objects.requireNonNull(taskType);
            this.embeddingRequest = Objects.requireNonNull(embeddingRequest);
            this.timeout = Objects.requireNonNull(timeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
            this.taskType = TaskType.fromStream((StreamInput)in);
            this.embeddingRequest = new EmbeddingRequest(in);
            this.timeout = in.readTimeValue();
        }

        @Override
        public TaskType getTaskType() {
            return this.taskType;
        }

        @Override
        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public EmbeddingRequest getEmbeddingRequest() {
            return this.embeddingRequest;
        }

        @Override
        public boolean isStreaming() {
            return false;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.embeddingRequest.inputs() == null) {
                e = ValidateActions.addValidationError((String)"Field [inputs] cannot be null", e);
            } else if (this.embeddingRequest.inputs().isEmpty()) {
                e = ValidateActions.addValidationError((String)"Field [inputs] cannot be an empty array", (ActionRequestValidationException)e);
            }
            if (!this.taskType.isAnyOrSame(TaskType.EMBEDDING)) {
                e = ValidateActions.addValidationError((String)"Field [taskType] must be [embedding]", (ActionRequestValidationException)e);
            }
            return e;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
            this.taskType.writeTo(out);
            this.embeddingRequest.writeTo(out);
            out.writeTimeValue(this.timeout);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return super.equals(o) && Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && this.taskType == request.taskType && Objects.equals(this.embeddingRequest, request.embeddingRequest) && Objects.equals(this.timeout, request.timeout);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.inferenceEntityId, this.taskType, this.embeddingRequest, this.timeout);
        }

        public String toString() {
            return "Request{inferenceEntityId='" + this.inferenceEntityId + "', taskType=" + String.valueOf(this.taskType) + ", embeddingRequest=" + String.valueOf(this.embeddingRequest) + ", timeout=" + String.valueOf(this.timeout) + "}";
        }
    }
}

