/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.test.ClasspathUtils;
import org.elasticsearch.test.rest.ESRestTestCase;
import org.elasticsearch.test.rest.TestFeatureService;
import org.elasticsearch.test.rest.yaml.BlacklistedPathPatternMatcher;
import org.elasticsearch.test.rest.yaml.ClientYamlTestCandidate;
import org.elasticsearch.test.rest.yaml.ClientYamlTestClient;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.ClientYamlTestResponse;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestApi;
import org.elasticsearch.test.rest.yaml.restspec.ClientYamlSuiteRestSpec;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSection;
import org.elasticsearch.test.rest.yaml.section.ClientYamlTestSuite;
import org.elasticsearch.test.rest.yaml.section.ExecutableSection;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.rules.ErrorCollector;

@TimeoutSuite(millis=1800000)
public abstract class ESClientYamlSuiteTestCase
extends ESRestTestCase {
    public static final String REST_TESTS_SUITE = "tests.rest.suite";
    public static final String REST_TESTS_BLACKLIST = "tests.rest.blacklist";
    public static final String REST_TESTS_BLACKLIST_ADDITIONS = "tests.rest.blacklist_additions";
    private static final String REST_TESTS_VALIDATE_SPEC = "tests.rest.validate_spec";
    private static final String TESTS_PATH = "rest-api-spec/test";
    private static final String SPEC_PATH = "rest-api-spec/api";
    private static final String PATHS_SEPARATOR = "(?<!\\\\),";
    private static List<BlacklistedPathPatternMatcher> blacklistPathMatchers;
    private static ClientYamlTestExecutionContext restTestExecutionContext;
    private static ClientYamlTestExecutionContext adminExecutionContext;
    private static ClientYamlTestClient clientYamlTestClient;
    private final ClientYamlTestCandidate testCandidate;
    private static ClientYamlSuiteRestSpec restSpecification;
    private ESClientYamlSuiteErrorCollector errorCollector;

    protected ESClientYamlSuiteTestCase(ClientYamlTestCandidate testCandidate) {
        this.testCandidate = testCandidate;
    }

    @Before
    public void initAndResetContext() throws Exception {
        if (restTestExecutionContext == null) {
            String[] blacklistAdditions;
            assert (adminExecutionContext == null);
            assert (blacklistPathMatchers == null);
            ClientYamlSuiteRestSpec restSpec = ClientYamlSuiteRestSpec.load(SPEC_PATH);
            ESClientYamlSuiteTestCase.validateSpec(restSpec);
            restSpecification = restSpec;
            List hosts = this.getClusterHosts();
            Set nodesVersions = ESClientYamlSuiteTestCase.getCachedNodesVersions();
            String os = ESClientYamlSuiteTestCase.readOsFromNodesInfo(ESClientYamlSuiteTestCase.adminClient());
            this.logger.info("initializing client, node versions [{}], hosts {}, os [{}]", (Object)nodesVersions, (Object)hosts, (Object)os);
            TestFeatureService testFeatureService = this.createTestFeatureService(ESClientYamlSuiteTestCase.getClusterStateFeatures((RestClient)ESClientYamlSuiteTestCase.adminClient()), ESClientYamlSuiteTestCase.fromSemanticVersions((Set)nodesVersions));
            this.logger.info("initializing client, node versions [{}], hosts {}, os [{}]", (Object)nodesVersions, (Object)hosts, (Object)os);
            clientYamlTestClient = this.initClientYamlTestClient(restSpec, ESClientYamlSuiteTestCase.client(), hosts);
            restTestExecutionContext = this.createRestTestExecutionContext(this.testCandidate, clientYamlTestClient, nodesVersions, testFeatureService, Set.of(os));
            adminExecutionContext = new ClientYamlTestExecutionContext(this.testCandidate, clientYamlTestClient, false, nodesVersions, testFeatureService, Set.of(os));
            String[] blacklist = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST, null);
            blacklistPathMatchers = new ArrayList<BlacklistedPathPatternMatcher>();
            for (String entry : blacklist) {
                blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
            }
            for (String entry : blacklistAdditions = ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_BLACKLIST_ADDITIONS, null)) {
                blacklistPathMatchers.add(new BlacklistedPathPatternMatcher(entry));
            }
        }
        assert (restTestExecutionContext != null);
        assert (adminExecutionContext != null);
        assert (blacklistPathMatchers != null);
        adminExecutionContext.clear();
        restTestExecutionContext.clear();
        this.errorCollector = new ESClientYamlSuiteErrorCollector();
    }

    protected ClientYamlTestExecutionContext createRestTestExecutionContext(ClientYamlTestCandidate clientYamlTestCandidate, ClientYamlTestClient clientYamlTestClient, Set<String> nodesVersions, TestFeatureService testFeatureService, Set<String> osSet) {
        return new ClientYamlTestExecutionContext(clientYamlTestCandidate, clientYamlTestClient, this.randomizeContentType(), nodesVersions, testFeatureService, osSet);
    }

    protected ClientYamlTestClient initClientYamlTestClient(ClientYamlSuiteRestSpec restSpec, RestClient restClient, List<HttpHost> hosts) {
        return new ClientYamlTestClient(restSpec, restClient, hosts, (CheckedSupplier<RestClientBuilder, IOException>)((CheckedSupplier)this::getClientBuilderWithSniffedHosts));
    }

    @AfterClass
    public static void closeClient() throws IOException {
        try {
            IOUtils.close((Closeable)clientYamlTestClient);
        }
        finally {
            blacklistPathMatchers = null;
            restTestExecutionContext = null;
            adminExecutionContext = null;
            clientYamlTestClient = null;
        }
    }

    public static Iterable<Object[]> createParameters() throws Exception {
        return ESClientYamlSuiteTestCase.createParameters(ExecutableSection.XCONTENT_REGISTRY);
    }

    public static Iterable<Object[]> createParameters(NamedXContentRegistry executeableSectionRegistry) throws Exception {
        return ESClientYamlSuiteTestCase.createParameters(executeableSectionRegistry, Map.of(), ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SUITE, ""));
    }

    public static Iterable<Object[]> createParameters(Map<String, Object> yamlParameters) throws Exception {
        return ESClientYamlSuiteTestCase.createParameters(ExecutableSection.XCONTENT_REGISTRY, yamlParameters, ESClientYamlSuiteTestCase.resolvePathsProperty(REST_TESTS_SUITE, ""));
    }

    public static Iterable<Object[]> createParameters(Map<String, Object> yamlParameters, String ... testPaths) throws Exception {
        if (System.getProperty(REST_TESTS_SUITE) != null) {
            throw new IllegalArgumentException("The 'tests.rest.suite' system property is not supported with explicit test paths.");
        }
        return ESClientYamlSuiteTestCase.createParameters(ExecutableSection.XCONTENT_REGISTRY, yamlParameters, testPaths);
    }

    public static Iterable<Object[]> createParameters(String ... testPaths) throws Exception {
        if (System.getProperty(REST_TESTS_SUITE) != null) {
            throw new IllegalArgumentException("The 'tests.rest.suite' system property is not supported with explicit test paths.");
        }
        return ESClientYamlSuiteTestCase.createParameters(ExecutableSection.XCONTENT_REGISTRY, Map.of(), testPaths);
    }

    public static Iterable<Object[]> createParameters(NamedXContentRegistry executeableSectionRegistry, String ... testPaths) throws Exception {
        if (System.getProperty(REST_TESTS_SUITE) != null) {
            throw new IllegalArgumentException("The 'tests.rest.suite' system property is not supported with explicit test paths.");
        }
        return ESClientYamlSuiteTestCase.createParameters(executeableSectionRegistry, Map.of(), testPaths);
    }

    public static Iterable<Object[]> createParameters(NamedXContentRegistry executeableSectionRegistry, Map<String, ?> yamlParameters, String ... testPaths) throws Exception {
        if (testPaths == null) {
            throw new IllegalArgumentException("testPaths cannot be null");
        }
        Map<String, Set<Path>> yamlSuites = ESClientYamlSuiteTestCase.loadSuites(testPaths);
        ArrayList<ClientYamlTestSuite> suites = new ArrayList<ClientYamlTestSuite>();
        Throwable validationException = null;
        for (String api : yamlSuites.keySet()) {
            ArrayList yamlFiles = new ArrayList(yamlSuites.get(api));
            for (Path yamlFile : yamlFiles) {
                ClientYamlTestSuite suite = ClientYamlTestSuite.parse(executeableSectionRegistry, api, yamlFile, yamlParameters);
                suites.add(suite);
                try {
                    suite.validate();
                }
                catch (IllegalArgumentException e) {
                    if (validationException == null) {
                        validationException = new IllegalArgumentException("Validation errors for the following test suites:\n- " + e.getMessage());
                    } else {
                        String previousMessage = validationException.getMessage();
                        Throwable[] suppressed = validationException.getSuppressed();
                        validationException = new IllegalArgumentException(previousMessage + "\n- " + e.getMessage());
                        for (Throwable t : suppressed) {
                            validationException.addSuppressed(t);
                        }
                    }
                    validationException.addSuppressed(e);
                }
            }
        }
        if (validationException != null) {
            throw validationException;
        }
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (ClientYamlTestSuite yamlTestSuite : suites) {
            for (ClientYamlTestSection testSection : yamlTestSuite.getTestSections()) {
                tests.add(new Object[]{new ClientYamlTestCandidate(yamlTestSuite, testSection)});
            }
        }
        tests.sort(Comparator.comparing(o -> ((ClientYamlTestCandidate)o[0]).getTestPath()));
        return tests;
    }

    static Map<String, Set<Path>> loadSuites(String ... paths) throws Exception {
        Path[] roots;
        HashMap<String, Set<Path>> files = new HashMap<String, Set<Path>>();
        for (Path root : roots = ClasspathUtils.findFilePaths((ClassLoader)ESClientYamlSuiteTestCase.class.getClassLoader(), (String)TESTS_PATH)) {
            for (String strPath : paths) {
                Path path = root.resolve(strPath);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try (Stream<Path> filesStream = Files.walk(path, new FileVisitOption[0]);){
                        filesStream.forEach(file -> {
                            if (file.toString().endsWith(".yml")) {
                                ESClientYamlSuiteTestCase.addSuite(root, file, files);
                            } else if (file.toString().endsWith(".yaml")) {
                                throw new IllegalArgumentException("yaml files are no longer supported: " + String.valueOf(file));
                            }
                        });
                        continue;
                    }
                }
                path = root.resolve(strPath + ".yml");
                assert (Files.exists(path, new LinkOption[0])) : "Path " + String.valueOf(path) + " does not exist in YAML test root";
                ESClientYamlSuiteTestCase.addSuite(root, path, files);
            }
        }
        return files;
    }

    private static void addSuite(Path root, Path file, Map<String, Set<Path>> files) {
        String groupName = root.relativize(file.getParent()).toString();
        Set<Path> filesSet = files.get(groupName);
        if (filesSet == null) {
            filesSet = new HashSet<Path>();
            files.put(groupName, filesSet);
        }
        filesSet.add(file);
        List<String> fileNames = filesSet.stream().map(p -> p.getFileName().toString()).toList();
        if (Collections.frequency(fileNames, file.getFileName().toString()) > 1) {
            Logger logger = LogManager.getLogger(ESClientYamlSuiteTestCase.class);
            logger.warn("Found duplicate test name [" + groupName + "/" + String.valueOf(file.getFileName()) + "] on the class path. This can result in class loader dependent execution commands and reproduction commands (will add #2 to one of the test names dependent on the classloading order)");
        }
    }

    private static String[] resolvePathsProperty(String propertyName, String defaultValue) {
        String property = System.getProperty(propertyName);
        if (!Strings.hasLength((String)property)) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = Strings.EMPTY_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            return stringArray;
        }
        return property.split(PATHS_SEPARATOR);
    }

    protected ClientYamlTestExecutionContext getAdminExecutionContext() {
        return adminExecutionContext;
    }

    static ClientYamlSuiteRestSpec getRestSpec() {
        return restSpecification;
    }

    private static void validateSpec(ClientYamlSuiteRestSpec restSpec) {
        boolean validateSpec = RandomizedTest.systemPropertyAsBoolean((String)REST_TESTS_VALIDATE_SPEC, (boolean)true);
        if (validateSpec) {
            StringBuilder errorMessage = new StringBuilder();
            for (ClientYamlSuiteRestApi restApi : restSpec.getApis()) {
                if (!restApi.isBodySupported()) continue;
                for (ClientYamlSuiteRestApi.Path path : restApi.getPaths()) {
                    List<String> methodsList = Arrays.asList(path.methods());
                    if (!methodsList.contains("GET") || !restApi.isBodySupported() || methodsList.contains("POST")) continue;
                    errorMessage.append("\n- ").append(restApi.getName()).append(" supports GET with a body but doesn't support POST");
                }
            }
            if (errorMessage.length() > 0) {
                throw new IllegalArgumentException(errorMessage.toString());
            }
        }
    }

    static String readOsFromNodesInfo(RestClient restClient) throws IOException {
        Request request = new Request("GET", "/_nodes/os");
        Response response = restClient.performRequest(request);
        ClientYamlTestResponse restTestResponse = new ClientYamlTestResponse(response);
        TreeSet<String> osPrettyNames = new TreeSet<String>();
        Map nodes = (Map)restTestResponse.evaluate("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            osPrettyNames.add((String)XContentMapValues.extractValue((String)"os.pretty_name", (Map)nodeInfo));
        }
        assert (!osPrettyNames.isEmpty()) : "no os found";
        return (String)osPrettyNames.last();
    }

    public void test() throws IOException {
        for (BlacklistedPathPatternMatcher blacklistedPathMatcher : blacklistPathMatchers) {
            String testPath = this.testCandidate.getSuitePath() + "/" + this.testCandidate.getTestSection().getName();
            ESClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: blacklisted"), (boolean)blacklistedPathMatcher.isSuffixMatch(testPath));
        }
        this.testCandidate.getSetupSection().getPrerequisiteSection().evaluate(restTestExecutionContext, this.testCandidate.getSuitePath());
        this.testCandidate.getTeardownSection().getPrerequisiteSection().evaluate(restTestExecutionContext, this.testCandidate.getSuitePath());
        this.testCandidate.getTestSection().getPrerequisiteSection().evaluate(restTestExecutionContext, this.testCandidate.getTestPath());
        if (this.testCandidate.getTestSection().getExecutableSections().isEmpty()) {
            throw new IllegalArgumentException("No executable sections loaded for [" + this.testCandidate.getTestPath() + "]");
        }
        ESClientYamlSuiteTestCase.assumeFalse((String)("[" + this.testCandidate.getTestPath() + "] skipped, reason: in fips 140 mode"), (ESClientYamlSuiteTestCase.inFipsJvm() && this.testCandidate.getTestSection().getPrerequisiteSection().hasYamlRunnerFeature("fips_140") ? 1 : 0) != 0);
        if (!this.skipSetupSections() && !this.testCandidate.getSetupSection().isEmpty()) {
            this.logger.debug("start setup test [{}]", (Object)this.testCandidate.getTestPath());
            for (ExecutableSection executableSection : this.testCandidate.getSetupSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
            this.logger.debug("end setup test [{}]", (Object)this.testCandidate.getTestPath());
        }
        restTestExecutionContext.clear();
        restTestExecutionContext.stash().stashValue("_project_id_prefix_", (Object)this.activeProjectPrefix());
        try {
            for (ExecutableSection executableSection : this.testCandidate.getTestSection().getExecutableSections()) {
                this.executeSection(executableSection);
            }
            this.errorCollector.verify();
        }
        catch (AssertionError e) {
            try {
                Optional<Path> file = this.testCandidate.getRestTestSuite().getFile();
                if (file.isPresent()) {
                    try {
                        this.logger.info("Dump test yaml [{}] on failure:\n{}", (Object)file.get(), (Object)Files.readString(file.get()));
                    }
                    catch (IOException ex) {
                        this.logger.info("Did not dump test yaml [{}] on failure due to an exception [{}]", (Object)file.get(), (Object)ex);
                    }
                }
                this.logger.info("Stash dump on test failure [{}]", (Object)Strings.toString((ToXContent)restTestExecutionContext.stash(), (boolean)true, (boolean)true).replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t"));
                throw e;
            }
            catch (Throwable throwable) {
                this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
                for (ExecutableSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
                    this.executeSection(doSection);
                }
                this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
                throw throwable;
            }
        }
        this.logger.debug("start teardown test [{}]", (Object)this.testCandidate.getTestPath());
        for (ExecutableSection doSection : this.testCandidate.getTeardownSection().getDoSections()) {
            this.executeSection(doSection);
        }
        this.logger.debug("end teardown test [{}]", (Object)this.testCandidate.getTestPath());
    }

    private void executeSection(ExecutableSection executableSection) {
        this.errorCollector.checkSucceeds(() -> {
            try {
                executableSection.execute(restTestExecutionContext);
                return null;
            }
            catch (Throwable t) {
                if (t instanceof AssertionError) {
                    throw t;
                }
                throw new AssertionError("Error executing section at [" + this.testCandidate.getSuitePath() + ":" + executableSection.getLocation().lineNumber() + "]: " + t.getMessage(), t);
            }
        });
    }

    protected boolean skipSetupSections() {
        return false;
    }

    protected boolean randomizeContentType() {
        return true;
    }

    protected final RestClientBuilder getClientBuilderWithSniffedHosts() throws IOException {
        ElasticsearchNodesSniffer.Scheme scheme = ElasticsearchNodesSniffer.Scheme.valueOf((String)this.getProtocol().toUpperCase(Locale.ROOT));
        ElasticsearchNodesSniffer sniffer = new ElasticsearchNodesSniffer(ESClientYamlSuiteTestCase.adminClient(), ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
        RestClientBuilder builder = RestClient.builder((Node[])sniffer.sniff().toArray(new Node[0]));
        this.configureClient(builder, this.restClientSettings());
        return builder;
    }

    public ClientYamlTestCandidate getTestCandidate() {
        return this.testCandidate;
    }

    private static class ESClientYamlSuiteErrorCollector
    extends ErrorCollector {
        private ESClientYamlSuiteErrorCollector() {
        }

        public void verify() throws AssertionError {
            try {
                super.verify();
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

