/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.runtime.policy.CaseInsensitiveComparison;
import org.elasticsearch.entitlement.runtime.policy.CaseSensitiveComparison;
import org.elasticsearch.entitlement.runtime.policy.FileAccessTreeComparison;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Platform;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public final class FileAccessTree {
    private static final Logger logger = LogManager.getLogger(FileAccessTree.class);
    private static final String FILE_SEPARATOR = PathUtils.getDefaultFileSystem().getSeparator();
    static final FileAccessTreeComparison DEFAULT_COMPARISON = Platform.LINUX.isCurrent() ? new CaseSensitiveComparison(FileAccessTree.separatorChar()) : new CaseInsensitiveComparison(FileAccessTree.separatorChar());
    private final FileAccessTreeComparison comparison;
    private final String[] forbiddenPaths;
    private final String[] readPaths;
    private final String[] writePaths;

    static List<ExclusivePath> buildExclusivePathList(List<ExclusiveFileEntitlement> exclusiveFileEntitlements, PathLookup pathLookup, FileAccessTreeComparison comparison) {
        HashMap<String, ExclusivePath> exclusivePaths = new HashMap<String, ExclusivePath>();
        for (ExclusiveFileEntitlement efe : exclusiveFileEntitlements) {
            for (FilesEntitlement.FileData fd : efe.filesEntitlement().filesData()) {
                if (!fd.exclusive()) continue;
                List<Path> paths = fd.resolvePaths(pathLookup).toList();
                for (Path path : paths) {
                    String normalizedPath = FileAccessTree.normalizePath(path);
                    ExclusivePath exclusivePath = exclusivePaths.computeIfAbsent(normalizedPath, k -> new ExclusivePath(efe.componentName(), new HashSet<String>(), normalizedPath));
                    if (!exclusivePath.componentName().equals(efe.componentName())) {
                        throw new IllegalArgumentException("Path [" + normalizedPath + "] is already exclusive to [" + exclusivePath.componentName() + "]" + String.valueOf(exclusivePath.moduleNames) + ", cannot add exclusive access for [" + efe.componentName() + "][" + efe.moduleName + "]");
                    }
                    exclusivePath.moduleNames.add(efe.moduleName());
                }
            }
        }
        return exclusivePaths.values().stream().sorted(Comparator.comparing(ExclusivePath::path, comparison.pathComparator())).distinct().toList();
    }

    static void validateExclusivePaths(List<ExclusivePath> exclusivePaths, FileAccessTreeComparison comparison) {
        if (!exclusivePaths.isEmpty()) {
            ExclusivePath currentExclusivePath = exclusivePaths.get(0);
            for (int i = 1; i < exclusivePaths.size(); ++i) {
                ExclusivePath nextPath = exclusivePaths.get(i);
                if (comparison.samePath(currentExclusivePath.path(), nextPath.path) || comparison.isParent(currentExclusivePath.path(), nextPath.path())) {
                    throw new IllegalArgumentException("duplicate/overlapping exclusive paths found in files entitlements: " + String.valueOf(currentExclusivePath) + " and " + String.valueOf(nextPath));
                }
                currentExclusivePath = nextPath;
            }
        }
    }

    @SuppressForbidden(reason="we need the separator as a char, not a string")
    static char separatorChar() {
        return File.separatorChar;
    }

    private static String[] buildFinalSortedForbiddenPaths(String componentName, String moduleName, List<ExclusivePath> exclusivePaths, Collection<String> forbiddenPaths, FileAccessTreeComparison comparison) {
        ArrayList<String> finalForbiddenPathList = new ArrayList<String>(forbiddenPaths);
        for (ExclusivePath exclusivePath : exclusivePaths) {
            if (exclusivePath.componentName().equals(componentName) && exclusivePath.moduleNames().contains(moduleName)) continue;
            finalForbiddenPathList.add(exclusivePath.path());
        }
        finalForbiddenPathList.sort(comparison.pathComparator());
        return finalForbiddenPathList.toArray(new String[0]);
    }

    FileAccessTree(FilesEntitlement filesEntitlement, PathLookup pathLookup, Collection<Path> componentPaths, String[] sortedExclusivePaths, FileAccessTreeComparison comparison) {
        this.comparison = comparison;
        ArrayList<String> readPaths = new ArrayList<String>();
        ArrayList<String> writePaths = new ArrayList<String>();
        BiConsumer<Path, FilesEntitlement.Mode> addPath = (path, mode) -> {
            String normalized = FileAccessTree.normalizePath(path);
            if (mode == FilesEntitlement.Mode.READ_WRITE) {
                writePaths.add(normalized);
            }
            readPaths.add(normalized);
        };
        BiConsumer<Path, FilesEntitlement.Mode> addPathAndMaybeLink = (path, mode) -> {
            addPath.accept((Path)path, (FilesEntitlement.Mode)((Object)mode));
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    Path realPath = path.toRealPath(new LinkOption[0]);
                    if (!realPath.equals(path)) {
                        addPath.accept(realPath, (FilesEntitlement.Mode)((Object)mode));
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        for (FilesEntitlement.FileData fileData : filesEntitlement.filesData()) {
            Platform platform = fileData.platform();
            if (platform != null && !platform.isCurrent()) continue;
            FilesEntitlement.Mode mode2 = fileData.mode();
            Stream<Path> paths = fileData.resolvePaths(pathLookup);
            paths.forEach(path -> {
                if (path == null) {
                    return;
                }
                addPathAndMaybeLink.accept((Path)path, mode2);
            });
        }
        pathLookup.getBaseDirPaths(PathLookup.BaseDir.TEMP).forEach(tempPath -> addPathAndMaybeLink.accept((Path)tempPath, FilesEntitlement.Mode.READ_WRITE));
        pathLookup.getBaseDirPaths(PathLookup.BaseDir.CONFIG).forEach(configPath -> addPathAndMaybeLink.accept((Path)configPath, FilesEntitlement.Mode.READ));
        componentPaths.forEach(p -> addPathAndMaybeLink.accept((Path)p, FilesEntitlement.Mode.READ));
        Path jdk = Paths.get(System.getProperty("java.home"), new String[0]);
        addPathAndMaybeLink.accept(jdk.resolve("conf"), FilesEntitlement.Mode.READ);
        readPaths.sort(comparison.pathComparator());
        writePaths.sort(comparison.pathComparator());
        this.forbiddenPaths = sortedExclusivePaths;
        this.readPaths = FileAccessTree.pruneSortedPaths(readPaths, comparison).toArray(new String[0]);
        this.writePaths = FileAccessTree.pruneSortedPaths(writePaths, comparison).toArray(new String[0]);
        logger.debug(() -> Strings.format((String)"Created FileAccessTree with paths: forbidden [%s], read [%s], write [%s]", (Object[])new Object[]{String.join((CharSequence)",", this.forbiddenPaths), String.join((CharSequence)",", this.readPaths), String.join((CharSequence)",", this.writePaths)}));
    }

    static List<String> pruneSortedPaths(List<String> paths, FileAccessTreeComparison comparison) {
        ArrayList<String> prunedReadPaths = new ArrayList<String>();
        if (!paths.isEmpty()) {
            String currentPath = paths.get(0);
            prunedReadPaths.add(currentPath);
            for (int i = 1; i < paths.size(); ++i) {
                String nextPath = paths.get(i);
                if (comparison.samePath(currentPath, nextPath) || comparison.isParent(currentPath, nextPath)) continue;
                prunedReadPaths.add(nextPath);
                currentPath = nextPath;
            }
        }
        return prunedReadPaths;
    }

    static FileAccessTree of(String componentName, String moduleName, FilesEntitlement filesEntitlement, PathLookup pathLookup, Collection<Path> componentPaths, List<ExclusivePath> exclusivePaths, Collection<String> forbiddenPaths) {
        return new FileAccessTree(filesEntitlement, pathLookup, componentPaths, FileAccessTree.buildFinalSortedForbiddenPaths(componentName, moduleName, exclusivePaths, forbiddenPaths, DEFAULT_COMPARISON), DEFAULT_COMPARISON);
    }

    public static FileAccessTree withoutExclusivePaths(FilesEntitlement filesEntitlement, PathLookup pathLookup, Collection<String> forbiddenPaths, Collection<Path> componentPaths) {
        return new FileAccessTree(filesEntitlement, pathLookup, componentPaths, (String[])forbiddenPaths.stream().sorted(DEFAULT_COMPARISON.pathComparator()).toArray(String[]::new), DEFAULT_COMPARISON);
    }

    public boolean canRead(Path path) {
        String normalizedPath = FileAccessTree.normalizePath(path);
        boolean canRead = this.checkPath(normalizedPath, this.readPaths);
        logger.trace(() -> Strings.format((String)"checking [%s] (normalized to [%s]) for read: %b", (Object[])new Object[]{path, normalizedPath, canRead}));
        return canRead;
    }

    public boolean canWrite(Path path) {
        String normalizedPath = FileAccessTree.normalizePath(path);
        boolean canWrite = this.checkPath(normalizedPath, this.writePaths);
        logger.trace(() -> Strings.format((String)"checking [%s] (normalized to [%s]) for write: %b", (Object[])new Object[]{path, normalizedPath, canWrite}));
        return canWrite;
    }

    static String normalizePath(Path path) {
        String result = path.toAbsolutePath().normalize().toString();
        while (result.endsWith(FILE_SEPARATOR)) {
            result = result.substring(0, result.length() - FILE_SEPARATOR.length());
        }
        return result;
    }

    private boolean checkPath(String path, String[] paths) {
        if (paths.length == 0) {
            return false;
        }
        int endx = Arrays.binarySearch(this.forbiddenPaths, path, this.comparison.pathComparator());
        if (endx < -1 && this.comparison.isParent(this.forbiddenPaths[-endx - 2], path) || endx >= 0) {
            return false;
        }
        int ndx = Arrays.binarySearch(paths, path, this.comparison.pathComparator());
        if (ndx < -1) {
            return this.comparison.isParent(paths[-ndx - 2], path);
        }
        return ndx >= 0;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileAccessTree that = (FileAccessTree)o;
        return Objects.deepEquals(this.readPaths, that.readPaths) && Objects.deepEquals(this.writePaths, that.writePaths);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.readPaths), Arrays.hashCode(this.writePaths));
    }

    record ExclusiveFileEntitlement(String componentName, String moduleName, FilesEntitlement filesEntitlement) {
    }

    record ExclusivePath(String componentName, Set<String> moduleNames, String path) {
        @Override
        public String toString() {
            return "[[" + this.componentName + "] " + String.valueOf(this.moduleNames) + " [" + this.path + "]]";
        }
    }
}

