/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchExtBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rescore.RescorerBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.slice.SliceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.vectors.KnnSearchBuilder;
import org.elasticsearch.usage.SearchUsage;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public final class SearchSourceBuilder
implements Writeable,
ToXContentObject,
Rewriteable<SearchSourceBuilder> {
    public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
    public static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    public static final ParseField TIMEOUT_FIELD = new ParseField("timeout", new String[0]);
    public static final ParseField TERMINATE_AFTER_FIELD = new ParseField("terminate_after", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField SUB_SEARCHES_FIELD = new ParseField("sub_searches", new String[0]).withAllDeprecated("retriever");
    public static final ParseField RANK_FIELD = new ParseField("rank", new String[0]).withAllDeprecated("retriever");
    public static final ParseField POST_FILTER_FIELD = new ParseField("post_filter", new String[0]);
    public static final ParseField KNN_FIELD = new ParseField("knn", new String[0]);
    public static final ParseField MIN_SCORE_FIELD = new ParseField("min_score", new String[0]);
    public static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    public static final ParseField SEQ_NO_PRIMARY_TERM_FIELD = new ParseField("seq_no_primary_term", new String[0]);
    public static final ParseField EXPLAIN_FIELD = new ParseField("explain", new String[0]);
    public static final ParseField _SOURCE_FIELD = new ParseField("_source", new String[0]);
    public static final ParseField STORED_FIELDS_FIELD = new ParseField("stored_fields", new String[0]);
    public static final ParseField DOCVALUE_FIELDS_FIELD = new ParseField("docvalue_fields", new String[0]);
    public static final ParseField FETCH_FIELDS_FIELD = new ParseField("fields", new String[0]);
    public static final ParseField SCRIPT_FIELDS_FIELD = new ParseField("script_fields", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField IGNORE_FAILURE_FIELD = new ParseField("ignore_failure", new String[0]);
    public static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
    public static final ParseField TRACK_SCORES_FIELD = new ParseField("track_scores", new String[0]);
    public static final ParseField TRACK_TOTAL_HITS_FIELD = new ParseField("track_total_hits", new String[0]);
    public static final ParseField INDICES_BOOST_FIELD = new ParseField("indices_boost", new String[0]);
    public static final ParseField AGGREGATIONS_FIELD = new ParseField("aggregations", new String[0]);
    public static final ParseField AGGS_FIELD = new ParseField("aggs", new String[0]);
    public static final ParseField HIGHLIGHT_FIELD = new ParseField("highlight", new String[0]);
    public static final ParseField SUGGEST_FIELD = new ParseField("suggest", new String[0]);
    public static final ParseField RESCORE_FIELD = new ParseField("rescore", new String[0]);
    public static final ParseField STATS_FIELD = new ParseField("stats", new String[0]);
    public static final ParseField EXT_FIELD = new ParseField("ext", new String[0]);
    public static final ParseField PROFILE_FIELD = new ParseField("profile", new String[0]);
    public static final ParseField SEARCH_AFTER = new ParseField("search_after", new String[0]);
    public static final ParseField COLLAPSE = new ParseField("collapse", new String[0]);
    public static final ParseField SLICE = new ParseField("slice", new String[0]);
    public static final ParseField POINT_IN_TIME = new ParseField("pit", new String[0]);
    public static final ParseField RUNTIME_MAPPINGS_FIELD = new ParseField("runtime_mappings", new String[0]);
    public static final ParseField RETRIEVER = new ParseField("retriever", new String[0]);
    public static final ParseField PROJECT_ROUTING = new ParseField("project_routing", new String[0]);
    private static final boolean RANK_SUPPORTED = Booleans.parseBoolean((String)System.getProperty("es.search.rank_supported"), (boolean)true);
    private transient RetrieverBuilder retrieverBuilder;
    private List<SubSearchSourceBuilder> subSearchSourceBuilders = new ArrayList<SubSearchSourceBuilder>();
    private QueryBuilder postQueryBuilder;
    private List<KnnSearchBuilder> knnSearch = new ArrayList<KnnSearchBuilder>();
    private RankBuilder rankBuilder = null;
    private int from = -1;
    private int size = -1;
    private Boolean explain;
    private Boolean version;
    private Boolean seqNoAndPrimaryTerm;
    private List<SortBuilder<?>> sorts;
    private boolean trackScores = false;
    private Integer trackTotalHitsUpTo;
    private SearchAfterBuilder searchAfterBuilder;
    private SliceBuilder sliceBuilder;
    private Float minScore;
    private TimeValue timeout = null;
    private int terminateAfter = 0;
    private StoredFieldsContext storedFieldsContext;
    private List<FieldAndFormat> docValueFields;
    private List<ScriptField> scriptFields;
    private FetchSourceContext fetchSourceContext;
    private List<FieldAndFormat> fetchFields;
    private AggregatorFactories.Builder aggregations;
    private HighlightBuilder highlightBuilder;
    private SuggestBuilder suggestBuilder;
    private List<RescorerBuilder> rescoreBuilders;
    private List<IndexBoost> indexBoosts = new ArrayList<IndexBoost>();
    private List<String> stats;
    private List<SearchExtBuilder> extBuilders = Collections.emptyList();
    private boolean profile = false;
    private CollapseBuilder collapse = null;
    private PointInTimeBuilder pointInTimeBuilder = null;
    private Map<String, Object> runtimeMappings = Collections.emptyMap();
    private boolean skipInnerHits = false;

    public static SearchSourceBuilder searchSource() {
        return new SearchSourceBuilder();
    }

    public static HighlightBuilder highlight() {
        return new HighlightBuilder();
    }

    public SearchSourceBuilder() {
    }

    public SearchSourceBuilder(StreamInput in) throws IOException {
        this.aggregations = in.readOptionalWriteable(AggregatorFactories.Builder::new);
        this.explain = in.readOptionalBoolean();
        this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::readFrom);
        this.docValueFields = in.readBoolean() ? in.readCollectionAsList(FieldAndFormat::new) : null;
        this.storedFieldsContext = in.readOptionalWriteable(StoredFieldsContext::new);
        this.from = in.readVInt();
        this.highlightBuilder = in.readOptionalWriteable(HighlightBuilder::new);
        this.indexBoosts = in.readCollectionAsList(IndexBoost::new);
        this.minScore = in.readOptionalFloat();
        this.postQueryBuilder = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.subSearchSourceBuilders = in.readCollectionAsList(SubSearchSourceBuilder::new);
        if (in.readBoolean()) {
            this.rescoreBuilders = in.readNamedWriteableCollectionAsList(RescorerBuilder.class);
        }
        if (in.readBoolean()) {
            this.scriptFields = in.readCollectionAsList(ScriptField::new);
        }
        this.size = in.readVInt();
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.sorts = new ArrayList();
            for (int i = 0; i < size; ++i) {
                this.sorts.add(in.readNamedWriteable(SortBuilder.class));
            }
        }
        if (in.readBoolean()) {
            this.stats = in.readStringCollectionAsList();
        }
        this.suggestBuilder = in.readOptionalWriteable(SuggestBuilder::new);
        this.terminateAfter = in.readVInt();
        this.timeout = in.readOptionalTimeValue();
        this.trackScores = in.readBoolean();
        this.version = in.readOptionalBoolean();
        this.seqNoAndPrimaryTerm = in.readOptionalBoolean();
        this.extBuilders = in.readNamedWriteableCollectionAsList(SearchExtBuilder.class);
        this.profile = in.readBoolean();
        this.searchAfterBuilder = in.readOptionalWriteable(SearchAfterBuilder::new);
        this.sliceBuilder = in.readOptionalWriteable(SliceBuilder::new);
        this.collapse = in.readOptionalWriteable(CollapseBuilder::new);
        this.trackTotalHitsUpTo = in.readOptionalInt();
        if (in.readBoolean()) {
            this.fetchFields = in.readCollectionAsList(FieldAndFormat::new);
        }
        this.pointInTimeBuilder = in.readOptionalWriteable(PointInTimeBuilder::new);
        this.runtimeMappings = in.readGenericMap();
        this.knnSearch = in.readCollectionAsList(KnnSearchBuilder::new);
        this.rankBuilder = in.readOptionalNamedWriteable(RankBuilder.class);
        this.skipInnerHits = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_1) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.retrieverBuilder != null) {
            throw new IllegalStateException("SearchSourceBuilder should be rewritten first");
        }
        out.writeOptionalWriteable(this.aggregations);
        out.writeOptionalBoolean(this.explain);
        out.writeOptionalWriteable(this.fetchSourceContext);
        out.writeBoolean(this.docValueFields != null);
        if (this.docValueFields != null) {
            out.writeCollection(this.docValueFields);
        }
        out.writeOptionalWriteable(this.storedFieldsContext);
        out.writeVInt(this.from);
        out.writeOptionalWriteable(this.highlightBuilder);
        out.writeCollection(this.indexBoosts);
        out.writeOptionalFloat(this.minScore);
        out.writeOptionalNamedWriteable(this.postQueryBuilder);
        out.writeCollection(this.subSearchSourceBuilders);
        boolean hasRescoreBuilders = this.rescoreBuilders != null;
        out.writeBoolean(hasRescoreBuilders);
        if (hasRescoreBuilders) {
            out.writeNamedWriteableCollection(this.rescoreBuilders);
        }
        boolean hasScriptFields = this.scriptFields != null;
        out.writeBoolean(hasScriptFields);
        if (hasScriptFields) {
            out.writeCollection(this.scriptFields);
        }
        out.writeVInt(this.size);
        boolean hasSorts = this.sorts != null;
        out.writeBoolean(hasSorts);
        if (hasSorts) {
            out.writeNamedWriteableCollection(this.sorts);
        }
        boolean hasStats = this.stats != null;
        out.writeBoolean(hasStats);
        if (hasStats) {
            out.writeStringCollection(this.stats);
        }
        out.writeOptionalWriteable(this.suggestBuilder);
        out.writeVInt(this.terminateAfter);
        out.writeOptionalTimeValue(this.timeout);
        out.writeBoolean(this.trackScores);
        out.writeOptionalBoolean(this.version);
        out.writeOptionalBoolean(this.seqNoAndPrimaryTerm);
        out.writeNamedWriteableCollection(this.extBuilders);
        out.writeBoolean(this.profile);
        out.writeOptionalWriteable(this.searchAfterBuilder);
        out.writeOptionalWriteable(this.sliceBuilder);
        out.writeOptionalWriteable(this.collapse);
        out.writeOptionalInt(this.trackTotalHitsUpTo);
        out.writeBoolean(this.fetchFields != null);
        if (this.fetchFields != null) {
            out.writeCollection(this.fetchFields);
        }
        out.writeOptionalWriteable(this.pointInTimeBuilder);
        out.writeGenericMap(this.runtimeMappings);
        out.writeCollection(this.knnSearch);
        out.writeOptionalNamedWriteable(this.rankBuilder);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_1)) {
            out.writeBoolean(this.skipInnerHits);
        }
    }

    public SearchSourceBuilder retriever(RetrieverBuilder retrieverBuilder) {
        this.retrieverBuilder = retrieverBuilder;
        return this;
    }

    public RetrieverBuilder retriever() {
        return this.retrieverBuilder;
    }

    public SearchSourceBuilder query(QueryBuilder queryBuilder) {
        this.subSearchSourceBuilders = new ArrayList<SubSearchSourceBuilder>();
        if (queryBuilder != null) {
            this.subSearchSourceBuilders.add(new SubSearchSourceBuilder(queryBuilder));
        }
        return this;
    }

    public QueryBuilder query() {
        if (this.subSearchSourceBuilders.isEmpty()) {
            return null;
        }
        if (this.subSearchSourceBuilders.size() == 1) {
            return this.subSearchSourceBuilders.get(0).getQueryBuilder();
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        for (SubSearchSourceBuilder subSearchSourceBuilder : this.subSearchSourceBuilders) {
            boolQueryBuilder.should(subSearchSourceBuilder.getQueryBuilder());
        }
        return boolQueryBuilder;
    }

    public SearchSourceBuilder subSearches(List<SubSearchSourceBuilder> subSearchSourceBuilders) {
        Objects.requireNonNull(subSearchSourceBuilders);
        this.subSearchSourceBuilders = subSearchSourceBuilders;
        return this;
    }

    public List<SubSearchSourceBuilder> subSearches() {
        return this.subSearchSourceBuilders;
    }

    public SearchSourceBuilder postFilter(QueryBuilder postFilter) {
        this.postQueryBuilder = postFilter;
        return this;
    }

    public QueryBuilder postFilter() {
        return this.postQueryBuilder;
    }

    public SearchSourceBuilder knnSearch(List<KnnSearchBuilder> knnSearch) {
        this.knnSearch = Objects.requireNonNull(knnSearch);
        return this;
    }

    public List<KnnSearchBuilder> knnSearch() {
        return Collections.unmodifiableList(this.knnSearch);
    }

    public SearchSourceBuilder rankBuilder(RankBuilder rankBuilder) {
        this.rankBuilder = rankBuilder;
        return this;
    }

    public RankBuilder rankBuilder() {
        return this.rankBuilder;
    }

    public SearchSourceBuilder from(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("[from] parameter cannot be negative but was [" + from + "]");
        }
        this.from = from;
        return this;
    }

    public int from() {
        return this.from;
    }

    public SearchSourceBuilder size(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("[size] parameter cannot be negative, found [" + size + "]");
        }
        this.size = size;
        return this;
    }

    public int size() {
        return this.size;
    }

    public SearchSourceBuilder minScore(float minScore) {
        this.minScore = Float.valueOf(minScore);
        return this;
    }

    public Float minScore() {
        return this.minScore;
    }

    public SearchSourceBuilder explain(Boolean explain) {
        this.explain = explain;
        return this;
    }

    public Boolean explain() {
        return this.explain;
    }

    public SearchSourceBuilder version(Boolean version) {
        this.version = version;
        return this;
    }

    public Boolean version() {
        return this.version;
    }

    public SearchSourceBuilder seqNoAndPrimaryTerm(Boolean seqNoAndPrimaryTerm) {
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        return this;
    }

    public Boolean seqNoAndPrimaryTerm() {
        return this.seqNoAndPrimaryTerm;
    }

    public SearchSourceBuilder timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public SearchSourceBuilder terminateAfter(int terminateAfter) {
        if (terminateAfter < 0) {
            throw new IllegalArgumentException("terminateAfter must be > 0");
        }
        this.terminateAfter = terminateAfter;
        return this;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    public SearchSourceBuilder sort(String name, SortOrder order) {
        if (name.equals("_score")) {
            return this.sort((SortBuilder<?>)SortBuilders.scoreSort().order(order));
        }
        return this.sort((SortBuilder<?>)SortBuilders.fieldSort(name).order(order));
    }

    public SearchSourceBuilder sort(String name) {
        if (name.equals("_score")) {
            return this.sort(SortBuilders.scoreSort());
        }
        return this.sort(SortBuilders.fieldSort(name));
    }

    public SearchSourceBuilder sort(SortBuilder<?> sort) {
        if (this.sorts == null) {
            this.sorts = new ArrayList();
        }
        this.sorts.add(sort);
        return this;
    }

    public SearchSourceBuilder sort(List<SortBuilder<?>> sorts) {
        this.sorts = sorts;
        return this;
    }

    public List<SortBuilder<?>> sorts() {
        return this.sorts;
    }

    public SearchSourceBuilder trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchSourceBuilder trackTotalHits(boolean trackTotalHits) {
        this.trackTotalHitsUpTo = trackTotalHits ? Integer.MAX_VALUE : -1;
        return this;
    }

    @Nullable
    public Integer trackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    public SearchSourceBuilder trackTotalHitsUpTo(int trackTotalHitsUpTo) {
        if (trackTotalHitsUpTo < -1) {
            throw new IllegalArgumentException("[track_total_hits] parameter must be positive or equals to -1, got " + trackTotalHitsUpTo);
        }
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this;
    }

    public Object[] searchAfter() {
        if (this.searchAfterBuilder == null) {
            return null;
        }
        return this.searchAfterBuilder.getSortValues();
    }

    public SearchSourceBuilder searchAfter(Object[] values) {
        this.searchAfterBuilder = new SearchAfterBuilder().setSortValues(values);
        return this;
    }

    public SearchSourceBuilder slice(SliceBuilder builder) {
        this.sliceBuilder = builder;
        return this;
    }

    public SliceBuilder slice() {
        return this.sliceBuilder;
    }

    public CollapseBuilder collapse() {
        return this.collapse;
    }

    public SearchSourceBuilder collapse(CollapseBuilder collapse) {
        this.collapse = collapse;
        return this;
    }

    public SearchSourceBuilder aggregationsBuilder(AggregatorFactories.Builder aggregations) {
        if (this.aggregations != null) {
            throw new IllegalStateException("cannot override aggregations builder");
        }
        this.aggregations = aggregations;
        return this;
    }

    public SearchSourceBuilder aggregation(AggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = AggregatorFactories.builder();
        }
        this.aggregations.addAggregator(aggregation);
        return this;
    }

    public SearchSourceBuilder aggregation(PipelineAggregationBuilder aggregation) {
        if (this.aggregations == null) {
            this.aggregations = AggregatorFactories.builder();
        }
        this.aggregations.addPipelineAggregator(aggregation);
        return this;
    }

    public AggregatorFactories.Builder aggregations() {
        return this.aggregations;
    }

    public SearchSourceBuilder highlighter(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public HighlightBuilder highlighter() {
        return this.highlightBuilder;
    }

    public SearchSourceBuilder suggest(SuggestBuilder suggestBuilder) {
        this.suggestBuilder = suggestBuilder;
        return this;
    }

    public SuggestBuilder suggest() {
        return this.suggestBuilder;
    }

    public SearchSourceBuilder addRescorer(RescorerBuilder<?> rescoreBuilder) {
        if (this.rescoreBuilders == null) {
            this.rescoreBuilders = new ArrayList<RescorerBuilder>();
        }
        this.rescoreBuilders.add(rescoreBuilder);
        return this;
    }

    public SearchSourceBuilder clearRescorers() {
        this.rescoreBuilders = null;
        return this;
    }

    public SearchSourceBuilder profile(boolean profile) {
        this.profile = profile;
        return this;
    }

    public boolean profile() {
        return this.profile;
    }

    public List<RescorerBuilder> rescores() {
        return this.rescoreBuilders;
    }

    public SearchSourceBuilder fetchSource(boolean fetch) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = FetchSourceContext.of(fetch, fetchSourceContext.excludeVectors(), fetchSourceContext.includes(), fetchSourceContext.excludes());
        return this;
    }

    public SearchSourceBuilder fetchSource(@Nullable String include, @Nullable String exclude) {
        String[] stringArray;
        String[] stringArray2;
        if (include == null) {
            stringArray2 = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = include;
        }
        if (exclude == null) {
            stringArray = Strings.EMPTY_ARRAY;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = exclude;
        }
        return this.fetchSource(stringArray2, stringArray);
    }

    public SearchSourceBuilder fetchSource(@Nullable String[] includes, @Nullable String[] excludes) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = FetchSourceContext.of(fetchSourceContext.fetchSource(), fetchSourceContext.excludeVectors(), includes, excludes);
        return this;
    }

    public SearchSourceBuilder fetchSource(@Nullable FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    public SearchSourceBuilder excludeVectors(boolean excludeVectors) {
        FetchSourceContext fetchSourceContext = this.fetchSourceContext != null ? this.fetchSourceContext : FetchSourceContext.FETCH_SOURCE;
        this.fetchSourceContext = FetchSourceContext.of(fetchSourceContext.fetchSource(), excludeVectors, fetchSourceContext.excludeInferenceFields(), fetchSourceContext.includes(), fetchSourceContext.excludes());
        return this;
    }

    public FetchSourceContext fetchSource() {
        return this.fetchSourceContext;
    }

    public SearchSourceBuilder storedField(String name) {
        return this.storedFields(Collections.singletonList(name));
    }

    public SearchSourceBuilder storedFields(List<String> fields) {
        if (this.storedFieldsContext == null) {
            this.storedFieldsContext = StoredFieldsContext.fromList(fields);
        } else {
            this.storedFieldsContext.addFieldNames(fields);
        }
        return this;
    }

    public SearchSourceBuilder storedFields(StoredFieldsContext context) {
        this.storedFieldsContext = context;
        return this;
    }

    public StoredFieldsContext storedFields() {
        return this.storedFieldsContext;
    }

    public List<FieldAndFormat> docValueFields() {
        return this.docValueFields;
    }

    public SearchSourceBuilder docValueField(String name, @Nullable String format) {
        if (this.docValueFields == null) {
            this.docValueFields = new ArrayList<FieldAndFormat>();
        }
        this.docValueFields.add(new FieldAndFormat(name, format));
        return this;
    }

    public SearchSourceBuilder docValueField(String name) {
        return this.docValueField(name, null);
    }

    public List<FieldAndFormat> fetchFields() {
        return this.fetchFields;
    }

    public SearchSourceBuilder fetchField(String name) {
        return this.fetchField(new FieldAndFormat(name, null, null));
    }

    public SearchSourceBuilder fetchField(FieldAndFormat fetchField) {
        if (this.fetchFields == null) {
            this.fetchFields = new ArrayList<FieldAndFormat>();
        }
        this.fetchFields.add(fetchField);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, Script script) {
        this.scriptField(name, script, false);
        return this;
    }

    public SearchSourceBuilder scriptField(String name, Script script, boolean ignoreFailure) {
        if (this.scriptFields == null) {
            this.scriptFields = new ArrayList<ScriptField>();
        }
        this.scriptFields.add(new ScriptField(name, script, ignoreFailure));
        return this;
    }

    public List<ScriptField> scriptFields() {
        return this.scriptFields;
    }

    public SearchSourceBuilder indexBoost(String index, float indexBoost) {
        Objects.requireNonNull(index, "index must not be null");
        this.indexBoosts.add(new IndexBoost(index, indexBoost));
        return this;
    }

    public List<IndexBoost> indexBoosts() {
        return this.indexBoosts;
    }

    public SearchSourceBuilder stats(List<String> statsGroups) {
        this.stats = statsGroups;
        return this;
    }

    public List<String> stats() {
        return this.stats;
    }

    public SearchSourceBuilder ext(List<SearchExtBuilder> searchExtBuilders) {
        this.extBuilders = Objects.requireNonNull(searchExtBuilders, "searchExtBuilders must not be null");
        return this;
    }

    public List<SearchExtBuilder> ext() {
        return this.extBuilders;
    }

    public boolean isSuggestOnly() {
        return this.suggestBuilder != null && this.knnSearch.isEmpty() && this.aggregations == null && this.subSearchSourceBuilders.isEmpty();
    }

    public PointInTimeBuilder pointInTimeBuilder() {
        return this.pointInTimeBuilder;
    }

    public SearchSourceBuilder pointInTimeBuilder(PointInTimeBuilder builder) {
        this.pointInTimeBuilder = builder;
        return this;
    }

    public Map<String, Object> runtimeMappings() {
        return Collections.unmodifiableMap(this.runtimeMappings);
    }

    public SearchSourceBuilder runtimeMappings(Map<String, Object> runtimeMappings) {
        this.runtimeMappings = runtimeMappings == null ? Collections.emptyMap() : runtimeMappings;
        return this;
    }

    @Override
    public SearchSourceBuilder rewrite(QueryRewriteContext context) throws IOException {
        boolean rewritten;
        assert (this.equals(this.shallowCopy(this.subSearchSourceBuilders, this.postQueryBuilder, this.knnSearch, this.aggregations, this.sliceBuilder, this.sorts, this.rescoreBuilders, this.highlightBuilder, this.rankBuilder)));
        if (this.retrieverBuilder != null) {
            RetrieverBuilder newRetriever = this.retrieverBuilder.rewrite(context);
            if (newRetriever != this.retrieverBuilder) {
                SearchSourceBuilder rewritten2 = this.shallowCopy();
                rewritten2.retrieverBuilder = newRetriever;
                return rewritten2;
            }
            RetrieverBuilder retriever = this.retrieverBuilder;
            this.retrieverBuilder = null;
            retriever.extractToSearchSourceBuilder(this, false);
            this.validate();
        }
        RankBuilder rankBuilder = null;
        if (this.rankBuilder != null) {
            rankBuilder = this.rankBuilder.rewrite(context);
        }
        List<SubSearchSourceBuilder> subSearchSourceBuilders = Rewriteable.rewrite(this.subSearchSourceBuilders, context);
        QueryBuilder postQueryBuilder = null;
        if (this.postQueryBuilder != null) {
            postQueryBuilder = this.postQueryBuilder.rewrite(context);
        }
        List<KnnSearchBuilder> knnSearch = Rewriteable.rewrite(this.knnSearch, context);
        AggregatorFactories.Builder aggregations = null;
        if (this.aggregations != null) {
            aggregations = this.aggregations.rewrite(context);
        }
        List<SortBuilder<?>> sorts = Rewriteable.rewrite(this.sorts, context);
        List<RescorerBuilder> rescoreBuilders = Rewriteable.rewrite(this.rescoreBuilders, context);
        HighlightBuilder highlightBuilder = this.highlightBuilder;
        if (highlightBuilder != null) {
            highlightBuilder = this.highlightBuilder.rewrite(context);
        }
        boolean bl = rewritten = subSearchSourceBuilders != this.subSearchSourceBuilders || postQueryBuilder != this.postQueryBuilder || knnSearch != this.knnSearch || aggregations != this.aggregations || rescoreBuilders != this.rescoreBuilders || sorts != this.sorts || this.highlightBuilder != highlightBuilder || this.rankBuilder != rankBuilder;
        if (rewritten) {
            return this.shallowCopy(subSearchSourceBuilders, postQueryBuilder, knnSearch, aggregations, this.sliceBuilder, sorts, rescoreBuilders, highlightBuilder, rankBuilder);
        }
        return this;
    }

    public SearchSourceBuilder shallowCopy() {
        return this.shallowCopy(this.subSearchSourceBuilders, this.postQueryBuilder, this.knnSearch, this.aggregations, this.sliceBuilder, this.sorts, this.rescoreBuilders, this.highlightBuilder, this.rankBuilder);
    }

    private SearchSourceBuilder shallowCopy(List<SubSearchSourceBuilder> subSearchSourceBuilders, QueryBuilder postQueryBuilder, List<KnnSearchBuilder> knnSearch, AggregatorFactories.Builder aggregations, SliceBuilder slice, List<SortBuilder<?>> sorts, List<RescorerBuilder> rescoreBuilders, HighlightBuilder highlightBuilder, RankBuilder rankBuilder) {
        SearchSourceBuilder rewrittenBuilder = new SearchSourceBuilder();
        rewrittenBuilder.aggregations = aggregations;
        rewrittenBuilder.explain = this.explain;
        rewrittenBuilder.extBuilders = this.extBuilders;
        rewrittenBuilder.fetchSourceContext = this.fetchSourceContext;
        rewrittenBuilder.fetchFields = this.fetchFields;
        rewrittenBuilder.docValueFields = this.docValueFields;
        rewrittenBuilder.storedFieldsContext = this.storedFieldsContext;
        rewrittenBuilder.from = this.from;
        rewrittenBuilder.highlightBuilder = highlightBuilder;
        rewrittenBuilder.indexBoosts = this.indexBoosts;
        rewrittenBuilder.minScore = this.minScore;
        rewrittenBuilder.postQueryBuilder = postQueryBuilder;
        rewrittenBuilder.knnSearch = knnSearch;
        rewrittenBuilder.rankBuilder = rankBuilder;
        rewrittenBuilder.profile = this.profile;
        rewrittenBuilder.subSearchSourceBuilders = subSearchSourceBuilders;
        rewrittenBuilder.rescoreBuilders = rescoreBuilders;
        rewrittenBuilder.scriptFields = this.scriptFields;
        rewrittenBuilder.searchAfterBuilder = this.searchAfterBuilder;
        rewrittenBuilder.sliceBuilder = slice;
        rewrittenBuilder.size = this.size;
        rewrittenBuilder.sorts = sorts;
        rewrittenBuilder.stats = this.stats;
        rewrittenBuilder.suggestBuilder = this.suggestBuilder;
        rewrittenBuilder.terminateAfter = this.terminateAfter;
        rewrittenBuilder.timeout = this.timeout;
        rewrittenBuilder.trackScores = this.trackScores;
        rewrittenBuilder.trackTotalHitsUpTo = this.trackTotalHitsUpTo;
        rewrittenBuilder.version = this.version;
        rewrittenBuilder.seqNoAndPrimaryTerm = this.seqNoAndPrimaryTerm;
        rewrittenBuilder.collapse = this.collapse;
        rewrittenBuilder.pointInTimeBuilder = this.pointInTimeBuilder;
        rewrittenBuilder.runtimeMappings = this.runtimeMappings;
        rewrittenBuilder.skipInnerHits = this.skipInnerHits;
        return rewrittenBuilder;
    }

    public SearchSourceBuilder parseXContent(SearchRequest searchRequest, XContentParser parser, boolean checkTrailingTokens, SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature) throws IOException {
        return this.parseXContent(searchRequest, parser, checkTrailingTokens, searchUsageHolder::updateUsage, clusterSupportsFeature);
    }

    public SearchSourceBuilder parseXContent(XContentParser parser, boolean checkTrailingTokens, SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature) throws IOException {
        return this.parseXContent(null, parser, checkTrailingTokens, searchUsageHolder::updateUsage, clusterSupportsFeature);
    }

    public SearchSourceBuilder parseXContent(SearchRequest searchRequest, XContentParser parser, boolean checkTrailingTokens, Predicate<NodeFeature> clusterSupportsFeature) throws IOException {
        return this.parseXContent(searchRequest, parser, checkTrailingTokens, (SearchUsage s) -> {}, clusterSupportsFeature);
    }

    public SearchSourceBuilder parseXContent(XContentParser parser, boolean checkTrailingTokens, Predicate<NodeFeature> clusterSupportsFeature) throws IOException {
        return this.parseXContent(null, parser, checkTrailingTokens, (SearchUsage s) -> {}, clusterSupportsFeature);
    }

    private SearchSourceBuilder parseXContent(SearchRequest searchRequest, XContentParser parser, boolean checkTrailingTokens, Consumer<SearchUsage> searchUsageConsumer, Predicate<NodeFeature> clusterSupportsFeature) throws IOException {
        XContentParser.Token token = parser.currentToken();
        String currentFieldName = null;
        if (token != XContentParser.Token.START_OBJECT && (token = parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
        }
        List<Object> knnBuilders = new ArrayList();
        SearchUsage searchUsage = new SearchUsage();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (PROJECT_ROUTING.match(currentFieldName, parser.getDeprecationHandler()) && searchRequest != null) {
                    searchRequest.setProjectRouting(parser.text());
                    continue;
                }
                if (FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.from(parser.intValue());
                    continue;
                }
                if (SIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.size(parser.intValue());
                    continue;
                }
                if (TIMEOUT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.timeout = TimeValue.parseTimeValue((String)parser.text(), null, (String)TIMEOUT_FIELD.getPreferredName());
                    continue;
                }
                if (TERMINATE_AFTER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.terminateAfter(parser.intValue());
                    searchUsage.trackSectionUsage(TERMINATE_AFTER_FIELD.getPreferredName());
                    continue;
                }
                if (MIN_SCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.minScore = Float.valueOf(parser.floatValue());
                    searchUsage.trackSectionUsage(MIN_SCORE_FIELD.getPreferredName());
                    continue;
                }
                if (VERSION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.version = parser.booleanValue();
                    continue;
                }
                if (SEQ_NO_PRIMARY_TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.seqNoAndPrimaryTerm = parser.booleanValue();
                    continue;
                }
                if (EXPLAIN_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.explain = parser.booleanValue();
                    continue;
                }
                if (TRACK_SCORES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.trackScores = parser.booleanValue();
                    continue;
                }
                if (TRACK_TOTAL_HITS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.VALUE_BOOLEAN || token == XContentParser.Token.VALUE_STRING && Booleans.isBoolean((String)parser.text())) {
                        this.trackTotalHits(parser.booleanValue());
                        continue;
                    }
                    this.trackTotalHitsUpTo(parser.intValue());
                    continue;
                }
                if (_SOURCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.fetchSourceContext = FetchSourceContext.fromXContent(parser);
                    if (this.fetchSourceContext.includes().length <= 0 && this.fetchSourceContext.fetchSource()) continue;
                    searchUsage.trackSectionUsage(_SOURCE_FIELD.getPreferredName());
                    continue;
                }
                if (STORED_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.storedFieldsContext = StoredFieldsContext.fromXContent(STORED_FIELDS_FIELD.getPreferredName(), parser);
                    if (this.storedFieldsContext.fetchFields() && (this.storedFieldsContext.fieldNames() == null || this.storedFieldsContext.fieldNames().size() <= 0)) continue;
                    searchUsage.trackSectionUsage(STORED_FIELDS_FIELD.getPreferredName());
                    continue;
                }
                if (SORT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.sort(parser.text());
                    continue;
                }
                if (PROFILE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.profile = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (RETRIEVER.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.retrieverBuilder = RetrieverBuilder.parseTopLevelRetrieverBuilder(parser, new RetrieverParserContext(searchUsage, clusterSupportsFeature));
                    searchUsage.trackSectionUsage(RETRIEVER.getPreferredName());
                    continue;
                }
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (!this.subSearchSourceBuilders.isEmpty()) {
                        throw new IllegalArgumentException("cannot specify field [" + currentFieldName + "] and field [" + SUB_SEARCHES_FIELD.getPreferredName() + "]");
                    }
                    QueryBuilder queryBuilder = AbstractQueryBuilder.parseTopLevelQuery(parser, searchUsage::trackQueryUsage);
                    this.subSearchSourceBuilders.add(new SubSearchSourceBuilder(queryBuilder));
                    searchUsage.trackSectionUsage(QUERY_FIELD.getPreferredName());
                    continue;
                }
                if (POST_FILTER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.postQueryBuilder = AbstractQueryBuilder.parseTopLevelQuery(parser, searchUsage::trackQueryUsage);
                    searchUsage.trackSectionUsage(POST_FILTER_FIELD.getPreferredName());
                    continue;
                }
                if (KNN_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    knnBuilders = List.of(KnnSearchBuilder.fromXContent(parser));
                    searchUsage.trackSectionUsage(KNN_FIELD.getPreferredName());
                    continue;
                }
                if (RANK_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (!RANK_SUPPORTED) {
                        SearchSourceBuilder.throwUnknownKey(parser, token, currentFieldName);
                    }
                    if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
                        throw new ParsingException(parser.getTokenLocation(), "expected a rank name, but found token [" + String.valueOf(token) + "] for [" + RANK_FIELD.getPreferredName() + "]", new Object[0]);
                    }
                    this.rankBuilder = (RankBuilder)parser.namedObject(RankBuilder.class, parser.currentName(), null);
                    if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
                        throw new ParsingException(parser.getTokenLocation(), "expected token '}', but found token [" + String.valueOf(token) + "] for [" + RANK_FIELD.getPreferredName() + "]", new Object[0]);
                    }
                    parser.nextToken();
                    searchUsage.trackSectionUsage("rank_" + this.rankBuilder.getWriteableName());
                    continue;
                }
                if (_SOURCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.fetchSourceContext = FetchSourceContext.fromXContent(parser);
                    if (this.fetchSourceContext.fetchSource() && this.fetchSourceContext.includes().length <= 0 && this.fetchSourceContext.excludes().length <= 0) continue;
                    searchUsage.trackSectionUsage(_SOURCE_FIELD.getPreferredName());
                    continue;
                }
                if (SCRIPT_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.scriptFields = new ArrayList<ScriptField>();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        this.scriptFields.add(new ScriptField(parser));
                    }
                    searchUsage.trackSectionUsage(SCRIPT_FIELDS_FIELD.getPreferredName());
                    continue;
                }
                if (AGGREGATIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler()) || AGGS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.aggregations = AggregatorFactories.parseAggregators(parser);
                    if (this.aggregations.count() <= 0) continue;
                    searchUsage.trackSectionUsage(AGGS_FIELD.getPreferredName());
                    continue;
                }
                if (HIGHLIGHT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.highlightBuilder = HighlightBuilder.fromXContent(parser);
                    if (this.highlightBuilder.fields().size() <= 0) continue;
                    searchUsage.trackSectionUsage(HIGHLIGHT_FIELD.getPreferredName());
                    continue;
                }
                if (SUGGEST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.suggestBuilder = SuggestBuilder.fromXContent(parser);
                    if (this.suggestBuilder.getSuggestions().size() <= 0) continue;
                    searchUsage.trackSectionUsage(SUGGEST_FIELD.getPreferredName());
                    continue;
                }
                if (SORT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.sorts = new ArrayList(SortBuilder.fromXContent(parser));
                    continue;
                }
                if (RESCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.rescoreBuilders = new ArrayList<RescorerBuilder>();
                    this.rescoreBuilders.add(RescorerBuilder.parseFromXContent(parser, searchUsage::trackRescorerUsage));
                    searchUsage.trackSectionUsage(RESCORE_FIELD.getPreferredName());
                    continue;
                }
                if (EXT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.extBuilders = new ArrayList<SearchExtBuilder>();
                    String extSectionName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            extSectionName = parser.currentName();
                            continue;
                        }
                        SearchExtBuilder searchExtBuilder = (SearchExtBuilder)parser.namedObject(SearchExtBuilder.class, extSectionName, null);
                        if (!searchExtBuilder.getWriteableName().equals(extSectionName)) {
                            throw new IllegalStateException("The parsed [" + searchExtBuilder.getClass().getName() + "] object has a different writeable name compared to the name of the section that  it was parsed from: found [" + searchExtBuilder.getWriteableName() + "] expected [" + extSectionName + "]");
                        }
                        this.extBuilders.add(searchExtBuilder);
                    }
                    if (this.extBuilders.size() <= 0) continue;
                    searchUsage.trackSectionUsage(EXT_FIELD.getPreferredName());
                    continue;
                }
                if (SLICE.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.sliceBuilder = SliceBuilder.fromXContent(parser);
                    if (this.sliceBuilder.getField() == null && this.sliceBuilder.getId() == -1 && this.sliceBuilder.getMax() == -1) continue;
                    searchUsage.trackSectionUsage(SLICE.getPreferredName());
                    continue;
                }
                if (COLLAPSE.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.collapse = CollapseBuilder.fromXContent(parser);
                    if (this.collapse.getField() == null) continue;
                    searchUsage.trackSectionUsage(COLLAPSE.getPreferredName());
                    continue;
                }
                if (POINT_IN_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.pointInTimeBuilder = PointInTimeBuilder.fromXContent(parser);
                    searchUsage.trackSectionUsage(POINT_IN_TIME.getPreferredName());
                    continue;
                }
                if (RUNTIME_MAPPINGS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.runtimeMappings = parser.map();
                    if (this.runtimeMappings.size() <= 0) continue;
                    searchUsage.trackSectionUsage(RUNTIME_MAPPINGS_FIELD.getPreferredName());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (STORED_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.storedFieldsContext = StoredFieldsContext.fromXContent(STORED_FIELDS_FIELD.getPreferredName(), parser);
                    if (this.storedFieldsContext.fetchFields() && (this.storedFieldsContext.fieldNames() == null || this.storedFieldsContext.fieldNames().size() <= 0)) continue;
                    searchUsage.trackSectionUsage(STORED_FIELDS_FIELD.getPreferredName());
                    continue;
                }
                if (DOCVALUE_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.docValueFields = new ArrayList<FieldAndFormat>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.docValueFields.add(FieldAndFormat.fromXContent(parser));
                    }
                    if (this.docValueFields.size() <= 0) continue;
                    searchUsage.trackSectionUsage(DOCVALUE_FIELDS_FIELD.getPreferredName());
                    continue;
                }
                if (FETCH_FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.fetchFields = new ArrayList<FieldAndFormat>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.fetchFields.add(FieldAndFormat.fromXContent(parser));
                    }
                    if (this.fetchFields.size() <= 0) continue;
                    searchUsage.trackSectionUsage(FETCH_FIELDS_FIELD.getPreferredName());
                    continue;
                }
                if (INDICES_BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.indexBoosts.add(new IndexBoost(parser));
                    }
                    if (this.indexBoosts.size() <= 0) continue;
                    searchUsage.trackSectionUsage(INDICES_BOOST_FIELD.getPreferredName());
                    continue;
                }
                if (SORT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.sorts = new ArrayList(SortBuilder.fromXContent(parser));
                    continue;
                }
                if (RESCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.rescoreBuilders = new ArrayList<RescorerBuilder>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        this.rescoreBuilders.add(RescorerBuilder.parseFromXContent(parser, searchUsage::trackRescorerUsage));
                    }
                    searchUsage.trackSectionUsage(RESCORE_FIELD.getPreferredName());
                    continue;
                }
                if (STATS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.stats = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.VALUE_STRING) {
                            this.stats.add(parser.text());
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.VALUE_STRING) + "] in [" + currentFieldName + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
                    }
                    if (this.stats.size() <= 0) continue;
                    searchUsage.trackSectionUsage(STATS_FIELD.getPreferredName());
                    continue;
                }
                if (_SOURCE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.fetchSourceContext = FetchSourceContext.fromXContent(parser);
                    if (this.fetchSourceContext.fetchSource() && this.fetchSourceContext.includes().length <= 0 && this.fetchSourceContext.excludes().length <= 0) continue;
                    searchUsage.trackSectionUsage(_SOURCE_FIELD.getPreferredName());
                    continue;
                }
                if (SEARCH_AFTER.match(currentFieldName, parser.getDeprecationHandler())) {
                    this.searchAfterBuilder = SearchAfterBuilder.fromXContent(parser);
                    searchUsage.trackSectionUsage(SEARCH_AFTER.getPreferredName());
                    continue;
                }
                if (KNN_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.START_OBJECT) {
                            knnBuilders.add(KnnSearchBuilder.fromXContent(parser));
                            continue;
                        }
                        throw new XContentParseException(parser.getTokenLocation(), "malformed knn format, within the knn search array only objects are allowed; found " + String.valueOf(token));
                    }
                    searchUsage.trackSectionUsage(KNN_FIELD.getPreferredName());
                    continue;
                }
                if (SUB_SEARCHES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (!RANK_SUPPORTED) {
                        SearchSourceBuilder.throwUnknownKey(parser, token, currentFieldName);
                    }
                    if (!this.subSearchSourceBuilders.isEmpty()) {
                        throw new IllegalArgumentException("cannot specify field [" + currentFieldName + "] and field [" + QUERY_FIELD.getPreferredName() + "]");
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.START_OBJECT) {
                            this.subSearchSourceBuilders.add(SubSearchSourceBuilder.fromXContent(parser, searchUsage));
                            continue;
                        }
                        throw new XContentParseException(parser.getTokenLocation(), "malformed query within the [sub_searches] field; found " + String.valueOf(token));
                    }
                    searchUsage.trackSectionUsage(SUB_SEARCHES_FIELD.getPreferredName());
                    continue;
                }
                SearchSourceBuilder.throwUnknownKey(parser, token, currentFieldName);
                continue;
            }
            SearchSourceBuilder.throwUnknownKey(parser, token, currentFieldName);
        }
        if (checkTrailingTokens && (token = parser.nextToken()) != null) {
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token [" + String.valueOf(token) + "] found after the main object.", new Object[0]);
        }
        this.knnSearch = knnBuilders.stream().map(knnBuilder -> knnBuilder.build(this.size())).collect(Collectors.toList());
        if (this.rankBuilder != null) {
            if (this.retrieverBuilder != null) {
                throw new IllegalArgumentException("Cannot specify both [rank] and [retriever].");
            }
            RetrieverBuilder transformedRetriever = this.rankBuilder.toRetriever(this, clusterSupportsFeature);
            if (transformedRetriever != null) {
                this.retriever(transformedRetriever);
                this.rankBuilder = null;
                this.subSearchSourceBuilders.clear();
                this.knnSearch.clear();
            }
        }
        searchUsageConsumer.accept(searchUsage);
        return this;
    }

    private static void throwUnknownKey(XContentParser parser, XContentParser.Token token, String currentFieldName) throws ParsingException {
        throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.from != -1) {
            builder.field(FROM_FIELD.getPreferredName(), this.from);
        }
        if (this.size != -1) {
            builder.field(SIZE_FIELD.getPreferredName(), this.size);
        }
        if (this.timeout != null && !this.timeout.equals((Object)TimeValue.MINUS_ONE)) {
            builder.field(TIMEOUT_FIELD.getPreferredName(), this.timeout.getStringRep());
        }
        if (this.terminateAfter != 0) {
            builder.field(TERMINATE_AFTER_FIELD.getPreferredName(), this.terminateAfter);
        }
        if (this.retrieverBuilder != null) {
            builder.field(RETRIEVER.getPreferredName(), (ToXContent)this.retrieverBuilder);
        }
        if (!this.subSearchSourceBuilders.isEmpty()) {
            if (this.subSearchSourceBuilders.size() == 1) {
                builder.field(QUERY_FIELD.getPreferredName(), (ToXContent)this.subSearchSourceBuilders.get(0).getQueryBuilder());
            } else {
                builder.xContentList(SUB_SEARCHES_FIELD.getPreferredName(), this.subSearchSourceBuilders);
            }
        }
        if (this.postQueryBuilder != null) {
            builder.field(POST_FILTER_FIELD.getPreferredName(), (ToXContent)this.postQueryBuilder);
        }
        if (!this.knnSearch.isEmpty()) {
            builder.startArray(KNN_FIELD.getPreferredName());
            for (KnnSearchBuilder knnSearchBuilder : this.knnSearch) {
                builder.startObject();
                knnSearchBuilder.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.rankBuilder != null) {
            builder.field(RANK_FIELD.getPreferredName(), (ToXContent)this.rankBuilder);
        }
        if (this.minScore != null) {
            builder.field(MIN_SCORE_FIELD.getPreferredName(), this.minScore);
        }
        if (this.version != null) {
            builder.field(VERSION_FIELD.getPreferredName(), this.version);
        }
        if (this.seqNoAndPrimaryTerm != null) {
            builder.field(SEQ_NO_PRIMARY_TERM_FIELD.getPreferredName(), this.seqNoAndPrimaryTerm);
        }
        if (this.explain != null) {
            builder.field(EXPLAIN_FIELD.getPreferredName(), this.explain);
        }
        if (this.profile) {
            builder.field("profile", true);
        }
        if (this.fetchSourceContext != null) {
            builder.field(_SOURCE_FIELD.getPreferredName(), (ToXContent)this.fetchSourceContext);
        }
        if (this.storedFieldsContext != null) {
            this.storedFieldsContext.toXContent(STORED_FIELDS_FIELD.getPreferredName(), builder);
        }
        if (this.docValueFields != null) {
            builder.startArray(DOCVALUE_FIELDS_FIELD.getPreferredName());
            for (FieldAndFormat fieldAndFormat : this.docValueFields) {
                fieldAndFormat.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.fetchFields != null) {
            builder.startArray(FETCH_FIELDS_FIELD.getPreferredName());
            for (FieldAndFormat fieldAndFormat : this.fetchFields) {
                fieldAndFormat.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.scriptFields != null) {
            builder.startObject(SCRIPT_FIELDS_FIELD.getPreferredName());
            for (ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.sorts != null) {
            builder.startArray(SORT_FIELD.getPreferredName());
            for (SortBuilder sortBuilder : this.sorts) {
                sortBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.trackScores) {
            builder.field(TRACK_SCORES_FIELD.getPreferredName(), true);
        }
        if (this.trackTotalHitsUpTo != null) {
            builder.field(TRACK_TOTAL_HITS_FIELD.getPreferredName(), this.trackTotalHitsUpTo);
        }
        if (this.searchAfterBuilder != null) {
            builder.array(SEARCH_AFTER.getPreferredName(), this.searchAfterBuilder.getSortValues());
        }
        if (this.sliceBuilder != null) {
            builder.field(SLICE.getPreferredName(), (ToXContent)this.sliceBuilder);
        }
        if (!this.indexBoosts.isEmpty()) {
            builder.startArray(INDICES_BOOST_FIELD.getPreferredName());
            for (IndexBoost indexBoost : this.indexBoosts) {
                builder.startObject();
                builder.field(indexBoost.index, indexBoost.boost);
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.aggregations != null) {
            builder.field(AGGREGATIONS_FIELD.getPreferredName(), (ToXContent)this.aggregations);
        }
        if (this.highlightBuilder != null) {
            builder.field(HIGHLIGHT_FIELD.getPreferredName(), (ToXContent)this.highlightBuilder);
        }
        if (this.suggestBuilder != null) {
            builder.field(SUGGEST_FIELD.getPreferredName(), (ToXContent)this.suggestBuilder);
        }
        if (this.rescoreBuilders != null) {
            builder.startArray(RESCORE_FIELD.getPreferredName());
            for (RescorerBuilder rescorerBuilder : this.rescoreBuilders) {
                rescorerBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.stats != null) {
            builder.stringListField(STATS_FIELD.getPreferredName(), this.stats);
        }
        if (this.extBuilders != null && !this.extBuilders.isEmpty()) {
            builder.startObject(EXT_FIELD.getPreferredName());
            for (SearchExtBuilder searchExtBuilder : this.extBuilders) {
                searchExtBuilder.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.collapse != null) {
            builder.field(COLLAPSE.getPreferredName(), (ToXContent)this.collapse);
        }
        if (this.pointInTimeBuilder != null) {
            builder.startObject(POINT_IN_TIME.getPreferredName());
            this.pointInTimeBuilder.toXContent(builder, params);
            builder.endObject();
        }
        if (!this.runtimeMappings.isEmpty()) {
            builder.field(RUNTIME_MAPPINGS_FIELD.getPreferredName(), this.runtimeMappings);
        }
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public SearchSourceBuilder skipInnerHits(boolean skipInnerHits) {
        this.skipInnerHits = skipInnerHits;
        return this;
    }

    public boolean skipInnerHits() {
        return this.skipInnerHits;
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.explain, this.fetchSourceContext, this.fetchFields, this.docValueFields, this.storedFieldsContext, this.from, this.highlightBuilder, this.indexBoosts, this.minScore, this.subSearchSourceBuilders, this.postQueryBuilder, this.knnSearch, this.rankBuilder, this.rescoreBuilders, this.scriptFields, this.size, this.sorts, this.searchAfterBuilder, this.sliceBuilder, this.stats, this.suggestBuilder, this.terminateAfter, this.timeout, this.trackScores, this.version, this.seqNoAndPrimaryTerm, this.profile, this.extBuilders, this.collapse, this.trackTotalHitsUpTo, this.pointInTimeBuilder, this.runtimeMappings, this.skipInnerHits);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SearchSourceBuilder other = (SearchSourceBuilder)obj;
        return Objects.equals(this.aggregations, other.aggregations) && Objects.equals(this.explain, other.explain) && Objects.equals(this.fetchSourceContext, other.fetchSourceContext) && Objects.equals(this.fetchFields, other.fetchFields) && Objects.equals(this.docValueFields, other.docValueFields) && Objects.equals(this.storedFieldsContext, other.storedFieldsContext) && Objects.equals(this.from, other.from) && Objects.equals(this.highlightBuilder, other.highlightBuilder) && Objects.equals(this.indexBoosts, other.indexBoosts) && Objects.equals(this.minScore, other.minScore) && Objects.equals(this.subSearchSourceBuilders, other.subSearchSourceBuilders) && Objects.equals(this.postQueryBuilder, other.postQueryBuilder) && Objects.equals(this.knnSearch, other.knnSearch) && Objects.equals(this.rankBuilder, other.rankBuilder) && Objects.equals(this.rescoreBuilders, other.rescoreBuilders) && Objects.equals(this.scriptFields, other.scriptFields) && Objects.equals(this.size, other.size) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.searchAfterBuilder, other.searchAfterBuilder) && Objects.equals(this.sliceBuilder, other.sliceBuilder) && Objects.equals(this.stats, other.stats) && Objects.equals(this.suggestBuilder, other.suggestBuilder) && Objects.equals(this.terminateAfter, other.terminateAfter) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.trackScores, other.trackScores) && Objects.equals(this.version, other.version) && Objects.equals(this.seqNoAndPrimaryTerm, other.seqNoAndPrimaryTerm) && Objects.equals(this.profile, other.profile) && Objects.equals(this.extBuilders, other.extBuilders) && Objects.equals(this.collapse, other.collapse) && Objects.equals(this.trackTotalHitsUpTo, other.trackTotalHitsUpTo) && Objects.equals(this.pointInTimeBuilder, other.pointInTimeBuilder) && Objects.equals(this.runtimeMappings, other.runtimeMappings) && Objects.equals(this.skipInnerHits, other.skipInnerHits);
    }

    public String toString() {
        return this.toString(EMPTY_PARAMS);
    }

    public String toString(ToXContent.Params params) {
        try {
            return XContentHelper.toXContent((ToXContent)this, XContentType.JSON, params, true).utf8ToString();
        }
        catch (IOException e) {
            throw new ElasticsearchException(e);
        }
    }

    public boolean supportsParallelCollection(ToLongFunction<String> fieldCardinality) {
        if (this.profile) {
            return false;
        }
        if (this.sorts != null) {
            for (SortBuilder<?> sortBuilder : this.sorts) {
                if (sortBuilder.supportsParallelCollection()) continue;
                return false;
            }
        }
        return this.collapse == null && (this.aggregations == null || this.aggregations.supportsParallelCollection(fieldCardinality));
    }

    private void validate() throws ValidationException {
        ActionRequestValidationException exceptions = this.validate(null, false, false);
        if (exceptions != null) {
            throw exceptions;
        }
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException, boolean isScroll, boolean allowPartialSearchResults) {
        if (this.retriever() != null) {
            validationException = this.retriever().validate(this, validationException, isScroll, allowPartialSearchResults);
            ArrayList<String> specified = new ArrayList<String>();
            if (!this.subSearches().isEmpty()) {
                specified.add(QUERY_FIELD.getPreferredName());
            }
            if (!this.knnSearch().isEmpty()) {
                specified.add(KNN_FIELD.getPreferredName());
            }
            if (this.searchAfter() != null) {
                specified.add(SEARCH_AFTER.getPreferredName());
            }
            if (this.terminateAfter() != 0) {
                specified.add(TERMINATE_AFTER_FIELD.getPreferredName());
            }
            if (this.sorts() != null) {
                specified.add(SORT_FIELD.getPreferredName());
            }
            if (this.rankBuilder() != null) {
                specified.add(RANK_FIELD.getPreferredName());
            }
            if (this.rescores() != null) {
                specified.add(RESCORE_FIELD.getPreferredName());
            }
            if (!specified.isEmpty()) {
                validationException = ValidateActions.addValidationError("cannot specify [" + RETRIEVER.getPreferredName() + "] and " + String.valueOf(specified), validationException);
            }
        }
        if (isScroll) {
            if (this.trackTotalHitsUpTo() != null && this.trackTotalHitsUpTo() != Integer.MAX_VALUE) {
                validationException = ValidateActions.addValidationError("disabling [track_total_hits] is not allowed in a scroll context", validationException);
            }
            if (this.from() > 0) {
                validationException = ValidateActions.addValidationError("using [from] is not allowed in a scroll context", validationException);
            }
            if (this.size() == 0) {
                validationException = ValidateActions.addValidationError("[size] cannot be [0] in a scroll context", validationException);
            }
            if (this.rescores() != null && !this.rescores().isEmpty()) {
                validationException = ValidateActions.addValidationError("using [rescore] is not allowed in a scroll context", validationException);
            }
            if (!CollectionUtils.isEmpty(this.searchAfter())) {
                validationException = ValidateActions.addValidationError("[search_after] cannot be used in a scroll context", validationException);
            }
            if (this.collapse() != null) {
                validationException = ValidateActions.addValidationError("cannot use `collapse` in a scroll context", validationException);
            }
        }
        if (this.slice() != null && this.pointInTimeBuilder() == null && !isScroll) {
            validationException = ValidateActions.addValidationError("[slice] can only be used with [scroll] or [point-in-time] requests", validationException);
        }
        if (this.from() > 0 && !CollectionUtils.isEmpty(this.searchAfter())) {
            validationException = ValidateActions.addValidationError("[from] parameter must be set to 0 when [search_after] is used", validationException);
        }
        if (this.storedFields() != null && !this.storedFields().fetchFields()) {
            if (this.fetchSource() != null && this.fetchSource().fetchSource()) {
                validationException = ValidateActions.addValidationError("[stored_fields] cannot be disabled if [_source] is requested", validationException);
            }
            if (this.fetchFields() != null) {
                validationException = ValidateActions.addValidationError("[stored_fields] cannot be disabled when using the [fields] option", validationException);
            }
        }
        if (this.subSearches().size() >= 2 && this.rankBuilder() == null) {
            validationException = ValidateActions.addValidationError("[sub_searches] requires [rank]", validationException);
        }
        if (this.aggregations() != null) {
            validationException = this.aggregations().validate(validationException);
        }
        if (this.rankBuilder() != null) {
            int s;
            int n = s = this.size() == -1 ? 10 : this.size();
            if (s == 0) {
                validationException = ValidateActions.addValidationError("[rank] requires [size] greater than [0]", validationException);
            }
            if (s > this.rankBuilder().rankWindowSize()) {
                validationException = ValidateActions.addValidationError("[rank] requires [rank_window_size: " + this.rankBuilder().rankWindowSize() + "] be greater than or equal to [size: " + s + "]", validationException);
            }
            int queryCount = this.subSearches().size() + this.knnSearch().size();
            if (this.rankBuilder().isCompoundBuilder() && queryCount < 2) {
                validationException = ValidateActions.addValidationError("[rank] requires a minimum of [2] result sets using a combination of sub searches and/or knn searches", validationException);
            }
            if (isScroll) {
                validationException = ValidateActions.addValidationError("[rank] cannot be used in a scroll context", validationException);
            }
            if (this.rescores() != null && !this.rescores().isEmpty()) {
                validationException = ValidateActions.addValidationError("[rank] cannot be used with [rescore]", validationException);
            }
            if (this.suggest() != null && !this.suggest().getSuggestions().isEmpty()) {
                validationException = ValidateActions.addValidationError("[rank] cannot be used with [suggest]", validationException);
            }
        }
        if (this.rescores() != null) {
            for (RescorerBuilder rescorer : this.rescores()) {
                validationException = rescorer.validate(this, validationException);
            }
        }
        return validationException;
    }

    public static class ScriptField
    implements Writeable,
    ToXContentFragment {
        private final boolean ignoreFailure;
        private final String fieldName;
        private final Script script;

        public ScriptField(String fieldName, Script script, boolean ignoreFailure) {
            this.fieldName = fieldName;
            this.script = script;
            this.ignoreFailure = ignoreFailure;
        }

        public ScriptField(StreamInput in) throws IOException {
            this.fieldName = in.readString();
            this.script = new Script(in);
            this.ignoreFailure = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.fieldName);
            this.script.writeTo(out);
            out.writeBoolean(this.ignoreFailure);
        }

        public ScriptField(XContentParser parser) throws IOException {
            boolean ignoreFailure = false;
            String scriptFieldName = parser.currentName();
            Script script = null;
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            script = Script.parse(parser);
                            continue;
                        }
                        if (IGNORE_FAILURE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            ignoreFailure = parser.booleanValue();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        if (SCRIPT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            script = Script.parse(parser);
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + currentFieldName + "].", parser.getTokenLocation());
                }
            } else {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] in [" + parser.currentName() + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
            }
            this.ignoreFailure = ignoreFailure;
            this.fieldName = scriptFieldName;
            this.script = script;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public Script script() {
            return this.script;
        }

        public boolean ignoreFailure() {
            return this.ignoreFailure;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.fieldName);
            builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
            builder.field(IGNORE_FAILURE_FIELD.getPreferredName(), this.ignoreFailure);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.fieldName, this.script, this.ignoreFailure);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptField other = (ScriptField)obj;
            return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.script, other.script) && Objects.equals(this.ignoreFailure, other.ignoreFailure);
        }
    }

    public static class IndexBoost
    implements Writeable,
    ToXContentObject {
        private final String index;
        private final float boost;

        IndexBoost(String index, float boost) {
            this.index = index;
            this.boost = boost;
        }

        IndexBoost(StreamInput in) throws IOException {
            this.index = in.readString();
            this.boost = in.readFloat();
        }

        IndexBoost(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.FIELD_NAME) + "] in [" + String.valueOf(INDICES_BOOST_FIELD) + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
                }
                this.index = parser.currentName();
                token = parser.nextToken();
                if (token != XContentParser.Token.VALUE_NUMBER) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.VALUE_NUMBER) + "] in [" + String.valueOf(INDICES_BOOST_FIELD) + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
                }
                this.boost = parser.floatValue();
                token = parser.nextToken();
                if (token != XContentParser.Token.END_OBJECT) {
                    throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.END_OBJECT) + "] in [" + String.valueOf(INDICES_BOOST_FIELD) + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
                }
            } else {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] in [" + parser.currentName() + "] but found [" + String.valueOf(token) + "]", parser.getTokenLocation());
            }
        }

        public String getIndex() {
            return this.index;
        }

        public float getBoost() {
            return this.boost;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeFloat(this.boost);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(this.index, this.boost);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.index, Float.valueOf(this.boost));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexBoost other = (IndexBoost)obj;
            return Objects.equals(this.index, other.index) && Objects.equals(Float.valueOf(this.boost), Float.valueOf(other.boost));
        }
    }
}

