/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;

public class Model
implements Writeable {
    private final ModelConfigurations configurations;
    private final ModelSecrets secrets;

    public static String documentId(String modelId) {
        return "model_" + modelId;
    }

    public Model(ModelConfigurations configurations, ModelSecrets secrets) {
        this.configurations = Objects.requireNonNull(configurations);
        this.secrets = Objects.requireNonNull(secrets);
    }

    public Model(Model model, TaskSettings taskSettings) {
        Objects.requireNonNull(model);
        this.configurations = ModelConfigurations.of(model, taskSettings);
        this.secrets = model.getSecrets();
    }

    public Model(Model model, ServiceSettings serviceSettings) {
        Objects.requireNonNull(model);
        this.configurations = ModelConfigurations.of(model, serviceSettings);
        this.secrets = model.getSecrets();
    }

    public Model(ModelConfigurations configurations) {
        this(configurations, new ModelSecrets());
    }

    public Model(StreamInput in) throws IOException {
        this.configurations = new ModelConfigurations(in);
        this.secrets = new ModelSecrets(in);
    }

    public String getInferenceEntityId() {
        return this.configurations.getInferenceEntityId();
    }

    public TaskType getTaskType() {
        return this.configurations.getTaskType();
    }

    public ModelConfigurations getConfigurations() {
        return this.configurations;
    }

    public ModelSecrets getSecrets() {
        return this.secrets;
    }

    public ServiceSettings getServiceSettings() {
        return this.configurations.getServiceSettings();
    }

    public TaskSettings getTaskSettings() {
        return this.configurations.getTaskSettings();
    }

    public SecretSettings getSecretSettings() {
        return this.secrets.getSecretSettings();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model model = (Model)o;
        return Objects.equals(this.configurations, model.configurations) && Objects.equals(this.secrets, model.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.configurations, this.secrets);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.configurations.writeTo(out);
        this.secrets.writeTo(out);
    }
}

