/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public final class SyntheticIdField
extends Field {
    public static final String NAME = "_id";
    private static final String ENABLED_ATTRIBUTE_KEY = SyntheticIdField.class.getSimpleName() + ".enabled";
    private static final String ENABLED_ATTRIBUTE_VALUE = Boolean.TRUE.toString();
    private static final FieldType TYPE = new FieldType();

    public SyntheticIdField(BytesRef bytes) {
        super(NAME, bytes, (IndexableFieldType)TYPE);
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        assert (false) : "this should never be called";
        throw new UnsupportedOperationException();
    }

    public void setTokenStream(TokenStream tokenStream) {
        assert (false) : "this should never be called";
        throw new UnsupportedOperationException();
    }

    public static boolean hasSyntheticIdAttributes(Map<String, String> attributes) {
        String attributeValue;
        if (attributes != null && (attributeValue = attributes.get(ENABLED_ATTRIBUTE_KEY)) != null) {
            return ENABLED_ATTRIBUTE_VALUE.equals(attributeValue);
        }
        return false;
    }

    static {
        TYPE.putAttribute(ENABLED_ATTRIBUTE_KEY, ENABLED_ATTRIBUTE_VALUE);
        TYPE.setIndexOptions(IndexOptions.NONE);
        TYPE.setTokenized(false);
        TYPE.setOmitNorms(true);
        TYPE.setStored(true);
        TYPE.freeze();
    }
}

