/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.hnsw.ScalarQuantizedVectorScorer;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.AbstractHnswVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93ScalarQuantizedVectorsFormat;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class ES93HnswScalarQuantizedVectorsFormat
extends AbstractHnswVectorsFormat {
    static final String NAME = "ES93HnswScalarQuantizedVectorsFormat";
    private static final int ALLOWED_BITS = 144;
    private static final float MINIMUM_CONFIDENCE_INTERVAL = 0.9f;
    private static final float MAXIMUM_CONFIDENCE_INTERVAL = 1.0f;
    static final FlatVectorsScorer flatVectorScorer = new ES93ScalarQuantizedVectorsFormat.ESQuantizedFlatVectorsScorer((FlatVectorsScorer)new ScalarQuantizedVectorScorer(FlatVectorScorerUtil.getLucene99FlatVectorsScorer()));
    private final FlatVectorsFormat rawVectorFormat;
    public final Float confidenceInterval;
    private final byte bits;
    private final boolean compress;

    public ES93HnswScalarQuantizedVectorsFormat() {
        super(NAME);
        this.rawVectorFormat = new ES93GenericFlatVectorsFormat(DenseVectorFieldMapper.ElementType.FLOAT, false);
        this.confidenceInterval = null;
        this.bits = (byte)7;
        this.compress = false;
    }

    public ES93HnswScalarQuantizedVectorsFormat(int maxConn, int beamWidth, DenseVectorFieldMapper.ElementType elementType, Float confidenceInterval, int bits, boolean compress, boolean useDirectIO) {
        this(maxConn, beamWidth, elementType, confidenceInterval, bits, compress, useDirectIO, 1, null);
    }

    public ES93HnswScalarQuantizedVectorsFormat(int maxConn, int beamWidth, DenseVectorFieldMapper.ElementType elementType, Float confidenceInterval, int bits, boolean compress, boolean useDirectIO, int numMergeWorkers, ExecutorService mergeExec) {
        super(NAME, maxConn, beamWidth, numMergeWorkers, mergeExec);
        if (confidenceInterval != null && confidenceInterval.floatValue() != 0.0f && (confidenceInterval.floatValue() < 0.9f || confidenceInterval.floatValue() > 1.0f)) {
            throw new IllegalArgumentException("confidenceInterval must be between 0.9 and 1.0; confidenceInterval=" + confidenceInterval);
        }
        if (bits < 1 || bits > 8 || (0x90 & 1 << bits) == 0) {
            throw new IllegalArgumentException("bits must be one of: 4, 7; bits=" + bits);
        }
        assert (elementType != DenseVectorFieldMapper.ElementType.BIT) : "BIT should not be used with scalar quantization";
        this.rawVectorFormat = new ES93GenericFlatVectorsFormat(elementType, useDirectIO);
        this.confidenceInterval = confidenceInterval;
        this.bits = (byte)bits;
        this.compress = compress;
    }

    @Override
    protected FlatVectorsFormat flatVectorsFormat() {
        return this.rawVectorFormat;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99HnswVectorsWriter(state, this.maxConn, this.beamWidth, (FlatVectorsWriter)new Lucene99ScalarQuantizedVectorsWriter(state, this.confidenceInterval, this.bits, this.compress, this.rawVectorFormat.fieldsWriter(state), flatVectorScorer), this.numMergeWorkers, this.mergeExec);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene99HnswVectorsReader(state, (FlatVectorsReader)new Lucene99ScalarQuantizedVectorsReader(state, this.rawVectorFormat.fieldsReader(state), flatVectorScorer));
    }

    @Override
    public String toString() {
        return "ES93HnswScalarQuantizedVectorsFormat(name=ES93HnswScalarQuantizedVectorsFormat, maxConn=" + this.maxConn + ", beamWidth=" + this.beamWidth + ", confidenceInterval=" + this.confidenceInterval + ", bits=" + this.bits + ", compressed=" + this.compress + ", flatVectorScorer=" + String.valueOf(flatVectorScorer) + ", flatVectorFormat=" + String.valueOf(this.rawVectorFormat) + ")";
    }
}

