/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.codec.tsdb.DocValuesForUtil;

public final class TSDBDocValuesEncoder {
    private final DocValuesForUtil forUtil;
    private final int numericBlockSize;

    public TSDBDocValuesEncoder(int numericBlockSize) {
        this.forUtil = new DocValuesForUtil(numericBlockSize);
        this.numericBlockSize = numericBlockSize;
    }

    private void deltaEncode(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        int gts = 0;
        int lts = 0;
        for (int i = 1; i < this.numericBlockSize; ++i) {
            if (in[i] > in[i - 1]) {
                ++gts;
                continue;
            }
            if (in[i] >= in[i - 1]) continue;
            ++lts;
        }
        boolean doDeltaCompression = gts == 0 && lts >= 2 || lts == 0 && gts >= 2;
        long first = 0L;
        if (doDeltaCompression) {
            for (int i = this.numericBlockSize - 1; i > 0; --i) {
                int n = i;
                in[n] = in[n] - in[i - 1];
            }
            first = in[0] - in[1];
            in[0] = in[1];
            token = token << 1 | 1;
        } else {
            token <<= 1;
        }
        this.removeOffset(token, tokenBits + 1, in, out);
        if (doDeltaCompression) {
            out.writeZLong(first);
        }
    }

    private void removeOffset(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (long l : in) {
            min = Math.min(l, min);
            max = Math.max(l, max);
        }
        if (max - min < 0L) {
            min = 0L;
        } else if (min > 0L && min < max >>> 2) {
            min = 0L;
        }
        if (min != 0L) {
            int i = 0;
            while (i < this.numericBlockSize) {
                int n = i++;
                in[n] = in[n] - min;
            }
            token = token << 1 | 1;
        } else {
            token <<= 1;
        }
        this.gcdEncode(token, tokenBits + 1, in, out);
        if (min != 0L) {
            out.writeZLong(min);
        }
    }

    private void gcdEncode(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        boolean doGcdCompression;
        long l;
        long gcd = 0L;
        long[] lArray = in;
        int n = lArray.length;
        for (int i = 0; i < n && (gcd = MathUtil.gcd((long)gcd, (long)(l = lArray[i]))) != 1L; ++i) {
        }
        boolean bl = doGcdCompression = Long.compareUnsigned(gcd, 1L) > 0;
        if (doGcdCompression) {
            int i = 0;
            while (i < this.numericBlockSize) {
                int n2 = i++;
                in[n2] = in[n2] / gcd;
            }
            token = token << 1 | 1;
        } else {
            token <<= 1;
        }
        this.forEncode(token, tokenBits + 1, in, out);
        if (doGcdCompression) {
            out.writeVLong(gcd - 2L);
        }
    }

    private void forEncode(int token, int tokenBits, long[] in, DataOutput out) throws IOException {
        long or = 0L;
        for (long l : in) {
            or |= l;
        }
        int bitsPerValue = or == 0L ? 0 : DocValuesForUtil.roundBits(PackedInts.unsignedBitsRequired((long)or));
        out.writeVInt(bitsPerValue << tokenBits | token);
        if (bitsPerValue > 0) {
            this.forUtil.encode(in, bitsPerValue, out);
        }
    }

    public void encode(long[] in, DataOutput out) throws IOException {
        assert (in.length == this.numericBlockSize);
        this.deltaEncode(0, 0, in, out);
    }

    public void encodeOrdinals(long[] in, DataOutput out, int bitsPerOrd) throws IOException {
        long firstValue;
        assert (in.length == this.numericBlockSize);
        int numRuns = 1;
        long previousValue = firstValue = in[0];
        boolean cyclic = false;
        int cycleLength = 0;
        for (int i = 1; i < in.length; ++i) {
            long currentValue = in[i];
            if (previousValue != currentValue) {
                ++numRuns;
            }
            if (currentValue == firstValue && cycleLength != -1) {
                if (cycleLength == 0) {
                    cycleLength = i;
                } else if (cycleLength == 1 || i % cycleLength != 0) {
                    cycleLength = -1;
                }
            }
            previousValue = currentValue;
        }
        int maxCycleLength = in.length / 4;
        if (numRuns > 2 && cycleLength > 1 && cycleLength <= maxCycleLength) {
            cyclic = true;
            for (int i = cycleLength; i < in.length; ++i) {
                if (in[i] == in[i - cycleLength]) continue;
                cyclic = false;
                break;
            }
        }
        if (numRuns == 1 && bitsPerOrd < 63) {
            long value = in[0];
            out.writeVLong(value << 1);
        } else if (numRuns == 2 && bitsPerOrd < 62) {
            out.writeVLong(in[0] << 2 | 1L);
            int firstRunLen = in.length;
            for (int i = 1; i < in.length; ++i) {
                if (in[i] == in[0]) continue;
                firstRunLen = i;
                break;
            }
            out.writeVInt(firstRunLen);
            out.writeZLong(in[in.length - 1] - in[0]);
        } else if (cyclic) {
            long headerAndCycleLength = (long)cycleLength << 4 | 7L;
            out.writeVLong(headerAndCycleLength);
            for (int i = 0; i < cycleLength; ++i) {
                out.writeVLong(in[i]);
            }
        } else {
            out.writeVLong(3L);
            this.forUtil.encode(in, bitsPerOrd, out);
        }
    }

    public void decodeOrdinals(DataInput in, long[] out, int bitsPerOrd) throws IOException {
        assert (out.length == this.numericBlockSize) : out.length;
        long v1 = in.readVLong();
        int encoding = Long.numberOfTrailingZeros(v1 ^ 0xFFFFFFFFFFFFFFFFL);
        v1 >>>= encoding + 1;
        if (encoding == 0) {
            Arrays.fill(out, v1);
        } else if (encoding == 1) {
            int runLen = in.readVInt();
            long v2 = v1 + in.readZLong();
            Arrays.fill(out, 0, runLen, v1);
            Arrays.fill(out, runLen, out.length, v2);
        } else if (encoding == 2) {
            this.forUtil.decode(bitsPerOrd, in, out);
        } else if (encoding == 3) {
            int copyLength;
            int cycleLength = (int)v1;
            for (int i = 0; i < cycleLength; ++i) {
                out[i] = in.readVLong();
            }
            for (int length = cycleLength; length < out.length; length += copyLength) {
                copyLength = Math.min(length, out.length - length);
                System.arraycopy(out, 0, out, length, copyLength);
            }
        }
    }

    public void decode(DataInput in, long[] out) throws IOException {
        assert (out.length == this.numericBlockSize) : out.length;
        int token = in.readVInt();
        int bitsPerValue = token >>> 3;
        if (bitsPerValue != 0) {
            this.forUtil.decode(bitsPerValue, in, out);
        } else {
            Arrays.fill(out, 0L);
        }
        if ((token & 7) != 0) {
            boolean doDeltaCompression;
            boolean hasOffset;
            boolean doGcdCompression;
            boolean bl = doGcdCompression = (token & 1) != 0;
            if (doGcdCompression) {
                long gcd = 2L + in.readVLong();
                this.mul(out, gcd);
            }
            boolean bl2 = hasOffset = (token & 2) != 0;
            if (hasOffset) {
                long min = in.readZLong();
                this.add(out, min);
            }
            boolean bl3 = doDeltaCompression = (token & 4) != 0;
            if (doDeltaCompression) {
                long first = in.readZLong();
                out[0] = out[0] + first;
                this.deltaDecode(out);
            }
        }
    }

    private void mul(long[] arr, long m) {
        int i = 0;
        while (i < this.numericBlockSize) {
            int n = i++;
            arr[n] = arr[n] * m;
        }
    }

    private void add(long[] arr, long min) {
        int i = 0;
        while (i < this.numericBlockSize) {
            int n = i++;
            arr[n] = arr[n] + min;
        }
    }

    private void deltaDecode(long[] arr) {
        long sum = 0L;
        for (int i = 0; i < this.numericBlockSize; ++i) {
            arr[i] = sum += arr[i];
        }
    }
}

