/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SimulateTemplateAction
extends ActionType<SimulateIndexTemplateResponse> {
    public static final SimulateTemplateAction INSTANCE = new SimulateTemplateAction();
    public static final String NAME = "indices:admin/index_template/simulate";

    private SimulateTemplateAction() {
        super(NAME);
    }

    public static class Request
    extends LocalClusterStateRequest {
        @Nullable
        private String templateName;
        @Nullable
        private TransportPutComposableIndexTemplateAction.Request indexTemplateRequest;
        private boolean includeDefaults = false;

        public Request(TimeValue masterTimeout, String templateName) {
            super(masterTimeout);
            this.templateName = templateName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.templateName = in.readOptionalString();
            this.indexTemplateRequest = in.readOptionalWriteable(TransportPutComposableIndexTemplateAction.Request::new);
            this.includeDefaults = in.readBoolean();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indexTemplateRequest != null) {
                validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
            }
            if (this.templateName == null && this.indexTemplateRequest == null) {
                validationException = ValidateActions.addValidationError("either index name or index template body must be specified for simulation", validationException);
            }
            return validationException;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        @Nullable
        public String getTemplateName() {
            return this.templateName;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        @Nullable
        public TransportPutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
            return this.indexTemplateRequest;
        }

        public Request indexTemplateRequest(TransportPutComposableIndexTemplateAction.Request indexTemplateRequest) {
            this.indexTemplateRequest = indexTemplateRequest;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return this.templateName.equals(that.templateName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest) && this.includeDefaults == that.includeDefaults;
        }

        public int hashCode() {
            return Objects.hash(this.templateName, this.indexTemplateRequest, this.includeDefaults);
        }
    }
}

