/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetAllSampleConfigurationAction
extends ActionType<Response> {
    public static final GetAllSampleConfigurationAction INSTANCE = new GetAllSampleConfigurationAction();
    public static final String NAME = "indices:monitor/sample/config/get_all";

    private GetAllSampleConfigurationAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final Map<String, SamplingConfiguration> indexToSamplingConfigMap;

        public Response(Map<String, SamplingConfiguration> indexToSamplingConfigMap) {
            this.indexToSamplingConfigMap = indexToSamplingConfigMap;
        }

        public Response(StreamInput in) throws IOException {
            this.indexToSamplingConfigMap = in.readMap(StreamInput::readString, SamplingConfiguration::new);
        }

        public Map<String, SamplingConfiguration> getIndexToSamplingConfigMap() {
            return this.indexToSamplingConfigMap == null ? Map.of() : this.indexToSamplingConfigMap;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.indexToSamplingConfigMap, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return this.indexToSamplingConfigMap.equals(that.indexToSamplingConfigMap);
        }

        public int hashCode() {
            return Objects.hash(this.indexToSamplingConfigMap);
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Collections.singletonList((builder, p) -> this.toXContent(builder, params)).iterator();
        }

        private XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().startArray("configurations");
            for (Map.Entry<String, SamplingConfiguration> entry : this.indexToSamplingConfigMap.entrySet()) {
                builder.startObject();
                builder.field("index", entry.getKey());
                builder.field("configuration", (ToXContent)entry.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends LocalClusterStateRequest
    implements IndicesRequest.Replaceable {
        public Request(@Nullable TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String[] indices() {
            return new String[]{"*"};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.LENIENT_EXPAND_OPEN;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public Request indices(String ... indices) {
            return this;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "executing " + action, parentTaskId, headers);
        }
    }
}

