/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.cancel;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;

public class CancelTasksRequest
extends BaseTasksRequest<CancelTasksRequest> {
    public static final String DEFAULT_REASON = "by user request";
    public static final boolean DEFAULT_WAIT_FOR_COMPLETION = false;
    private String reason = "by user request";
    private boolean waitForCompletion = false;

    public CancelTasksRequest() {
    }

    public CancelTasksRequest(StreamInput in) throws IOException {
        super(in);
        this.reason = in.readString();
        this.waitForCompletion = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.reason);
        out.writeBoolean(this.waitForCompletion);
    }

    @Override
    public boolean match(Task task) {
        return super.match(task) && task instanceof CancellableTask;
    }

    public CancelTasksRequest setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public String getDescription() {
        return "reason[" + this.reason + "], waitForCompletion[" + this.waitForCompletion + "], targetTaskId[" + String.valueOf(this.getTargetTaskId()) + "], targetParentTaskId[" + String.valueOf(this.getTargetParentTaskId()) + "], nodes" + Arrays.toString(this.getNodes()) + ", actions" + Arrays.toString(this.getActions());
    }
}

