/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.ojalgo.machine.JavaType;

public final class MemoryEstimator {
    private static final long FINAL_ALIGNEMENT = 8L;
    private static final long PARENT_ALIGNEMENT = 4L;
    private static final long WORD = 8L;
    private static final long ZERO = 0L;
    private long myShallowSize = 0L;

    public static long estimateArray(Class<?> aComponentType, int aLength) {
        MemoryEstimator tmpEstimator = MemoryEstimator.makeForClassExtendingObject();
        tmpEstimator.add(JavaType.INT.memory());
        tmpEstimator.add((long)aLength * JavaType.match(aComponentType).memory());
        return tmpEstimator.estimate();
    }

    public static long estimateObject(Class<?> aType) {
        return MemoryEstimator.make(aType).estimate();
    }

    public static MemoryEstimator makeForClassExtendingObject() {
        return new MemoryEstimator(8L + JavaType.REFERENCE.memory());
    }

    public static MemoryEstimator makeForSubclass(MemoryEstimator aParentEstimation) {
        return new MemoryEstimator(aParentEstimation.align(4L));
    }

    static MemoryEstimator make(Class<?> aClass) {
        MemoryEstimator retVal = null;
        Class<?> tmpParent = aClass.getSuperclass();
        if (Object.class.equals(tmpParent)) {
            retVal = MemoryEstimator.makeForClassExtendingObject();
        } else {
            MemoryEstimator tmpParentEstimation = MemoryEstimator.make(tmpParent);
            retVal = MemoryEstimator.makeForSubclass(tmpParentEstimation);
        }
        for (Field tmpField : aClass.getDeclaredFields()) {
            int tmpModifier = tmpField.getModifiers();
            if (Modifier.isStatic(tmpModifier)) continue;
            Class<?> tmpType = tmpField.getType();
            retVal.add(JavaType.match(tmpType));
        }
        return retVal;
    }

    private MemoryEstimator() {
        this(0L);
    }

    MemoryEstimator(long aBase) {
        this.myShallowSize = aBase;
    }

    public MemoryEstimator add(Class<?> aClass) {
        return this.add(JavaType.match(aClass));
    }

    public MemoryEstimator add(JavaType aJavaType) {
        return this.add(aJavaType.memory());
    }

    public long estimate() {
        return this.align(8L);
    }

    private MemoryEstimator add(long someMemory) {
        this.myShallowSize += someMemory;
        return this;
    }

    private long align(long alignement) {
        long tmpRemainder = this.myShallowSize % alignement;
        if (tmpRemainder != 0L) {
            return this.myShallowSize + (alignement - tmpRemainder);
        }
        return this.myShallowSize;
    }
}

