/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.SearchApplicationTemplateService;
import org.elasticsearch.xpack.application.search.action.RenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.application.search.action.SearchApplicationSearchRequest;

public class TransportRenderSearchApplicationQueryAction
extends HandledTransportAction<SearchApplicationSearchRequest, RenderSearchApplicationQueryAction.Response> {
    protected final SearchApplicationIndexService systemIndexService;
    private final SearchApplicationTemplateService templateService;

    @Inject
    public TransportRenderSearchApplicationQueryAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, BigArrays bigArrays, ScriptService scriptService, NamedXContentRegistry xContentRegistry, FeatureService featureService) {
        super("cluster:admin/xpack/application/search_application/render_query", transportService, actionFilters, SearchApplicationSearchRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new SearchApplicationIndexService(client, clusterService, namedWriteableRegistry, bigArrays);
        Predicate<NodeFeature> clusterSupportsFeature = f -> {
            ClusterState state = clusterService.state();
            return state.clusterRecovered() && featureService.clusterHasFeature(state, f);
        };
        this.templateService = new SearchApplicationTemplateService(scriptService, xContentRegistry, clusterSupportsFeature);
    }

    protected void doExecute(Task task, SearchApplicationSearchRequest request, ActionListener<RenderSearchApplicationQueryAction.Response> listener) {
        this.systemIndexService.getSearchApplication(request.name(), (ActionListener<SearchApplication>)listener.delegateFailureAndWrap((delegate, searchApplication) -> {
            Map<String, Object> renderedMetadata = this.templateService.renderTemplate((SearchApplication)searchApplication, request.queryParams());
            SearchSourceBuilder sourceBuilder = this.templateService.renderQuery((SearchApplication)searchApplication, renderedMetadata);
            delegate.onResponse((Object)new RenderSearchApplicationQueryAction.Response(sourceBuilder));
        }));
    }
}

