/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.stateless;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.plugins.ClusterCoordinationPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StatelessPlugin
extends Plugin
implements ClusterCoordinationPlugin,
ExtensiblePlugin {
    private static final Logger logger = LogManager.getLogger(StatelessPlugin.class);
    public static final LicensedFeature.Persistent STATELESS_FEATURE = LicensedFeature.persistent(null, (String)"stateless", (License.OperationMode)License.OperationMode.ENTERPRISE);
    public static final Setting<Boolean> STATELESS_ENABLED = Setting.boolSetting((String)"stateless.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Set<DiscoveryNodeRole> STATELESS_ROLES = Set.of(DiscoveryNodeRole.INDEX_ROLE, DiscoveryNodeRole.SEARCH_ROLE);
    public static final String NAME = "stateless";
    private final boolean enabled;

    public List<Setting<?>> getSettings() {
        return List.of(STATELESS_ENABLED);
    }

    public StatelessPlugin(Settings settings) {
        this.enabled = (Boolean)STATELESS_ENABLED.get(settings);
        if (this.enabled) {
            Set nonStatelessDataNodeRoles = ((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream().filter(r -> r.canContainData() && !STATELESS_ROLES.contains(r)).map(DiscoveryNodeRole::roleName).collect(Collectors.toSet());
            if (!nonStatelessDataNodeRoles.isEmpty()) {
                throw new IllegalArgumentException("stateless does not support node roles " + String.valueOf(nonStatelessDataNodeRoles));
            }
            Set statelessDataNodeRoles = ((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream().filter(STATELESS_ROLES::contains).map(DiscoveryNodeRole::roleName).collect(Collectors.toSet());
            if (statelessDataNodeRoles.size() > 1) {
                throw new IllegalArgumentException("stateless does not support a node with more than 1 role of " + String.valueOf(statelessDataNodeRoles));
            }
            if (DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.exists(settings) && ((Boolean)DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.get(settings)).booleanValue()) {
                throw new IllegalArgumentException("stateless does not support " + DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.getKey());
            }
            if (!Objects.equals(ClusterModule.SHARDS_ALLOCATOR_TYPE_SETTING.get(settings), "desired_balance")) {
                throw new IllegalArgumentException("stateless can only be used with " + ClusterModule.SHARDS_ALLOCATOR_TYPE_SETTING.getKey() + "=desired_balance");
            }
            logger.info("[{}] is enabled", new Object[]{NAME});
        } else {
            Set statelessDataNodeRoles = ((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream().filter(r -> r.canContainData() && STATELESS_ROLES.contains(r)).map(DiscoveryNodeRole::roleName).collect(Collectors.toSet());
            if (!statelessDataNodeRoles.isEmpty()) {
                throw new IllegalArgumentException("stateless is not enabled, but stateless-only node roles are configured: " + String.valueOf(statelessDataNodeRoles));
            }
        }
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        XPackLicenseState licenseState;
        if (this.enabled && !STATELESS_FEATURE.checkAndStartTracking(licenseState = this.getLicenseState(), NAME)) {
            throw new IllegalStateException("stateless cannot be enabled with a [" + String.valueOf(licenseState.getOperationMode()) + "] license. It is only allowed with an Enterprise license.");
        }
        return Collections.emptyList();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public Settings additionalSettings() {
        if (this.enabled) {
            return Settings.builder().put(super.additionalSettings()).put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_THRESHOLD_ENABLED_SETTING.getKey(), false).build();
        }
        return super.additionalSettings();
    }

    public void close() throws IOException {
        super.close();
        if (this.enabled) {
            STATELESS_FEATURE.stopTracking(this.getLicenseState(), NAME);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

