/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Code;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.DefaultMustache;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.codes.WriteCode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.script.mustache.CustomReflectionObjectHandler;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonStringEncoder;

public final class CustomMustacheFactory
extends DefaultMustacheFactory {
    static final String V7_JSON_MEDIA_TYPE_WITH_CHARSET = "application/json; charset=UTF-8";
    static final String JSON_MEDIA_TYPE_WITH_CHARSET = "application/json;charset=utf-8";
    static final String JSON_MEDIA_TYPE = "application/json";
    static final String PLAIN_TEXT_MEDIA_TYPE = "text/plain";
    static final String X_WWW_FORM_URLENCODED_MEDIA_TYPE = "application/x-www-form-urlencoded";
    private static final String DEFAULT_MEDIA_TYPE = "application/json";
    private static final boolean DEFAULT_DETECT_MISSING_PARAMS = false;
    private static final Map<String, Supplier<Encoder>> ENCODERS = Map.of("application/json; charset=UTF-8", JsonEscapeEncoder::new, "application/json;charset=utf-8", JsonEscapeEncoder::new, "application/json", JsonEscapeEncoder::new, "text/plain", DefaultEncoder::new, "application/x-www-form-urlencoded", UrlEncoder::new);
    private final Encoder encoder;

    @Deprecated
    public CustomMustacheFactory(String mediaType) {
        this(mediaType, false);
    }

    @Deprecated
    public CustomMustacheFactory() {
        this("application/json", false);
    }

    private CustomMustacheFactory(String mediaType, boolean detectMissingParams) {
        super(resourceName -> null);
        this.setObjectHandler((ObjectHandler)new CustomReflectionObjectHandler(detectMissingParams));
        this.encoder = CustomMustacheFactory.createEncoder(mediaType);
    }

    public void encode(String value, Writer writer) {
        try {
            this.encoder.encode(value, writer);
        }
        catch (IOException e) {
            throw new MustacheException("Unable to encode value", (Throwable)e);
        }
    }

    static Encoder createEncoder(String mediaType) {
        Supplier<Encoder> supplier = ENCODERS.get(mediaType);
        if (supplier == null) {
            throw new IllegalArgumentException("No encoder found for media type [" + mediaType + "]");
        }
        return supplier.get();
    }

    public MustacheVisitor createMustacheVisitor() {
        return new CustomMustacheVisitor(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @FunctionalInterface
    static interface Encoder {
        public void encode(String var1, Writer var2) throws IOException;
    }

    private static class CustomMustacheVisitor
    extends DefaultMustacheVisitor {
        CustomMustacheVisitor(DefaultMustacheFactory df) {
            super(df);
        }

        public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
            if (ToJsonCode.match(variable)) {
                this.list.add(new ToJsonCode(templateContext, this.df, mustache, variable));
            } else if (JoinerCode.match(variable)) {
                this.list.add(new JoinerCode(templateContext, this.df, mustache));
            } else if (CustomJoinerCode.match(variable)) {
                this.list.add(new CustomJoinerCode(templateContext, this.df, mustache, variable));
            } else if (UrlEncoderCode.match(variable)) {
                this.list.add(new UrlEncoderCode(templateContext, this.df, mustache, variable));
            } else {
                this.list.add(new IterableCode(templateContext, this.df, mustache, variable));
            }
        }

        public void partial(TemplateContext tc, String variable, String indent) {
            throw new MustacheException(Strings.format((String)"Cannot expand '%s' because partial templates are not supported", (Object[])new Object[]{variable}));
        }

        public void dynamicPartial(TemplateContext tc, String variable, String indent) {
            throw new MustacheException(Strings.format((String)"Cannot expand '%s' because dynamic partial templates are not supported", (Object[])new Object[]{variable}));
        }
    }

    public static class Builder {
        private String mediaType = "application/json";
        private boolean detectMissingParams = false;

        private Builder() {
        }

        public Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder detectMissingParams(boolean detectMissingParams) {
            this.detectMissingParams = detectMissingParams;
            return this;
        }

        public CustomMustacheFactory build() {
            return new CustomMustacheFactory(this.mediaType, this.detectMissingParams);
        }
    }

    static class UrlEncoder
    implements Encoder {
        UrlEncoder() {
        }

        @Override
        public void encode(String s, Writer writer) throws IOException {
            writer.write(URLEncoder.encode(s, StandardCharsets.UTF_8));
        }
    }

    static class JsonEscapeEncoder
    implements Encoder {
        JsonEscapeEncoder() {
        }

        @Override
        public void encode(String s, Writer writer) throws IOException {
            writer.write(JsonStringEncoder.getInstance().quoteAsString(s));
        }
    }

    static class DefaultEncoder
    implements Encoder {
        DefaultEncoder() {
        }

        @Override
        public void encode(String s, Writer writer) throws IOException {
            writer.write(s);
        }
    }

    private static class UrlEncoderCode
    extends DefaultMustache {
        private static final String CODE = "url";
        private final Encoder encoder = new UrlEncoder();

        UrlEncoderCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache.getCodes(), variable);
        }

        public Writer run(Writer writer, List<Object> scopes) {
            if (this.getCodes() != null) {
                for (Code code : this.getCodes()) {
                    try (StringWriter capture = new StringWriter();){
                        code.execute((Writer)capture, scopes);
                        String s = capture.toString();
                        if (s == null) continue;
                        this.encoder.encode(s, writer);
                    }
                    catch (IOException e) {
                        throw new MustacheException("Exception while parsing mustache function at line " + this.tc.line(), (Throwable)e);
                    }
                }
            }
            return writer;
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    private static class CustomJoinerCode
    extends JoinerCode {
        private static final Pattern PATTERN = Pattern.compile("^join delimiter='(.*)'$");

        CustomJoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache, CustomJoinerCode.extractDelimiter(variable));
        }

        private static String extractDelimiter(String variable) {
            Matcher matcher = PATTERN.matcher(variable);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new MustacheException("Failed to extract delimiter for join function");
        }

        static boolean match(String variable) {
            return PATTERN.matcher(variable).matches();
        }
    }

    private static class JoinerCode
    extends CustomCode {
        protected static final String CODE = "join";
        private static final String DEFAULT_DELIMITER = ",";
        private final String delimiter;

        JoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String delimiter) {
            super(tc, df, mustache, CODE);
            this.delimiter = delimiter;
        }

        JoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache) {
            this(tc, df, mustache, DEFAULT_DELIMITER);
        }

        @Override
        protected Function<String, String> createFunction(Object resolved) {
            return s -> {
                if (s == null) {
                    return null;
                }
                if (resolved instanceof Iterable) {
                    StringJoiner joiner = new StringJoiner(this.delimiter);
                    for (Object o : (Iterable)resolved) {
                        joiner.add(this.oh.stringify(o));
                    }
                    return joiner.toString();
                }
                return s;
            };
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    private static class ToJsonCode
    extends CustomCode {
        private static final String CODE = "toJson";

        ToJsonCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache, CODE);
            if (!CODE.equalsIgnoreCase(variable)) {
                throw new MustacheException("Mismatch function code [toJson] cannot be applied to [" + variable + "]");
            }
        }

        @Override
        protected Function<String, String> createFunction(Object resolved) {
            return s -> {
                if (resolved == null) {
                    return null;
                }
                try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
                    if (resolved instanceof Iterable) {
                        builder.startArray();
                        for (Object o : (Iterable)resolved) {
                            builder.value(o);
                        }
                        builder.endArray();
                    } else {
                        if (!(resolved instanceof Map)) {
                            String string2 = this.oh.stringify(resolved);
                            return string2;
                        }
                        builder.map((Map)resolved);
                    }
                    String string = Strings.toString((XContentBuilder)builder);
                    return string;
                }
                catch (IOException e) {
                    throw new MustacheException("Failed to convert object to JSON", (Throwable)e);
                }
            };
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    private static abstract class CustomCode
    extends IterableCode {
        private final String code;

        CustomCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String code) {
            super(tc, df, mustache, CustomCode.extractVariableName(code, mustache, tc));
            this.code = Objects.requireNonNull(code);
        }

        public Writer execute(Writer writer, List<Object> scopes) {
            Object resolved = this.get(scopes);
            writer = this.handle(writer, this.createFunction(resolved), scopes);
            this.appendText(writer);
            return writer;
        }

        protected void tag(Writer writer, String tag) throws IOException {
            writer.write(this.tc.startChars());
            writer.write(tag);
            writer.write(this.code);
            writer.write(this.tc.endChars());
        }

        protected abstract Function<String, String> createFunction(Object var1);

        protected static String extractVariableName(String fn, Mustache mustache, TemplateContext tc) {
            String string;
            Code[] codes = mustache.getCodes();
            if (codes == null || codes.length != 1) {
                throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
            }
            StringWriter capture = new StringWriter();
            try {
                if (codes[0] instanceof WriteCode) {
                    codes[0].execute((Writer)capture, List.of());
                } else {
                    codes[0].identity((Writer)capture);
                }
                string = capture.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        capture.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MustacheException("Exception while parsing mustache function [" + fn + "] at line " + tc.line(), (Throwable)e);
                }
            }
            capture.close();
            return string;
        }
    }
}

