/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.reindex.ReindexMetrics;
import org.elasticsearch.reindex.ReindexSslConfig;
import org.elasticsearch.reindex.ReindexValidator;
import org.elasticsearch.reindex.Reindexer;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportReindexAction
extends HandledTransportAction<ReindexRequest, BulkByScrollResponse> {
    public static final Setting<List<String>> REMOTE_CLUSTER_WHITELIST = Setting.stringListSetting((String)"reindex.remote.whitelist", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    protected final ReindexValidator reindexValidator;
    private final Reindexer reindexer;
    protected final Client client;

    @Inject
    public TransportReindexAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, ReindexSslConfig sslConfig, @Nullable ReindexMetrics reindexMetrics) {
        this("indices:data/write/reindex", settings, threadPool, actionFilters, indexNameExpressionResolver, projectResolver, clusterService, scriptService, autoCreateIndex, client, transportService, sslConfig, reindexMetrics);
    }

    protected TransportReindexAction(String name, Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ProjectResolver projectResolver, ClusterService clusterService, ScriptService scriptService, AutoCreateIndex autoCreateIndex, Client client, TransportService transportService, ReindexSslConfig sslConfig, @Nullable ReindexMetrics reindexMetrics) {
        super(name, transportService, actionFilters, ReindexRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.reindexValidator = new ReindexValidator(settings, clusterService, indexNameExpressionResolver, projectResolver, autoCreateIndex);
        this.reindexer = new Reindexer(clusterService, projectResolver, client, threadPool, scriptService, sslConfig, reindexMetrics);
    }

    protected void doExecute(Task task, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
        this.validate(request);
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        this.reindexer.initTask(bulkByScrollTask, request, (ActionListener<Void>)listener.delegateFailure((l, v) -> this.reindexer.execute(bulkByScrollTask, request, this.getBulkClient(), (ActionListener<BulkByScrollResponse>)l)));
    }

    protected Client getBulkClient() {
        return this.client;
    }

    protected void validate(ReindexRequest request) {
        this.reindexValidator.initialValidation(request);
    }
}

