/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextExpansionConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TextExpansionConfig
implements NlpConfig {
    public static final String NAME = "text_expansion";
    private static final ConstructingObjectParser<TextExpansionConfig, Void> STRICT_PARSER = TextExpansionConfig.createParser(false);
    private static final ConstructingObjectParser<TextExpansionConfig, Void> LENIENT_PARSER = TextExpansionConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final String resultsField;

    public static TextExpansionConfig fromXContentStrict(XContentParser parser) {
        return (TextExpansionConfig)STRICT_PARSER.apply(parser, null);
    }

    public static TextExpansionConfig fromXContentLenient(XContentParser parser) {
        return (TextExpansionConfig)LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<TextExpansionConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new TextExpansionConfig((VocabularyConfig)a[0], (Tokenization)a[1], (String)a[2]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        return parser;
    }

    public TextExpansionConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable String resultsField) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        this.resultsField = resultsField;
    }

    public TextExpansionConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.resultsField = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeOptionalString(this.resultsField);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public InferenceConfig apply(InferenceConfigUpdate update) {
        if (update instanceof TextExpansionConfigUpdate) {
            TextExpansionConfigUpdate configUpdate = (TextExpansionConfigUpdate)update;
            return new TextExpansionConfig(this.vocabularyConfig, configUpdate.tokenizationUpdate == null ? this.tokenization : configUpdate.tokenizationUpdate.apply(this.tokenization), Optional.ofNullable(configUpdate.getResultsField()).orElse(this.resultsField));
        }
        if (update instanceof TokenizationConfigUpdate) {
            TokenizationConfigUpdate tokenizationUpdate = (TokenizationConfigUpdate)update;
            Tokenization updatedTokenization = this.getTokenization().updateWindowSettings(tokenizationUpdate.getSpanSettings());
            return new TextExpansionConfig(this.vocabularyConfig, updatedTokenization, this.resultsField);
        }
        throw this.incompatibleUpdateException(update.getName());
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_7_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersion.minimumCompatible();
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextExpansionConfig that = (TextExpansionConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.resultsField);
    }
}

