/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.aggregations.bucket.adjacency.AdjacencyMatrixAggregationBuilder;
import org.elasticsearch.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.elasticsearch.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.elasticsearch.aggregations.bucket.timeseries.InternalTimeSeries;
import org.elasticsearch.aggregations.bucket.timeseries.TimeSeriesAggregationBuilder;
import org.elasticsearch.aggregations.metric.InternalMatrixStats;
import org.elasticsearch.aggregations.metric.MatrixStatsAggregationBuilder;
import org.elasticsearch.aggregations.metric.MatrixStatsParser;
import org.elasticsearch.aggregations.pipeline.BucketSelectorPipelineAggregationBuilder;
import org.elasticsearch.aggregations.pipeline.BucketSortPipelineAggregationBuilder;
import org.elasticsearch.aggregations.pipeline.Derivative;
import org.elasticsearch.aggregations.pipeline.DerivativePipelineAggregationBuilder;
import org.elasticsearch.aggregations.pipeline.MovFnPipelineAggregationBuilder;
import org.elasticsearch.aggregations.pipeline.MovingFunctionScript;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregator;

public class AggregationsPlugin
extends Plugin
implements SearchPlugin,
ScriptPlugin {
    public List<SearchPlugin.AggregationSpec> getAggregations() {
        ArrayList<SearchPlugin.AggregationSpec> specs = new ArrayList<SearchPlugin.AggregationSpec>();
        specs.add(new SearchPlugin.AggregationSpec("adjacency_matrix", AdjacencyMatrixAggregationBuilder::new, AdjacencyMatrixAggregationBuilder::parse).addResultReader(InternalAdjacencyMatrix::new));
        specs.add(new SearchPlugin.AggregationSpec("auto_date_histogram", AutoDateHistogramAggregationBuilder::new, AutoDateHistogramAggregationBuilder.PARSER).addResultReader(InternalAutoDateHistogram::new).setAggregatorRegistrar(AutoDateHistogramAggregationBuilder::registerAggregators));
        specs.add(new SearchPlugin.AggregationSpec("matrix_stats", MatrixStatsAggregationBuilder::new, (Aggregator.Parser)new MatrixStatsParser()).addResultReader(InternalMatrixStats::new));
        specs.add(new SearchPlugin.AggregationSpec("time_series", TimeSeriesAggregationBuilder::new, TimeSeriesAggregationBuilder.PARSER).addResultReader(InternalTimeSeries::new));
        return List.copyOf(specs);
    }

    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        return List.of(new SearchPlugin.PipelineAggregationSpec("bucket_selector", BucketSelectorPipelineAggregationBuilder::new, BucketSelectorPipelineAggregationBuilder::parse), new SearchPlugin.PipelineAggregationSpec("bucket_sort", BucketSortPipelineAggregationBuilder::new, BucketSortPipelineAggregationBuilder::parse), new SearchPlugin.PipelineAggregationSpec("derivative", DerivativePipelineAggregationBuilder::new, DerivativePipelineAggregationBuilder::parse).addResultReader(Derivative::new), new SearchPlugin.PipelineAggregationSpec("moving_fn", MovFnPipelineAggregationBuilder::new, MovFnPipelineAggregationBuilder.PARSER));
    }

    public List<ScriptContext<?>> getContexts() {
        return List.of(MovingFunctionScript.CONTEXT);
    }
}

