/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public final class ClampMinBytesRefEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMinBytesRefEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator min;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMinBytesRefEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator min, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.min = min;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock fieldBlock = (BytesRefBlock)this.field.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector minVector;
                BytesRefVector fieldVector;
                BytesRefBlock minBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                minBlock = (BytesRefBlock)this.min.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                                    if (minBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (minBlock != null) {
                                        try {
                                            minBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                minBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        minVector = minBlock.asVector();
                        if (minVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                        if (minBlock == null) break block19;
                        minBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), fieldVector, minVector).asBlock();
                if (minBlock == null) break block20;
                minBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.min.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock fieldBlock, BytesRefBlock minBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef fieldScratch = new BytesRef();
            BytesRef minScratch = new BytesRef();
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (minBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                BytesRef field = fieldBlock.getBytesRef(fieldBlock.getFirstValueIndex(p), fieldScratch);
                BytesRef min = minBlock.getBytesRef(minBlock.getFirstValueIndex(p), minScratch);
                result.appendBytesRef(ClampMin.process(field, min));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector fieldVector, BytesRefVector minVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef fieldScratch = new BytesRef();
            BytesRef minScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef field = fieldVector.getBytesRef(p, fieldScratch);
                BytesRef min = minVector.getBytesRef(p, minScratch);
                result.appendBytesRef(ClampMin.process(field, min));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "ClampMinBytesRefEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.min});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory min;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory min) {
            this.source = source;
            this.field = field;
            this.min = min;
        }

        public ClampMinBytesRefEvaluator get(DriverContext context) {
            return new ClampMinBytesRefEvaluator(this.source, this.field.get(context), this.min.get(context), context);
        }

        public String toString() {
            return "ClampMinBytesRefEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
        }
    }
}

