/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Present;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class PresentOverTime
extends TimeSeriesAggregateFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "PresentOverTime", PresentOverTime::new);

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"boolean"}, description="Calculates the presence of a field in the output result over time range.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="present_over_time")})
    public PresentOverTime(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version", "exponential_histogram"}) Expression field) {
        this(source, field, (Expression)Literal.TRUE, (Expression)NO_WINDOW);
    }

    public PresentOverTime(Source source, Expression field, Expression filter, Expression window) {
        super(source, field, filter, window, Collections.emptyList());
    }

    private PresentOverTime(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return PresentOverTime.ENTRY.name;
    }

    @Override
    public PresentOverTime withFilter(Expression filter) {
        return new PresentOverTime(this.source(), this.field(), filter, this.window());
    }

    protected NodeInfo<PresentOverTime> info() {
        return NodeInfo.create((Node)this, PresentOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)this.window());
    }

    public PresentOverTime replaceChildren(List<Expression> newChildren) {
        return new PresentOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    @Override
    public Present perTimeSeriesAggregation() {
        return new Present(this.source(), this.field(), this.filter(), this.window());
    }
}

