/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtRealmSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.jwt.JwkSetLoader;
import org.elasticsearch.xpack.security.authc.jwt.JwkValidateUtil;
import org.elasticsearch.xpack.security.authc.jwt.JwtUtil;
import org.elasticsearch.xpack.security.authc.jwt.PkcJwkSetReloadNotifier;

public interface JwtSignatureValidator
extends Releasable {
    public static final Logger logger;

    default public void close() {
    }

    public void validate(String var1, SignedJWT var2, ActionListener<Void> var3);

    default public void validateSignature(SignedJWT jwt, List<JWK> jwks) throws Exception {
        if (!1.$assertionsDisabled && jwks == null) {
            throw new AssertionError((Object)"Verify requires a non-null JWK list");
        }
        if (jwks.isEmpty()) {
            throw new ElasticsearchException("Signature verification was not attempted since there are not any JWKs available.", new Object[0]);
        }
        try (JwtUtil.TraceBuffer tracer = new JwtUtil.TraceBuffer(logger);){
            String id = jwt.getHeader().getKeyID();
            JWSAlgorithm alg = jwt.getHeader().getAlgorithm();
            tracer.append("Filtering [{}] possible JWKs to verifying signature for JWT [{}].", jwks.size(), JwtUtil.toStringRedactSignature((JWT)jwt));
            List<JWK> jwksKid = jwks.stream().filter(j -> id == null || j.getKeyID() == null || id.equals(j.getKeyID())).toList();
            tracer.append("[{}] JWKs remain after filtering for KID [{}].", jwksKid.size(), id);
            List<JWK> jwksAlg = jwksKid.stream().filter(j -> j.getAlgorithm() == null || alg.equals((Object)j.getAlgorithm())).toList();
            tracer.append("[{}] algorithms remain after filtering for algorithm name [{}].", jwksAlg.size(), alg.getName());
            List<JWK> jwksConfigured = jwksAlg.stream().filter(j -> JwkValidateUtil.isMatch(j, alg.getName(), tracer)).toList();
            tracer.append("[{}] JWKs remain after filtering for configured algorithms.", jwksConfigured.size());
            tracer.flush();
            if (jwksConfigured.isEmpty()) {
                throw new ElasticsearchException("Signature verification was not attempted since there are not any JWKs available after filtering for incompatible keys.", new Object[0]);
            }
            int attempt = 0;
            int maxAttempts = jwksConfigured.size();
            tracer.append("Attempting to verify signature for JWT [{}] against [{}] possible JWKs.", JwtUtil.toStringRedactSignature((JWT)jwt), maxAttempts);
            for (JWK jwk : jwksConfigured) {
                ++attempt;
                if (jwt.verify(this.createJwsVerifier(jwk))) {
                    tracer.append("Attempt [{}/{}] -> JWT signature verification succeeded with jwk/kid=[{}], jwk/alg=[{}], jwk/kty=[{}], jwk/use=[{}], jwk/key_ops=[{}]", attempt, maxAttempts, jwk.getKeyID(), jwk.getAlgorithm(), jwk.getKeyType(), jwk.getKeyUse(), jwk.getKeyOperations());
                    return;
                }
                tracer.append("Attempt [{}/{}] -> JWT signature verification failed with jwk/kid=[{}], jwk/alg=[{}], jwk/kty=[{}], jwk/use=[{}], jwk/key_ops=[{}]", attempt, maxAttempts, jwk.getKeyID(), jwk.getAlgorithm(), jwk.getKeyType(), jwk.getKeyUse(), jwk.getKeyOperations());
            }
            throw new ElasticsearchException("JWT [" + JwtUtil.toStringRedactSignature((JWT)jwt).get() + "] signature verification failed.", new Object[0]);
        }
    }

    default public JWSVerifier createJwsVerifier(JWK jwk) throws JOSEException {
        if (jwk instanceof RSAKey) {
            RSAKey rsaKey = (RSAKey)jwk;
            return new RSASSAVerifier(rsaKey);
        }
        if (jwk instanceof ECKey) {
            ECKey ecKey = (ECKey)jwk;
            return new ECDSAVerifier(ecKey);
        }
        if (jwk instanceof OctetSequenceKey) {
            OctetSequenceKey octetSequenceKey = (OctetSequenceKey)jwk;
            return new MACVerifier(octetSequenceKey);
        }
        throw new JOSEException("Unsupported JWK class [" + (jwk == null ? "null" : jwk.getClass().getCanonicalName()) + "]. Supported classes are [" + RSAKey.class.getCanonicalName() + ", " + ECKey.class.getCanonicalName() + ", " + OctetSequenceKey.class.getCanonicalName() + "].");
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        logger = LogManager.getLogger(JwtSignatureValidator.class);
    }

    public static class PkcJwtSignatureValidator
    implements JwtSignatureValidator {
        private static final Logger logger = LogManager.getLogger(PkcJwtSignatureValidator.class);
        private final JwkSetLoader jwkSetLoader;

        PkcJwtSignatureValidator(JwkSetLoader jwkSetLoader) {
            this.jwkSetLoader = jwkSetLoader;
        }

        @Override
        public void validate(String tokenPrincipal, SignedJWT signedJWT, ActionListener<Void> listener) {
            JwkSetLoader.ContentAndJwksAlgs contentAndJwksAlgs = this.jwkSetLoader.getContentAndJwksAlgs();
            assert (contentAndJwksAlgs != null);
            JwkSetLoader.JwksAlgs jwksAlgs = contentAndJwksAlgs.jwksAlgs();
            byte[] initialJwksVersion = contentAndJwksAlgs.sha256();
            try {
                this.validateSignature(signedJWT, jwksAlgs.jwks());
                listener.onResponse(null);
            }
            catch (Exception primaryException) {
                String message = Strings.format((String)"Signature verification failed for JWT token [%s] against JWK set with sha256=[%s].", (Object[])new Object[]{tokenPrincipal, MessageDigests.toHexString((byte[])contentAndJwksAlgs.sha256())});
                if (logger.isTraceEnabled()) {
                    logger.trace(message, (Throwable)primaryException);
                } else {
                    logger.debug(message + " Cause: " + primaryException.getMessage());
                }
                logger.debug("Attempting to reload JWK set with sha256=[{}]", (Object)MessageDigests.toHexString((byte[])contentAndJwksAlgs.sha256()));
                this.jwkSetLoader.reload((ActionListener<Void>)ActionListener.wrap(ignore -> {
                    JwkSetLoader.ContentAndJwksAlgs maybeUpdatedContentAndJwksAlgs = this.jwkSetLoader.getContentAndJwksAlgs();
                    if (Arrays.equals(maybeUpdatedContentAndJwksAlgs.sha256(), initialJwksVersion)) {
                        logger.debug("No change in reloaded JWK set with sha256=[{}] will not retry signature verification", (Object)MessageDigests.toHexString((byte[])maybeUpdatedContentAndJwksAlgs.sha256()));
                        listener.onFailure(primaryException);
                        return;
                    }
                    logger.debug("Successful reload of JWK set. Now with sha256=[{}]", (Object)MessageDigests.toHexString((byte[])maybeUpdatedContentAndJwksAlgs.sha256()));
                    try {
                        JwkSetLoader.JwksAlgs updatedJwksAlgs = maybeUpdatedContentAndJwksAlgs.jwksAlgs();
                        this.validateSignature(signedJWT, updatedJwksAlgs.jwks());
                        listener.onResponse(null);
                    }
                    catch (Exception secondaryException) {
                        logger.debug("Signature verification of JWT [{}] failed - original failure: [{}], failure after reload: [{}]", (Object)tokenPrincipal, (Object)primaryException.getMessage(), (Object)secondaryException.getMessage());
                        secondaryException.addSuppressed(primaryException);
                        listener.onFailure(secondaryException);
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }

        @Override
        public void close() {
            this.jwkSetLoader.close();
        }
    }

    public static class HmacJwtSignatureValidator
    implements JwtSignatureValidator {
        private final JwkSetLoader.JwksAlgs jwksAlgs;

        HmacJwtSignatureValidator(JwkSetLoader.JwksAlgs jwksAlgs) {
            this.jwksAlgs = jwksAlgs;
        }

        @Override
        public void validate(String tokenPrincipal, SignedJWT jwt, ActionListener<Void> listener) {
            try {
                this.validateSignature(jwt, this.jwksAlgs.jwks());
                listener.onResponse(null);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    public static class DelegatingJwtSignatureValidator
    implements JwtSignatureValidator {
        private static final Logger logger = LogManager.getLogger(DelegatingJwtSignatureValidator.class);
        private final RealmConfig realmConfig;
        final List<String> allowedJwksAlgsPkc;
        final List<String> allowedJwksAlgsHmac;
        @Nullable
        private final HmacJwtSignatureValidator hmacJwtSignatureValidator;
        @Nullable
        private final PkcJwtSignatureValidator pkcJwtSignatureValidator;

        public DelegatingJwtSignatureValidator(RealmConfig realmConfig, SSLService sslService, PkcJwkSetReloadNotifier reloadNotifier, ThreadPool threadPool) {
            List<JWK> jwksHmac;
            this.realmConfig = realmConfig;
            List algs = (List)realmConfig.getSetting(JwtRealmSettings.ALLOWED_SIGNATURE_ALGORITHMS);
            this.allowedJwksAlgsHmac = algs.stream().filter(JwtRealmSettings.SUPPORTED_SIGNATURE_ALGORITHMS_HMAC::contains).toList();
            this.allowedJwksAlgsPkc = algs.stream().filter(JwtRealmSettings.SUPPORTED_SIGNATURE_ALGORITHMS_PKC::contains).toList();
            String jwkSetPath = (String)realmConfig.getSetting(JwtRealmSettings.PKC_JWKSET_PATH);
            SecureString hmacJwkSetContents = (SecureString)realmConfig.getSetting(JwtRealmSettings.HMAC_JWKSET);
            SecureString hmacKeyContents = (SecureString)realmConfig.getSetting(JwtRealmSettings.HMAC_KEY);
            boolean isConfiguredJwkSetPkc = org.elasticsearch.common.Strings.hasText((String)jwkSetPath);
            boolean isConfiguredJwkSetHmac = org.elasticsearch.common.Strings.hasText((CharSequence)hmacJwkSetContents);
            boolean isConfiguredJwkOidcHmac = org.elasticsearch.common.Strings.hasText((CharSequence)hmacKeyContents);
            DelegatingJwtSignatureValidator.validateJwkSettings(realmConfig, isConfiguredJwkSetPkc, isConfiguredJwkSetHmac, isConfiguredJwkOidcHmac);
            if (isConfiguredJwkSetHmac) {
                jwksHmac = JwkValidateUtil.loadJwksFromJwkSetString(RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET), hmacJwkSetContents.toString());
            } else if (isConfiguredJwkOidcHmac) {
                OctetSequenceKey hmacKey = JwkValidateUtil.loadHmacJwkFromJwkString(RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY), (CharSequence)hmacKeyContents);
                assert (hmacKey != null) : "Null HMAC key should not happen here";
                jwksHmac = List.of(hmacKey);
            } else {
                jwksHmac = null;
            }
            if (jwksHmac != null) {
                JwkSetLoader.JwksAlgs jwksAlgs = JwkValidateUtil.filterJwksAndAlgorithms(jwksHmac, this.allowedJwksAlgsHmac);
                logger.info("Usable HMAC: JWKs [{}]. Algorithms [{}].", (Object)jwksAlgs.jwks().size(), (Object)String.join((CharSequence)",", jwksAlgs.algs()));
                this.hmacJwtSignatureValidator = new HmacJwtSignatureValidator(jwksAlgs);
            } else {
                this.hmacJwtSignatureValidator = null;
            }
            this.pkcJwtSignatureValidator = isConfiguredJwkSetPkc ? new PkcJwtSignatureValidator(new JwkSetLoader(realmConfig, this.allowedJwksAlgsPkc, sslService, threadPool, reloadNotifier)) : null;
            this.logWarnIfAuthenticationWillAlwaysFail();
        }

        @Override
        public void validate(String tokenPrincipal, SignedJWT jwt, ActionListener<Void> listener) {
            String algorithm = jwt.getHeader().getAlgorithm().getName();
            if (this.allowedJwksAlgsHmac.contains(algorithm)) {
                if (this.hmacJwtSignatureValidator != null) {
                    this.hmacJwtSignatureValidator.validate(tokenPrincipal, jwt, listener);
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("algorithm [%s] is a HMAC signing algorithm, but none of the HMAC JWK settings [" + RealmSettings.getFullSettingKey((RealmConfig)this.realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY) + ", " + RealmSettings.getFullSettingKey((RealmConfig)this.realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET) + "] is configured", RestStatus.BAD_REQUEST, new Object[]{algorithm})));
                }
            } else if (this.allowedJwksAlgsPkc.contains(algorithm)) {
                if (this.pkcJwtSignatureValidator != null) {
                    this.pkcJwtSignatureValidator.validate(tokenPrincipal, jwt, listener);
                } else {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("algorithm [%s] is a PKC signing algorithm, but PKC JWK setting [" + RealmSettings.getFullSettingKey((RealmConfig)this.realmConfig, (Setting.AffixSetting)JwtRealmSettings.PKC_JWKSET_PATH) + "] is not configured", RestStatus.BAD_REQUEST, new Object[]{algorithm})));
                }
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("algorithm [%s] is not in the list of supported algorithms [%s]", RestStatus.BAD_REQUEST, new Object[]{algorithm, org.elasticsearch.common.Strings.collectionToCommaDelimitedString(Stream.of(this.allowedJwksAlgsHmac.stream(), this.allowedJwksAlgsPkc.stream()).toList())})));
            }
        }

        @Override
        public void close() {
            if (this.pkcJwtSignatureValidator != null) {
                this.pkcJwtSignatureValidator.close();
            }
        }

        private void logWarnIfAuthenticationWillAlwaysFail() {
            boolean hasUsableJwksAndAlgorithms;
            boolean bl = hasUsableJwksAndAlgorithms = this.hmacJwtSignatureValidator != null && false == this.hmacJwtSignatureValidator.jwksAlgs.isEmpty() || this.pkcJwtSignatureValidator != null && false == this.pkcJwtSignatureValidator.jwkSetLoader.getContentAndJwksAlgs().jwksAlgs().isEmpty();
            if (!hasUsableJwksAndAlgorithms) {
                logger.warn("No available JWK and algorithm for HMAC or PKC. JWT realm authentication expected to fail until this is fixed.");
            }
        }

        private static void validateJwkSettings(RealmConfig realmConfig, boolean isConfiguredJwkSetPkc, boolean isConfiguredJwkSetHmac, boolean isConfiguredJwkOidcHmac) {
            if (!(isConfiguredJwkSetPkc || isConfiguredJwkSetHmac || isConfiguredJwkOidcHmac)) {
                throw new SettingsException("At least one of [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY) + "] or [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET) + "] or [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.PKC_JWKSET_PATH) + "] must be set");
            }
            if (isConfiguredJwkSetHmac && isConfiguredJwkOidcHmac) {
                throw new SettingsException("Settings [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_JWKSET) + "] and [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.HMAC_KEY) + "] are not allowed at the same time.");
            }
        }

        Tuple<JwkSetLoader.JwksAlgs, JwkSetLoader.JwksAlgs> getAllJwksAlgs() {
            JwkSetLoader.JwksAlgs jwksAlgsHmac = this.hmacJwtSignatureValidator == null ? new JwkSetLoader.JwksAlgs(List.of(), List.of()) : this.hmacJwtSignatureValidator.jwksAlgs;
            JwkSetLoader.JwksAlgs jwksAlgsPkc = this.pkcJwtSignatureValidator == null ? new JwkSetLoader.JwksAlgs(List.of(), List.of()) : this.pkcJwtSignatureValidator.jwkSetLoader.getContentAndJwksAlgs().jwksAlgs();
            return new Tuple((Object)jwksAlgsHmac, (Object)jwksAlgsPkc);
        }
    }
}

