/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.rate.Rate;

public class InternalResetTrackingRate
extends InternalNumericMetricsAggregation.SingleValue
implements Rate {
    public static final String NAME = "rate_with_resets";
    private static final int MILLIS_IN_SECOND = 1000;
    private final double startValue;
    private final double endValue;
    private final long startTime;
    private final long endTime;
    private final double resetCompensation;
    private final Rounding.DateTimeUnit rateUnit;

    protected InternalResetTrackingRate(String name, DocValueFormat format, Map<String, Object> metadata, double startValue, double endValue, long startTime, long endTime, double resetCompensation, Rounding.DateTimeUnit rateUnit) {
        super(name, format, metadata);
        this.startValue = startValue;
        this.endValue = endValue;
        this.startTime = startTime;
        this.endTime = endTime;
        this.resetCompensation = resetCompensation;
        this.rateUnit = Objects.requireNonNull(rateUnit);
    }

    public InternalResetTrackingRate(StreamInput in) throws IOException {
        super(in, false);
        this.startValue = in.readDouble();
        this.endValue = in.readDouble();
        this.startTime = in.readLong();
        this.endTime = in.readLong();
        this.resetCompensation = in.readDouble();
        this.rateUnit = Rounding.DateTimeUnit.resolve((byte)in.readByte());
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.startValue);
        out.writeDouble(this.endValue);
        out.writeLong(this.startTime);
        out.writeLong(this.endTime);
        out.writeDouble(this.resetCompensation);
        if (this.rateUnit != null) {
            out.writeByte(this.rateUnit.getId());
        } else {
            out.writeByte(Rounding.DateTimeUnit.SECOND_OF_MINUTE.getId());
        }
    }

    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        final ArrayList aggregations = new ArrayList(size);
        return new AggregatorReducer(){

            public void accept(InternalAggregation aggregation) {
                aggregations.add((InternalResetTrackingRate)aggregation);
            }

            public InternalAggregation get() {
                List<InternalResetTrackingRate> toReduce = aggregations.stream().sorted(Comparator.comparingLong(o -> o.startTime)).toList();
                double resetComp = toReduce.get((int)0).resetCompensation;
                double startValue = toReduce.get((int)0).startValue;
                double endValue = toReduce.get((int)0).endValue;
                int endIndex = toReduce.size() - 1;
                for (int i = 1; i < endIndex + 1; ++i) {
                    InternalResetTrackingRate rate = toReduce.get(i);
                    assert (rate.startTime >= toReduce.get((int)(i - 1)).endTime);
                    resetComp += rate.resetCompensation;
                    if (endValue > rate.startValue) {
                        resetComp += endValue;
                    }
                    endValue = rate.endValue;
                }
                return new InternalResetTrackingRate(InternalResetTrackingRate.this.name, InternalResetTrackingRate.this.format, InternalResetTrackingRate.this.metadata, startValue, endValue, toReduce.get((int)0).startTime, toReduce.get((int)endIndex).endTime, resetComp, toReduce.get((int)0).rateUnit);
            }
        };
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value());
    }

    public double value() {
        long rateUnitSeconds = this.rateUnit.getField().getBaseUnit().getDuration().toSeconds();
        return (this.endValue - this.startValue + this.resetCompensation) / (double)(this.endTime - this.startTime) * 1000.0 * (double)rateUnitSeconds;
    }

    @Override
    public double getValue() {
        return this.value();
    }

    boolean includes(InternalResetTrackingRate other) {
        return this.startTime < other.startTime && this.endTime > other.endTime;
    }
}

