/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCounted;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.transport.Transports;

public class Netty4HttpHeaderValidator
extends ChannelDuplexHandler {
    private final HttpValidator validator;
    private final ThreadContext threadContext;
    private State state = State.PASSING;
    private final ArrayDeque<Object> buffer = new ArrayDeque();

    public Netty4HttpHeaderValidator(HttpValidator validator, ThreadContext threadContext) {
        this.validator = validator;
        this.threadContext = threadContext;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.state == State.VALIDATING || this.buffer.size() > 0) {
            this.buffer.offerLast(msg);
            return;
        }
        assert (msg instanceof HttpObject);
        HttpObject httpObject = (HttpObject)msg;
        if (httpObject.decoderResult().isFailure()) {
            ctx.fireChannelRead((Object)httpObject);
        } else if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            this.validate(ctx, httpRequest);
        } else if (this.state == State.PASSING) {
            assert (msg instanceof HttpContent);
            ctx.fireChannelRead(msg);
        } else {
            assert (this.state == State.DROPPING) : this.state;
            assert (msg instanceof HttpContent);
            HttpContent httpContent = (HttpContent)msg;
            httpContent.release();
            ctx.read();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.buffer.size() == 0) {
            ctx.fireChannelReadComplete();
        }
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (this.state != State.VALIDATING) {
            if (this.buffer.size() > 0) {
                Object message = this.buffer.pollFirst();
                if (message instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)message;
                    if (httpRequest.decoderResult().isFailure()) {
                        ctx.fireChannelRead(message);
                        ctx.fireChannelReadComplete();
                    } else {
                        this.validate(ctx, httpRequest);
                    }
                } else {
                    assert (message instanceof HttpContent);
                    assert (this.state == State.PASSING) : this.state;
                    ctx.fireChannelRead(message);
                    ctx.fireChannelReadComplete();
                }
            } else {
                ctx.read();
            }
        }
    }

    void validate(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        ValidationResultListener validationResultListener = new ValidationResultListener(ctx, httpRequest);
        SubscribableListener.newForked(validationResultListener::doValidate).addListener((ActionListener)validationResultListener, (Executor)ctx.channel().eventLoop(), null);
    }

    private static enum State {
        PASSING,
        VALIDATING,
        DROPPING;

    }

    private class ValidationResultListener
    implements ActionListener<Void> {
        private final ChannelHandlerContext ctx;
        private final HttpRequest httpRequest;

        ValidationResultListener(ChannelHandlerContext ctx, HttpRequest httpRequest) {
            this.ctx = ctx;
            this.httpRequest = httpRequest;
        }

        void doValidate(ActionListener<Void> listener) {
            assert (Transports.assertDefaultThreadContext((ThreadContext)Netty4HttpHeaderValidator.this.threadContext));
            assert (this.ctx.channel().eventLoop().inEventLoop());
            assert (Netty4HttpHeaderValidator.this.state == State.PASSING || Netty4HttpHeaderValidator.this.state == State.DROPPING) : Netty4HttpHeaderValidator.this.state;
            Netty4HttpHeaderValidator.this.state = State.VALIDATING;
            try (ThreadContext.StoredContext ignore = Netty4HttpHeaderValidator.this.threadContext.newEmptyContext();){
                Netty4HttpHeaderValidator.this.validator.validate(this.httpRequest, this.ctx.channel(), (ActionListener<Void>)new ContextPreservingActionListener(() -> ((ThreadContext)Netty4HttpHeaderValidator.this.threadContext).newEmptyContext(), listener));
            }
        }

        public void onResponse(Void unused) {
            assert (Transports.assertDefaultThreadContext((ThreadContext)Netty4HttpHeaderValidator.this.threadContext));
            assert (this.ctx.channel().eventLoop().inEventLoop());
            assert (Netty4HttpHeaderValidator.this.state == State.VALIDATING) : Netty4HttpHeaderValidator.this.state;
            Netty4HttpHeaderValidator.this.state = State.PASSING;
            this.fireChannelRead();
        }

        public void onFailure(Exception e) {
            assert (Transports.assertDefaultThreadContext((ThreadContext)Netty4HttpHeaderValidator.this.threadContext));
            assert (this.ctx.channel().eventLoop().inEventLoop());
            assert (Netty4HttpHeaderValidator.this.state == State.VALIDATING) : Netty4HttpHeaderValidator.this.state;
            this.httpRequest.setDecoderResult(DecoderResult.failure((Throwable)e));
            Netty4HttpHeaderValidator.this.state = State.DROPPING;
            while (!Netty4HttpHeaderValidator.this.buffer.isEmpty() && !(Netty4HttpHeaderValidator.this.buffer.peekFirst() instanceof HttpRequest)) {
                assert (Netty4HttpHeaderValidator.this.buffer.peekFirst() instanceof HttpContent);
                ((ReferenceCounted)Netty4HttpHeaderValidator.this.buffer.pollFirst()).release();
            }
            this.fireChannelRead();
        }

        private void fireChannelRead() {
            this.ctx.fireChannelRead((Object)this.httpRequest);
            this.ctx.fireChannelReadComplete();
        }
    }
}

