/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.internal.common.CloseableHandle;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.internal.panama.headers_h;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

final class CuVSParamsHelper {
    private CuVSParamsHelper() {
    }

    static CloseableHandle createCagraIndexParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsCagraIndexParams_t);
            Util.checkCuVSError(headers_h.cuvsCagraIndexParamsCreate(paramsPtrPtr), "cuvsCagraIndexParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsCagraIndexParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsCagraIndexParamsDestroy(paramsPtr), "cuvsCagraIndexParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }

    static CloseableHandle createCagraCompressionParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsCagraCompressionParams_t);
            Util.checkCuVSError(headers_h.cuvsCagraCompressionParamsCreate(paramsPtrPtr), "cuvsCagraCompressionParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsCagraCompressionParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsCagraCompressionParamsDestroy(paramsPtr), "cuvsCagraCompressionParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }

    static CloseableHandle createIvfPqIndexParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsIvfPqIndexParams_t);
            Util.checkCuVSError(headers_h.cuvsIvfPqIndexParamsCreate(paramsPtrPtr), "cuvsIvfPqIndexParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsIvfPqIndexParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsIvfPqIndexParamsDestroy(paramsPtr), "cuvsIvfPqIndexParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }

    static CloseableHandle createIvfPqSearchParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsIvfPqSearchParams_t);
            Util.checkCuVSError(headers_h.cuvsIvfPqSearchParamsCreate(paramsPtrPtr), "cuvsIvfPqSearchParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsIvfPqSearchParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsIvfPqSearchParamsDestroy(paramsPtr), "cuvsIvfPqSearchParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }

    static CloseableHandle createCagraMergeParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsCagraMergeParams_t);
            Util.checkCuVSError(headers_h.cuvsCagraMergeParamsCreate(paramsPtrPtr), "cuvsCagraMergeParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsCagraMergeParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsCagraMergeParamsDestroy(paramsPtr), "cuvsCagraMergeParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }

    static CloseableHandle createHnswIndexParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsHnswIndexParams_t);
            Util.checkCuVSError(headers_h.cuvsHnswIndexParamsCreate(paramsPtrPtr), "cuvsHnswIndexParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsHnswIndexParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsHnswIndexParamsDestroy(paramsPtr), "cuvsHnswIndexParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }

    static CloseableHandle createTieredIndexParams() {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment paramsPtrPtr = localArena.allocate(headers_h.cuvsTieredIndexParams_t);
            Util.checkCuVSError(headers_h.cuvsTieredIndexParamsCreate(paramsPtrPtr), "cuvsTieredIndexParamsCreate");
            final MemorySegment paramsPtr = paramsPtrPtr.get(headers_h.cuvsTieredIndexParams_t, 0L);
            CloseableHandle closeableHandle = new CloseableHandle(){

                @Override
                public MemorySegment handle() {
                    return paramsPtr;
                }

                @Override
                public void close() {
                    Util.checkCuVSError(headers_h.cuvsTieredIndexParamsDestroy(paramsPtr), "cuvsTieredIndexParamsDestroy");
                }
            };
            return closeableHandle;
        }
    }
}

